// Made by ChatGPT
import {changeMat} from "./octahedron_buffered_image.mjs";

function makeBufferedImage(dimX, dimY, text) {
    console.log("-- makeBufferedImage: " + dimX + "x" + dimY);

    const BufferedImage = Java.type("java.awt.image.BufferedImage");
    const Color = Java.type("java.awt.Color");
    const GradientPaint = Java.type("java.awt.GradientPaint");
    const Font = Java.type("java.awt.Font");
    const RenderingHints = Java.type("java.awt.RenderingHints");
    const BasicStroke = Java.type("java.awt.BasicStroke");
    const Polygon = Java.type("java.awt.Polygon");

    let image = new BufferedImage(dimX, dimY, BufferedImage.TYPE_INT_RGB);
    let g2 = image.getGraphics();

    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    // Gradient background
    let gradient = new GradientPaint(0, 0, Color.CYAN, dimX, dimY, Color.MAGENTA);
    g2.setPaint(gradient);
    g2.fillRect(0, 0, dimX, dimY);

    console.log("-- makeBufferedImage 2: " + dimX + "x" + dimY);
    // Draw Star of David (Hexagram)
    function drawStarOfDavid(centerX, centerY, radius) {
        function createTrianglePoints(angleOffset) {
            let triangle = new Polygon();
            for (let i = 0; i < 3; i++) {
                let angle = angleOffset + i * 2 * Math.PI / 3;
                let x = centerX + radius * Math.cos(angle);
                let y = centerY + radius * Math.sin(angle);
                triangle.addPoint(Math.round(x), Math.round(y));
            }
            return triangle;
        }

        let upTriangle = createTrianglePoints(-Math.PI / 2);     // pointing up
        let downTriangle = createTrianglePoints(Math.PI / 2);    // pointing down

        // Background fill: green with transparency
        g2.setColor(new Color(0, 200, 0, 128));
        g2.fillPolygon(upTriangle);
        g2.fillPolygon(downTriangle);

        // Outline: white
        g2.setStroke(new BasicStroke(3.0));
        g2.setColor(Color.WHITE);
        g2.drawPolygon(upTriangle);
        g2.drawPolygon(downTriangle);
    }

    // Draw the hexagram behind the text
    let radius = Math.min(dimX, dimY) / 4;
    drawStarOfDavid(dimX / 2, dimY / 2, radius);
    console.log("-- makeBufferedImage 3: " + dimX + "x" + dimY);

    // Draw centered text
    let font = new Font("Serif", Font.BOLD, Math.floor(dimY / 10));
    g2.setFont(font);
    console.log("-- makeBufferedImage 4: " + dimX + "x" + dimY);

    let fm = g2.getFontMetrics();
    let textWidth = fm.stringWidth(text);
    let textHeight = fm.getAscent();

    let x = (dimX - textWidth) / 2;
    let y = (dimY + textHeight) / 2;

    // Shadow
    console.log("-- makeBufferedImage 5: " + dimX + "x" + dimY);
    g2.setColor(Color.DARK_GRAY);
    g2.drawString(text, Math.round(x + 3), Math.round(y + 3));
    console.log("-- makeBufferedImage 6: " + dimX + "x" + dimY);

    // Main text
    g2.setColor(Color.WHITE);
    g2.drawString(text, Math.round(x), Math.round(y));

    console.log("-- makeBufferedImage 7: " + dimX + "x" + dimY);
    g2.dispose();

    console.log("-- makeBufferedImage done");
    return image;
}

export function buildImage(dimX, dimY, text) {
    dimX = !dimX ? 1000 : parseInt(dimX)
    dimY = !dimY ? 1000 : parseInt(dimY)
    return makeBufferedImage(dimX, dimY, text)
}

export function execute(params, inputs, outputs) {
    outputs.m1 = buildImage(params.a, params.b, params.c)
    return "Hello, see results in \"m1\" output"
}

