/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.api.data;

public enum ValueType {
    STRING("string"),
    BOOLEAN("boolean"),
    BYTE("byte"),
    SHORT("short"),
    INT("int"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("double"),
    MAT("mat"),
    NULL("null"),
    NUMBERS("numbers"),
    SETTINGS("settings");

    private String id;

    private ValueType(String id) {
        this.id = id;
    }

    public static ValueType from(String name) {
        String lcname = name.toLowerCase();
        if (lcname.equals("string") || lcname.equals("str") || lcname.equals("scalar")) {
            return STRING;
        }
        if (lcname.equals("bool") || lcname.equals("boolean")) {
            return BOOLEAN;
        }
        if (lcname.equals("byte") || lcname.equals("char")) {
            return BYTE;
        }
        if (lcname.equals("short") || lcname.equals("int16")) {
            return SHORT;
        }
        if (lcname.equals("int") || lcname.equals("integer") || lcname.equals("int32")) {
            return INT;
        }
        if (lcname.equals("int64") || lcname.equals("long")) {
            return LONG;
        }
        if (lcname.equals("float")) {
            return FLOAT;
        }
        if (lcname.equals("double")) {
            return DOUBLE;
        }
        if (lcname.equals("mat")) {
            return MAT;
        }
        if (lcname.equals("null")) {
            return NULL;
        }
        if (lcname.equals("numbers")) {
            return NUMBERS;
        }
        if (lcname.equals("settings")) {
            return SETTINGS;
        }
        throw new IllegalArgumentException(String.format("Failed parse value type name: '%s'", lcname));
    }

    public String toString() {
        return this.id;
    }
}

