/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.api.client;

import com.siams.stare.api.Any;
import com.siams.stare.api.Command;
import com.siams.stare.api.StareApi;
import com.siams.stare.api.url.UrlBuilder;
import com.siams.stare.api.url.UrlParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StareClient
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(StareClient.class.getCanonicalName());
    final StareApi rpc;
    protected String sessionId = null;
    protected String projectId = null;
    private Path chainPath = null;
    private Path configurationPath = null;
    private final Map<String, Object> inputs = new HashMap<String, Object>();
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final Map<String, Object> settings = new HashMap<String, Object>();
    private String settingBlock = "";
    private final Set<String> outputNames = new HashSet<String>();
    private final Map<String, Any> outputs = new ConcurrentHashMap<String, Any>();
    private boolean removeProjectOnExecute = true;
    private boolean removeSessionOnExecute = true;

    public StareClient(StareApi rpc) {
        this.rpc = rpc;
    }

    public StareClient setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public StareClient setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public StareClient setChain(Path path) {
        this.chainPath = path;
        return this;
    }

    public StareClient setConfiguration(Path path) {
        this.configurationPath = path;
        return this;
    }

    public StareClient addData(String name, String val) {
        this.data.put(name, val);
        return this;
    }

    public StareClient addData(String name, Path val) {
        return this.addData(name, val.toString());
    }

    public StareClient addData(String name, int val) {
        this.data.put(name, val);
        return this;
    }

    public StareClient addData(String name, Object val) {
        this.data.put(name, val);
        return this;
    }

    public StareClient addInput(String name, String val) {
        this.inputs.put(name, val);
        return this;
    }

    public StareClient addInput(String name, Path val) {
        return this.addInput(name, val.toString());
    }

    public StareClient addInput(String name, int val) {
        this.inputs.put(name, val);
        return this;
    }

    public StareClient addInput(String name, Object val) {
        this.inputs.put(name, val);
        return this;
    }

    public StareClient clearInput() {
        this.inputs.clear();
        return this;
    }

    public StareClient addSetting(String name, Object val) {
        this.settings.put(name, val);
        return this;
    }

    public StareClient clearSetting() {
        this.settings.clear();
        return this;
    }

    public <T> CompletableFuture<T> apply(String name, Class<T> clazz) {
        return this.addRequiredOutput(name).rqSendDataAndExecute().thenApply(stare -> stare.getOutput(name, clazz).get());
    }

    public CompletableFuture<Void> apply() {
        return this.rqSendDataAndExecute().thenApply(stare -> null);
    }

    public CompletableFuture<StareClient> rqSendData() {
        long t0 = System.currentTimeMillis();
        logger.config("StareClient:execute:" + t0);
        AtomicLong total = new AtomicLong(0L);
        return ((CompletableFuture)((CompletableFuture)this.deferProjectUrl().thenCompose(projectUrl -> CompletableFuture.allOf((CompletableFuture[])new ArrayList<String>(this.data.keySet()).stream().filter(name -> !name.isEmpty()).map(name -> this.rpc.setData(this.getDataUrl((String)name), this.data.get(name))).toArray(CompletableFuture[]::new)).thenApply(v -> projectUrl))).thenCompose(projectUrl -> CompletableFuture.allOf((CompletableFuture[])new ArrayList<String>(this.inputs.keySet()).stream().filter(name -> !name.isEmpty()).map(name -> this.rpc.setData(this.getInputUrl((String)name), this.inputs.get(name))).toArray(CompletableFuture[]::new)).thenApply(v -> projectUrl))).thenCompose(projectUrl -> {
            logger.log(Level.CONFIG, () -> {
                long dt = System.currentTimeMillis() - t0 - total.get();
                total.addAndGet(dt);
                return String.format("send input data: %d (%d) ms", dt, total.get());
            });
            return CompletableFuture.allOf((CompletableFuture[])new ArrayList<String>(this.settings.keySet()).stream().filter(settingUrl -> !settingUrl.isEmpty()).map(settingUrl -> this.rpc.setData(this.getSettingUrl((String)settingUrl), this.settings.get(settingUrl))).toArray(CompletableFuture[]::new)).thenApply(v -> this);
        });
    }

    public CompletableFuture<StareClient> rqExecute() {
        long t0 = System.currentTimeMillis();
        logger.config("StareClient:rqExecute:" + t0);
        AtomicLong total = new AtomicLong(0L);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.rpc.executeCommand(UrlBuilder.sessionProject(this.sessionId, this.projectId), Command.EVALUATE).thenApply(v -> UrlBuilder.sessionProject(this.sessionId, this.projectId))).thenCompose(projectUrl -> {
            logger.log(Level.CONFIG, () -> {
                long dt = System.currentTimeMillis() - t0 - total.get();
                total.addAndGet(dt);
                return String.format("execute: %d (%d) ms", dt, total.get());
            });
            return this.rpc.firstProjectEvaluationError((String)projectUrl).thenApply(opt -> {
                if (opt.isPresent()) {
                    throw new CompletionException(new RuntimeException(String.format("Error during evaluate project: %s, error: %s", projectUrl, opt.get())));
                }
                return projectUrl;
            });
        })).thenCompose(projectUrl -> {
            logger.log(Level.CONFIG, () -> {
                long dt = System.currentTimeMillis() - t0 - total.get();
                total.addAndGet(dt);
                return String.format("get error: %d (%d) ms", dt, total.get());
            });
            if (this.outputNames.isEmpty()) {
                return CompletableFuture.completedFuture(projectUrl);
            }
            CompletableFuture[] outputDataRequests = (CompletableFuture[])new ArrayList<String>(this.outputNames).stream().map(name -> this.rpc.getData(this.getOutputUrl((String)projectUrl, (String)name)).thenAccept(any -> this.outputs.put((String)name, (Any)any))).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(outputDataRequests).thenApply(v -> projectUrl);
        })).thenCompose(projectUrl -> {
            logger.log(Level.CONFIG, () -> {
                long dt = System.currentTimeMillis() - t0 - total.get();
                total.addAndGet(dt);
                return String.format("get outputs: %d (%d) ms", dt, total.get());
            });
            if (this.removeProjectOnExecute) {
                return this.rpc.remove((String)projectUrl).thenApply(ignore -> null);
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(v -> {
            if (this.removeProjectOnExecute) {
                logger.log(Level.CONFIG, () -> {
                    long dt = System.currentTimeMillis() - t0 - total.get();
                    total.addAndGet(dt);
                    return String.format("remove project: %d (%d) ms", dt, total.get());
                });
            }
            if (this.removeSessionOnExecute) {
                return this.rpc.remove(this.getSessionUrl()).thenApply(ignore -> null);
            }
            return CompletableFuture.completedFuture(null);
        })).thenApply(v -> {
            logger.log(Level.CONFIG, () -> {
                long dt = System.currentTimeMillis() - t0 - total.get();
                total.addAndGet(dt);
                return String.format("execute: %d (%d) ms", dt, total.get());
            });
            return this;
        });
    }

    public CompletableFuture<StareClient> rqSendDataAndExecute() {
        return this.rqSendData().thenCompose(client -> this.rqExecute());
    }

    protected CompletableFuture<String> deferProjectUrl() {
        String projectUrl = this.sessionId != null && this.projectId != null ? UrlBuilder.sessionProject(this.sessionId, this.projectId) : null;
        CompletableFuture<Boolean> projectStatusOnServer = projectUrl != null ? this.rpc.exists(projectUrl) : CompletableFuture.completedFuture(false);
        return ((CompletableFuture)projectStatusOnServer.thenCompose(exist -> exist != false ? CompletableFuture.completedFuture(projectUrl) : this.rqCreateProject())).thenApply(url -> {
            this.setProjectUrl((String)url);
            return url;
        });
    }

    public String getProjectUrl() {
        return UrlBuilder.sessionProject(this.getSessionId(), this.getProjectId());
    }

    private String getSessionUrl() {
        return UrlBuilder.session(this.getSessionId());
    }

    private String getSessionId() {
        this.sessionId = this.sessionId == null ? UUID.randomUUID().toString() : this.sessionId;
        return this.sessionId;
    }

    private String getProjectId() {
        this.projectId = this.projectId == null ? UUID.randomUUID().toString() : this.projectId;
        return this.projectId;
    }

    public CompletableFuture<String> rqCreateProject() {
        logger.info(String.format("%s: rqCreateProject()", this.getClass().getCanonicalName()));
        return ((CompletableFuture)((CompletableFuture)this.rpc.createSessionIfNecessary(this.getSessionId()).thenCompose(sessionUrl -> {
            String url = UrlBuilder.sessionProject(this.getSessionId(), this.getProjectId());
            return this.rpc.createProjectIfNecessary(url);
        })).thenCompose(projectUrl -> this.rpc.uploadProject((String)projectUrl, this.chainPath.toFile()).thenApply(v -> projectUrl))).thenCompose(projectUrl -> {
            logger.info("Project created: " + projectUrl);
            if (this.configurationPath != null && Files.isRegularFile(this.configurationPath, new LinkOption[0])) {
                return this.rpc.uploadProjectConfiguration((String)projectUrl, this.configurationPath.toFile()).thenApply(v -> projectUrl);
            }
            return CompletableFuture.completedFuture(projectUrl);
        });
    }

    protected String getInputUrl(String inputName) {
        return UrlBuilder.sessionProjectInput(this.sessionId, this.projectId, inputName);
    }

    protected String getDataUrl(String name) {
        return UrlBuilder.sessionProjectData(this.sessionId, this.projectId, name);
    }

    protected String getSettingUrl(String settingName) {
        return this.settingBlock.isEmpty() ? String.format("%s%s", this.getProjectUrl(), settingName) : UrlBuilder.sessionProjectWorkerProperty(this.sessionId, this.projectId, this.settingBlock, settingName);
    }

    protected String getOutputUrl(String projectUrl, String outputName) {
        return UrlBuilder.sessionProjectOutput(this.sessionId, this.projectId, outputName);
    }

    public StareClient addRequiredOutput(String name) {
        this.outputNames.add(name);
        return this;
    }

    public StareClient clearRequiredOutput() {
        this.outputNames.clear();
        return this;
    }

    public <T> Optional<T> getOutput(String name, Class<T> clazz) {
        return this.outputs.get(name).getData(clazz);
    }

    @Override
    public void close() throws Exception {
        this.rpc.remove(this.getProjectUrl()).get();
    }

    public StareClient setProjectUrl(String projectUrl) {
        UrlParser parser = new UrlParser(projectUrl);
        String sessionId = parser.getSessionId();
        String projectId = parser.getProjectId();
        this.setSessionId(sessionId);
        this.setProjectId(projectId);
        return this;
    }

    public StareClient setRemoveProjectOnExecute(boolean removeProjectOnExecute) {
        this.removeProjectOnExecute = removeProjectOnExecute;
        return this;
    }

    public StareClient setRemoveSessionOnExecute(boolean removeSessionOnExecute) {
        this.removeSessionOnExecute = removeSessionOnExecute;
        return this;
    }

    public StareClient setSettingBlock(String settingBlock) {
        this.settingBlock = settingBlock;
        return this;
    }

    public String getSettingBlock() {
        return this.settingBlock;
    }
}

