/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.api;

import com.siams.stare.api.Any;
import com.siams.stare.api.Command;
import com.siams.stare.api.CommandStatus;
import com.siams.stare.api.ObjectStatus;
import com.siams.stare.api.ResourceFilter;
import com.siams.stare.api.data.ErrorInfo;
import com.siams.stare.api.data.setting.Setting;
import com.siams.stare.api.data.setting.SettingTree;
import com.siams.stare.api.data.worker.Worker;
import com.siams.stare.api.url.UrlBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;

public interface StareApi {
    public CompletableFuture<Void> updateLink(String var1, String var2, String var3);

    public CompletableFuture<String> createLink(String var1, String var2, String var3);

    public CompletableFuture<String> createWorker(String var1, String var2);

    public CompletableFuture<Void> createSession(String var1);

    default public CompletableFuture<String> createSessionIfNecessary(String sessionId) {
        String sessionUrl = UrlBuilder.session(sessionId);
        return this.exists(sessionUrl).thenCompose(exist -> exist != false ? CompletableFuture.completedFuture(sessionUrl) : this.createSession(sessionId).thenApply(v -> sessionUrl));
    }

    public CompletableFuture<String> createProject(String var1);

    default public CompletableFuture<String> createProjectIfNecessary(String url) {
        return this.exists(url).thenCompose(exist -> exist != false ? CompletableFuture.completedFuture(url) : this.createProject(url));
    }

    public CompletableFuture<Void> uploadProject(String var1, File var2);

    public CompletableFuture<Void> loadSolution(String var1, String var2);

    public CompletableFuture<Void> loadSolution(String var1, String var2, String var3);

    public CompletableFuture<Void> loadSolutionTemplate(String var1, String var2);

    @Deprecated
    public CompletableFuture<Void> uploadConfiguration(String var1, File var2);

    public CompletableFuture<Void> uploadProjectConfiguration(String var1, File var2);

    public CompletableFuture<Any> getProjectConfiguration(String var1);

    public CompletableFuture<Any> getProjectConfigurationSettings(String var1);

    public CompletableFuture<List<String>> getList(String var1);

    public CompletableFuture<List<String>> getList(String var1, ResourceFilter var2);

    public CompletableFuture<Boolean> exists(String var1);

    public CompletableFuture<List<Any>> exists(List<String> var1);

    public CompletableFuture<CommandStatus> executeCommand(String var1, Command var2);

    public CompletableFuture<Void> executeCommand(List<String> var1, Command var2);

    public CompletableFuture<List<String>> remove(String var1);

    public CompletableFuture<List<String>> remove(List<String> var1);

    public CompletableFuture<Void> setData(String var1, boolean var2);

    public CompletableFuture<Void> setData(String var1, int var2);

    public CompletableFuture<Void> setData(String var1, double var2);

    public CompletableFuture<Void> setData(String var1, long var2);

    public CompletableFuture<Void> setData(String var1, byte[] var2);

    public CompletableFuture<Void> setData(String var1, String var2);

    public CompletableFuture<Void> setData(String var1, SNumbers var2);

    public CompletableFuture<Void> setData(String var1, SMat var2);

    public CompletableFuture<Void> setData(String var1, Object var2);

    public CompletableFuture<List<Any>> getData(List<String> var1);

    public CompletableFuture<Any> getData(String var1);

    default public <T> CompletableFuture<T> getData(String url, Class<T> clazz) {
        return this.getData(url).thenApply(any -> any.getData(clazz).map(value -> value).orElseThrow(() -> new CompletionException(new RuntimeException(String.format("Data not found: %s", url)))));
    }

    public static String extractUrlId(String url) {
        int index = url.lastIndexOf(":");
        int end = url.lastIndexOf("/");
        if (end != -1 && end > index) {
            return url.substring(index != -1 ? index + 1 : 0, end);
        }
        return url.substring(index != -1 ? index + 1 : 0);
    }

    default public <T> CompletableFuture<T> getDataIfExist(String url, T def) {
        return this.exists(url).thenCompose(exists -> (exists != false ? this.getData(url) : CompletableFuture.completedFuture(new Any(StareApi.extractUrlId(url), def))).thenCompose(any -> CompletableFuture.completedFuture(any.getData(def.getClass()).map(value -> value).orElseThrow(() -> new CompletionException(new RuntimeException("Failed extract typed data"))))));
    }

    public CompletableFuture<ObjectStatus> getObjectStatus(String var1);

    public CompletableFuture<List<Any>> getObjectsStatus(List<String> var1);

    default public CompletableFuture<Any> getExecutionStatus(String url) {
        return this.getData(String.format("%s/execution_status", url));
    }

    default public CompletableFuture<List<String>> projectEvaluationErrors(String projectUrl) {
        return ((CompletableFuture)this.getList(String.format("%s/error", projectUrl)).thenCompose(this::getData)).thenApply(items -> items.stream().map(any -> any.getData().map(data -> {
            if (data instanceof String) {
                return (String)data;
            }
            if (data instanceof ErrorInfo) {
                return ((ErrorInfo)data).error_message;
            }
            return "";
        }).orElse("")).collect(Collectors.toList()));
    }

    default public CompletableFuture<Optional<String>> firstProjectEvaluationError(String projectUrl) {
        return this.getList(String.format("%s/error", projectUrl)).thenCompose(errors -> {
            if (errors.isEmpty()) {
                CompletableFuture result = new CompletableFuture();
                result.complete(Optional.empty());
                return result;
            }
            return this.getData((String)errors.get(0)).thenApply(any -> Optional.ofNullable(any.getData().map(data -> {
                if (data instanceof String) {
                    return (String)data;
                }
                if (data instanceof ErrorInfo) {
                    return ((ErrorInfo)data).error_message;
                }
                return null;
            }).orElse(null)));
        });
    }

    default public CompletableFuture<Optional<ErrorInfo>> firstProjectEvaluationErrorInfo(String projectUrl) {
        return this.getList(String.format("%s/error", projectUrl)).thenCompose(errors -> {
            if (errors.isEmpty()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return this.getData((String)errors.get(0)).thenApply(any -> any.getData().map(data -> {
                if (data instanceof String) {
                    String s = (String)data;
                    return new ErrorInfo(s, "", "");
                }
                if (data instanceof ErrorInfo) {
                    ErrorInfo ei = (ErrorInfo)data;
                    return ei;
                }
                return null;
            }));
        });
    }

    default public CompletableFuture<SettingTree> projectSettingTree(String projectUrl) {
        return ((CompletableFuture)this.getList(String.format("%s/setting", projectUrl)).thenCompose(urls -> this.getData((List<String>)urls))).thenApply(list -> {
            SettingTree tree = new SettingTree();
            list.stream().filter(any -> any.getData(Worker.class).isPresent() || any.getData(Setting.class).isPresent()).map(any -> {
                Optional<Setting> optSetting = any.getData(Setting.class);
                Optional<Worker> optWorker = any.getData(Worker.class);
                if (optSetting.isPresent()) {
                    Setting setting = optSetting.get();
                    setting.parentId = setting.parentId.isEmpty() ? "settings" : setting.parentId;
                    setting.controls.forEach(control -> {
                        control.url = control.getPropertyUrl(setting);
                    });
                    return setting;
                }
                if (optWorker.isPresent()) {
                    Worker worker = optWorker.get();
                    Setting setting = new Setting();
                    setting.id = worker.id;
                    setting.modelId = worker.model.id;
                    setting.modelUrl = worker.model.url;
                    setting.name = !worker.systemName.isEmpty() ? worker.systemName : worker.name;
                    setting.description = worker.model.description;
                    String parentId = "";
                    if (worker.model.isInput()) {
                        parentId = "inputs";
                    } else if (worker.model.isData()) {
                        parentId = "data";
                    } else if (worker.model.isOutput()) {
                        parentId = "outputs";
                    }
                    setting.parentId = parentId;
                    setting.controls = worker.model.controls;
                    return setting;
                }
                return null;
            }).filter(Objects::nonNull).forEach(tree::addItem);
            tree.buildTree();
            return tree;
        });
    }

    default public CompletableFuture<List<Any>> projectSettings(String projectUrl) {
        List resources = Collections.synchronizedList(new ArrayList());
        return ((CompletableFuture)this.getList(String.format("%s/setting", projectUrl)).thenCompose(urls -> CompletableFuture.allOf((CompletableFuture[])urls.stream().map(url -> this.getData((String)url).thenAccept(resources::add)).toArray(CompletableFuture[]::new)))).thenApply(v -> resources);
    }
}

