/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tags;

public class TagTypes {
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int IFD = 13;
    public static final int LONG8 = 16;
    public static final int SLONG8 = 17;
    public static final int IFD8 = 18;

    private TagTypes() {
    }

    public static String typeToString(int tagType) {
        return switch (tagType) {
            case 1 -> "BYTE";
            case 2 -> "ASCII";
            case 3 -> "SHORT";
            case 4 -> "LONG";
            case 5 -> "RATIONAL";
            case 6 -> "SBYTE";
            case 7 -> "UNDEFINED";
            case 8 -> "SSHORT";
            case 9 -> "SLONG";
            case 10 -> "SRATIONAL";
            case 11 -> "FLOAT";
            case 12 -> "DOUBLE";
            case 13 -> "IFD";
            case 16 -> "LONG8";
            case 17 -> "SLONG8";
            case 18 -> "IFD8";
            default -> "Unknown type (" + tagType + ")";
        };
    }

    public static int sizeOfType(int tagType) {
        return switch (tagType) {
            case 1, 2, 6, 7 -> 1;
            case 3, 8 -> 2;
            case 4, 9, 11, 13 -> 4;
            case 5, 10, 12, 16, 17, 18 -> 8;
            default -> 0;
        };
    }
}

