/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tags;

public class TagRational
extends Number
implements Comparable<TagRational> {
    private final long numer;
    private final long denom;

    public TagRational(long numer, long denom) {
        this.numer = numer;
        this.denom = denom;
    }

    public long getNumerator() {
        return this.numer;
    }

    public long getDenominator() {
        return this.denom;
    }

    @Override
    public byte byteValue() {
        return (byte)this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.denom == 0L ? Double.MAX_VALUE : (double)this.numer / (double)this.denom;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.denom == 0L ? Long.MAX_VALUE : this.numer / this.denom;
    }

    @Override
    public short shortValue() {
        return (short)this.longValue();
    }

    public boolean equals(Object o) {
        return o instanceof TagRational && this.compareTo((TagRational)o) == 0;
    }

    public int hashCode() {
        return (int)(this.numer - this.denom);
    }

    public String toString() {
        return this.numer + "/" + this.denom;
    }

    @Override
    public int compareTo(TagRational q) {
        long diff = this.numer * q.denom - q.numer * this.denom;
        if (diff > Integer.MAX_VALUE) {
            diff = Integer.MAX_VALUE;
        } else if (diff < Integer.MIN_VALUE) {
            diff = Integer.MIN_VALUE;
        }
        return (int)diff;
    }
}

