/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tags;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

class TagFriendlyNames {
    static final Map<Integer, String> TAG_NAMES = TagFriendlyNames.buildTagNames();

    private TagFriendlyNames() {
    }

    private static Map<Integer, String> buildTagNames() {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (String javaConstant : NamedConstantsHolder.SOURCE_CODE_WITH_IFD_TAG_NAMES) {
            TagFriendlyNames.addTagName(result, javaConstant);
        }
        return result;
    }

    private static void addTagName(Map<Integer, String> map, String line) {
        int p = line.indexOf("//");
        if (p != -1) {
            line = line.substring(0, p);
        }
        if ((line = line.trim()).isEmpty()) {
            return;
        }
        p = line.indexOf("=");
        assert (p != -1);
        String name = line.substring(0, p);
        String id = line.substring(p + 1);
        name = NamedConstantsHolder.BEGIN_PATTERN.matcher(name).replaceAll("").trim();
        if (!NamedConstantsHolder.NAME_REQUIREMENT_PATTERN.matcher(name = NamedConstantsHolder.NAME_UNDERLINE_PATTERN.matcher(name).replaceAll("_")).matches()) {
            throw new AssertionError((Object)("Not allowed name: " + name));
        }
        id = NamedConstantsHolder.END_PATTERN.matcher(id).replaceAll("").trim();
        map.put(Integer.parseInt(id), name);
    }

    private static class NamedConstantsHolder {
        private static final Pattern BEGIN_PATTERN = Pattern.compile("^[\\w\\s]*\\sint\\s");
        private static final Pattern END_PATTERN = Pattern.compile("\\s*;\\s*$");
        private static final Pattern NAME_UNDERLINE_PATTERN = Pattern.compile("[\\s./]+");
        private static final Pattern NAME_REQUIREMENT_PATTERN = Pattern.compile("\\w+");
        private static final String[] SOURCE_CODE_WITH_IFD_TAG_NAMES = "NewSubfileType = 254;\nSubfileType = 255\nImageWidth = 256\nImageLength = 257\nBitsPerSample = 258\nCompression = 259\nPhotometricInterpretation = 262\nThresholding = 263\nCellWidth = 264\nCellLength = 265\nFillOrder = 266\nDocumentName = 269\nImageDescription = 270\nMake = 271\nModel = 272\nStripOffsets = 273\nOrientation = 274\nSamplesPerPixel = 277\nRowsPerStrip = 278\nStripByteCounts = 279\nMinSampleValue = 280\nMaxSampleValue = 281\nXResolution = 282\nYResolution = 283\nPlanarConfiguration = 284\nPageName = 285\nXPosition = 286\nYPosition = 287\nFreeOffsets = 288\nFreeByteCounts = 289\nGrayResponseUnit = 290\nGrayResponseCurve = 291\nT4Options = 292\nT6Options = 293\nResolutionUnit = 296\nPageNumber = 297\nTransferFunction = 301\nSoftware = 305\nDateTime = 306\nArtist = 315\nHostComputer = 316\nPredictor = 317\nWhitePoint = 318\nPrimaryChromaticities = 319\nColorMap = 320\nHalftoneHints = 321\nTileWidth = 322\nTileLength = 323\nTileOffsets = 324\nTileByteCounts = 325\nBadFaxLines = 326\nCleanFaxData = 327\nConsecutiveBadFaxLines = 328\nSubIFDs = 330\nInkSet = 332\nInkNames = 333\nNumberOfInks = 334\nDotRange = 336\nTargetPrinter = 337\nExtraSamples = 338\nSampleFormat = 339\nSMinSampleValue = 340\nSMaxSampleValue = 341\nTransferRange = 342\nClipPath = 343\nXClipPathUnits = 344\nYClipPathUnits = 345\nIndexed = 346\nJPEGTables = 347\nOPIProxy = 351\nGlobalParametersIFD = 400\nProfileType = 401\nFaxProfile = 402\nCodingMethods = 403\nVersionYear = 404\nModeNumber = 405\nDecode = 433\nDefaultImageColor = 434\nJPEGProc = 512\nJPEGInterchangeFormat = 513\nJPEGInterchangeFormatLength = 514\nJPEGRestartInterval = 515\nJPEGLosslessPredictors = 517\nJPEGPointTransforms = 518\nJPEGQTables = 519\nJPEGDCTables = 520\nJPEGACTables = 521\nYCbCrCoefficients = 529\nYCbCrSubSampling = 530\nYCbCrPositioning = 531\nReferenceBlackWhite = 532\nStripRowCounts = 559\nXMP = 700\nImage.Rating = 18246\nImage.RatingPercent = 18249\nImageID = 32781\nWang Annotation = 32932\nCFARepeatPatternDim = 33421\nCFAPattern = 33422\nBatteryLevel = 33423\nCopyright = 33432\nExposureTime = 33434\nFNumber = 33437\nMD FileTag = 33445\nMD ScalePixel = 33446\nMD ColorTable = 33447\nMD LabName = 33448\nMD SampleInfo = 33449\nMD PrepDate = 33450\nMD PrepTime = 33451\nMD FileUnits = 33452\nModelPixelScaleTag = 33550\nIPTC/NAA = 33723\nINGR Packet Data Tag = 33918\nINGR Flag Registers = 33919\nIrasB Transformation Matrix = 33920\nModelTiepointTag = 33922\nSite = 34016\nColorSequence = 34017\nIT8Header = 34018\nRasterPadding = 34019\nBitsPerRunLength = 34020\nBitsPerExtendedRunLength = 34021\nColorTable = 34022\nImageColorIndicator = 34023\nBackgroundColorIndicator = 34024\nImageColorValue = 34025\nBackgroundColorValue = 34026\nPixelIntensityRange = 34027\nTransparencyIndicator = 34028\nColorCharacterization = 34029\nHCUsage = 34030\nTrapIndicator = 34031\nCMYKEquivalent = 34032\nReserved = 34033\nReserved = 34034\nReserved = 34035\nModelTransformationTag = 34264\nPhotoshop = 34377\nExif IFD = 34665\nInterColorProfile = 34675\nImageLayer = 34732\nGeoKeyDirectoryTag = 34735\nGeoDoubleParamsTag = 34736\nGeoAsciiParamsTag = 34737\nExposureProgram = 34850\nSpectralSensitivity = 34852\nGPSTag = 34853\nISOSpeedRatings = 34855\nOECF = 34856\nInterlace = 34857\nTimeZoneOffset = 34858\nSelfTimeMode = 34859\nSensitivityType = 34864\nStandardOutputSensitivity = 34865\nRecommendedExposureIndex = 34866\nISOSpeed = 34867\nISOSpeedLatitudeyyy = 34868\nISOSpeedLatitudezzz = 34869\nHylaFAX FaxRecvParams = 34908\nHylaFAX FaxSubAddress = 34909\nHylaFAX FaxRecvTime = 34910\nExifVersion = 36864\nDateTimeOriginal = 36867\nDateTimeDigitized = 36868\nComponentsConfiguration = 37121\nCompressedBitsPerPixel = 37122\nShutterSpeedValue = 37377\nApertureValue = 37378\nBrightnessValue = 37379\nExposureBiasValue = 37380\nMaxApertureValue = 37381\nSubjectDistance = 37382\nMeteringMode = 37383\nLightSource = 37384\nFlash = 37385\nFocalLength = 37386\nFlashEnergy = 37387\nSpatialFrequencyResponse = 37388\nNoise = 37389\nFocalPlaneXResolution = 37390\nFocalPlaneYResolution = 37391\nFocalPlaneResolutionUnit = 37392\nImageNumber = 37393\nSecurityClassification = 37394\nImageHistory = 37395\nSubjectLocation = 37396\nExposureIndex = 37397\nTIFF/EPStandardID = 37398\nSensingMethod = 37399\nMakerNote = 37500\nUserComment = 37510\nSubsecTime = 37520\nSubsecTimeOriginal = 37521\nSubsecTimeDigitized = 37522\nImageSourceData = 37724\nXPTitle = 40091\nXPComment = 40092\nXPAuthor = 40093\nXPKeywords = 40094\nXPSubject = 40095\nFlashpixVersion = 40960\nColorSpace = 40961\nPixelXDimension = 40962\nPixelYDimension = 40963\nRelatedSoundFile = 40964\nInteroperability IFD = 40965\nFlashEnergy = 41483\nSpatialFrequencyResponse = 41484\nFocalPlaneXResolution = 41486\nFocalPlaneYResolution = 41487\nFocalPlaneResolutionUnit = 41488\nSubjectLocation = 41492\nExposureIndex = 41493\nSensingMethod = 41495\nFileSource = 41728\nSceneType = 41729\nCFAPattern = 41730\nCustomRendered = 41985\nExposureMode = 41986\nWhiteBalance = 41987\nDigitalZoomRatio = 41988\nFocalLengthIn35mmFilm = 41989\nSceneCaptureType = 41990\nGainControl = 41991\nContrast = 41992\nSaturation = 41993\nSharpness = 41994\nDeviceSettingDescription = 41995\nSubjectDistanceRange = 41996\nImageUniqueID = 42016\nCameraOwnerName = 42032\nBodySerialNumber = 42033\nLensSpecification = 42034\nLensMake = 42035\nLensModel = 42036\nLensSerialNumber = 42037\nGDAL_METADATA = 42112\nGDAL_NODATA = 42113\nPixelFormat = 48129\nTransformation = 48130\nUncompressed = 48131\nImageType = 48132\nImageWidth = 48256\nImageHeight = 48257\nWidthResolution = 48258\nHeightResolution = 48259\nImageOffset = 48320\nImageByteCount = 48321\nAlphaOffset = 48322\nAlphaByteCount = 48323\nImageDataDiscard = 48324\nAlphaDataDiscard = 48325\nImageType = 48132\nOce Scanjob Description = 50215\nOce Application Selector = 50216\nOce Identification Number = 50217\nOce ImageLogic Characteristics = 50218\nPrintImageMatching = 50341\nDNGVersion = 50706\nDNGBackwardVersion = 50707\nUniqueCameraModel = 50708\nLocalizedCameraModel = 50709\nCFAPlaneColor = 50710\nCFALayout = 50711\nLinearizationTable = 50712\nBlackLevelRepeatDim = 50713\nBlackLevel = 50714\nBlackLevelDeltaH = 50715\nBlackLevelDeltaV = 50716\nWhiteLevel = 50717\nDefaultScale = 50718\nDefaultCropOrigin = 50719\nDefaultCropSize = 50720\nColorMatrix1 = 50721\nColorMatrix2 = 50722\nCameraCalibration1 = 50723\nCameraCalibration2 = 50724\nReductionMatrix1 = 50725\nReductionMatrix2 = 50726\nAnalogBalance = 50727\nAsShotNeutral = 50728\nAsShotWhiteXY = 50729\nBaselineExposure = 50730\nBaselineNoise = 50731\nBaselineSharpness = 50732\nBayerGreenSplit = 50733\nLinearResponseLimit = 50734\nCameraSerialNumber = 50735\nLensInfo = 50736\nChromaBlurRadius = 50737\nAntiAliasStrength = 50738\nShadowScale = 50739\nDNGPrivateData = 50740\nMakerNoteSafety = 50741\nCalibrationIlluminant1 = 50778\nCalibrationIlluminant2 = 50779\nBestQualityScale = 50780\nRawDataUniqueID = 50781\nAlias Layer Metadata = 50784\nOriginalRawFileName = 50827\nOriginalRawFileData = 50828\nActiveArea = 50829\nMaskedAreas = 50830\nAsShotICCProfile = 50831\nAsShotPreProfileMatrix = 50832\nCurrentICCProfile = 50833\nCurrentPreProfileMatrix = 50834\nColorimetricReference = 50879\nCameraCalibrationSignature = 50931\nProfileCalibrationSignature = 50932\nExtraCameraProfiles = 50933\nAsShotProfileName = 50934\nNoiseReductionApplied = 50935\nProfileName = 50936\nProfileHueSatMapDims = 50937\nProfileHueSatMapData1 = 50938\nProfileHueSatMapData2 = 50939\nProfileToneCurve = 50940\nProfileEmbedPolicy = 50941\nProfileCopyright = 50942\nForwardMatrix1 = 50964\nForwardMatrix2 = 50965\nPreviewApplicationName = 50966\nPreviewApplicationVersion = 50967\nPreviewSettingsName = 50968\nPreviewSettingsDigest = 50969\nPreviewColorSpace = 50970\nPreviewDateTime = 50971\nRawImageDigest = 50972\nOriginalRawFileDigest = 50973\nSubTileBlockSize = 50974\nRowInterleaveFactor = 50975\nProfileLookTableDims = 50981\nProfileLookTableData = 50982\nOpcodeList1 = 51008\nOpcodeList2 = 51009\nOpcodeList3 = 51022\nNoiseProfile = 51041\nOriginalDefaultFinalSize = 51089\nOriginalBestQualityFinalSize = 51090\nOriginalDefaultCropSize = 51091\nProfileHueSatMapEncoding = 51107\nProfileLookTableEncoding = 51108\nBaselineExposureOffset = 51109\nDefaultBlackRender = 51110\nNewRawImageDigest = 51111\nRawToPreviewGain = 51112\nDefaultUserCrop = 51125\nMatteing = 32995\nDataType = 32996\nImageDepth = 32997\nTileDepth = 32998\nStoNits = 37439\n".split("\\n");

        private NamedConstantsHolder() {
        }
    }
}

