/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.executable;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffOpenMode;
import net.algart.matrices.tiff.TiffReader;

public class TiffInfo {
    TiffIFD.StringFormat stringFormat = TiffIFD.StringFormat.NORMAL;

    public static void main(String[] args) {
        int lastIFDIndex;
        TiffInfo info = new TiffInfo();
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-detailed")) {
            info.stringFormat = TiffIFD.StringFormat.DETAILED;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-json")) {
            info.stringFormat = TiffIFD.StringFormat.JSON;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 1) {
            System.out.println("Usage:");
            System.out.println("    " + TiffInfo.class.getName() + " [-strict] [-detailed|-json] some_tiff_file.tiff [firstIFDIndex lastIFDIndex]");
            return;
        }
        String fileName = args[startArgIndex];
        int firstIFDIndex = args.length > startArgIndex + 1 ? Integer.parseInt(args[startArgIndex + 1]) : 0;
        int n = lastIFDIndex = args.length > startArgIndex + 2 ? Integer.parseInt(args[startArgIndex + 2]) : Integer.MAX_VALUE;
        if (fileName.equals(".")) {
            Object[] files = new File(".").listFiles(TiffInfo::isPossiblyTIFF);
            assert (files != null);
            Arrays.sort(files);
            System.out.printf("Testing %d files%n", files.length);
            for (Object f : files) {
                info.showTiffInfoAndPrintException(((File)f).toPath(), firstIFDIndex, lastIFDIndex);
            }
        } else {
            info.showTiffInfoAndPrintException(Paths.get(fileName, new String[0]), firstIFDIndex, lastIFDIndex);
        }
    }

    public void showTiffInfo(Path tiffFile) throws IOException {
        this.showTiffInfo(tiffFile, 0, Integer.MAX_VALUE);
    }

    private void showTiffInfoAndPrintException(Path tiffFile, int firstIFDIndex, int lastIFDIndex) {
        try {
            this.showTiffInfo(tiffFile, firstIFDIndex, lastIFDIndex);
        }
        catch (IOException e) {
            System.err.printf("%nFile %s is invalid:%n  %s%n", tiffFile, e.getMessage());
        }
    }

    private void showTiffInfo(Path tiffFile, int firstIFDIndex, int lastIFDIndex) throws IOException {
        try (TiffReader reader = new TiffReader(tiffFile, TiffOpenMode.ALLOW_NON_TIFF);){
            if (reader.isTiff() != reader.isValidTiff()) {
                throw new AssertionError();
            }
            if (!reader.isTiff()) {
                Exception e = reader.openingException();
                System.out.printf("%nFile %s: not TIFF%s", tiffFile, e instanceof TiffException ? "" : "%n  (%s)".formatted(e == null ? "??" : e.getMessage()));
            } else {
                List<TiffIFD> ifdList = reader.allIFDs();
                int ifdCount = ifdList.size();
                firstIFDIndex = Math.max(firstIFDIndex, 0);
                lastIFDIndex = Math.min(lastIFDIndex, ifdCount - 1);
                System.out.printf("%nFile %s: %d images, %s, %s-endian%n", tiffFile, ifdCount, reader.isBigTiff() ? "BigTIFF" : "not BigTIFF", reader.isLittleEndian() ? "little" : "big");
                long size = reader.sizeOfHeader();
                long tiffFileLength = reader.stream().length();
                for (int k = firstIFDIndex; k <= lastIFDIndex; ++k) {
                    TiffIFD ifd = ifdList.get(k);
                    System.out.print(this.ifdInfo(ifd, k, ifdCount));
                    OptionalLong sizeOfIFDOptional = ifd.sizeOfIFD(tiffFileLength);
                    AtomicBoolean imageDataAligned = new AtomicBoolean(false);
                    long sizeOfData = ifd.sizeOfImageData(tiffFileLength, imageDataAligned);
                    if (sizeOfIFDOptional.isPresent()) {
                        long sizeOfIFD = sizeOfIFDOptional.getAsLong();
                        long sizeOfIFDTable = ifd.sizeOfIFDTable();
                        if (ifd.isMainIFD() && sizeOfIFDTable != (ifd.isBigTiff() ? 16L + 20L * (long)ifd.numberOfEntries() : 6L + 12L * (long)ifd.numberOfEntries())) {
                            throw new AssertionError((Object)"Invalid sizeOfIFDTable");
                        }
                        System.out.printf("%d bytes in file occupied: %d metadata (%d table + %d external) + %d image data%s", sizeOfIFD + sizeOfData, sizeOfIFD, sizeOfIFDTable, sizeOfIFD - sizeOfIFDTable, sizeOfData, imageDataAligned.get() ? " (" + (sizeOfData - 1L) + " unaligned)" : "");
                        size += sizeOfIFD + sizeOfData;
                    }
                    if (k < lastIFDIndex) {
                        System.out.println();
                    }
                    if (!ifd.containsKey(279) && !ifd.containsKey(325)) {
                        throw new TiffException("Invalid IFD: doesn't contain StripByteCounts/TileByteCounts tag");
                    }
                    if (ifd.containsKey(273) || ifd.containsKey(324)) continue;
                    throw new TiffException("Invalid IFD: doesn't contain StripOffsets/TileOffsets tag");
                }
                if (size == tiffFileLength) {
                    System.out.printf("%nTotal file length %d bytes, it is fully used", tiffFileLength);
                } else if (size > tiffFileLength) {
                    System.out.printf("%n%d bytes in file used, but the file length is only %d bytes, %d \"extra\" bytes: probably TIFF is not valid? (%s)", size, tiffFileLength, size - tiffFileLength, tiffFile);
                } else {
                    System.out.printf("%n%d bytes in file used, %d bytes lost/unknown, the file length %d bytes (%s)", size, tiffFileLength - size, tiffFileLength, tiffFile);
                }
            }
            System.out.println();
        }
    }

    public String ifdInfo(TiffIFD ifd, int ifdIndex, int ifdCount) {
        return "IFD #%d/%d:%s%s%n".formatted(ifdIndex, ifdCount, this.stringFormat.isJson() ? "%n".formatted(new Object[0]) : " ", ifd.toString(this.stringFormat));
    }

    private static boolean isPossiblyTIFF(File file) {
        if (!file.isFile()) {
            return false;
        }
        String name = file.getName().toLowerCase();
        return name.contains(".") && !name.endsWith(".txt");
    }
}

