/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.executable;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import net.algart.matrices.tiff.TiffCopier;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.TiffWriter;

public class TiffCopy {
    boolean repack = false;
    boolean smart = false;
    ByteOrder byteOrder = null;
    Boolean bigTiff = null;
    Double quality = null;
    private long lastProgressTime = Integer.MIN_VALUE;

    public static void main(String[] args) throws IOException {
        TiffCopy copy = new TiffCopy();
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-repack")) {
            copy.repack = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-smart")) {
            copy.smart = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-le")) {
            copy.byteOrder = ByteOrder.LITTLE_ENDIAN;
            ++startArgIndex;
        } else if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-be")) {
            copy.byteOrder = ByteOrder.BIG_ENDIAN;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-bigTiff")) {
            copy.bigTiff = true;
            ++startArgIndex;
        } else if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-noBigTiff")) {
            copy.bigTiff = false;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-quality")) {
            String s;
            if (!(s = args[++startArgIndex].toLowerCase()).equals("null")) {
                copy.quality = Double.parseDouble(s);
            }
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 2) {
            System.out.println("Usage:");
            System.out.printf("   [-repack] [-smart] [-le|-be] [-bigTiff|-noBigTIFF] [-quality xxx] %s source.tiff target.tiff%n", TiffCopy.class.getName());
            System.out.println("The source TIFF file is completely parsed, and its content is copied to the target filein the optimal way: IFD table first, then image data.\n-repack option forces decompression and compression of TIFF image data even in the case\nwhen direct tile-per-tile (or strip-per-strip) copying is possible.\n-le and -be options allows specifying the target file byte order; by default,the source byte order is preserved.\n-smart option allows copying some file formats that are not supported for writing(like 16-bit float values);\nthey will be repacked into the \"closest\" supported format.\n");
            return;
        }
        Path sourceFile = Paths.get(args[startArgIndex++], new String[0]);
        Path targetFile = Paths.get(args[startArgIndex], new String[0]);
        copy.copy(sourceFile, targetFile);
    }

    public void copy(Path sourceFile, Path targetFile) throws IOException {
        TiffCopier copier = new TiffCopier();
        copier.setDirectCopy(!this.repack);
        copier.setProgressUpdater(this::updateProgress);
        Object[] objectArray = new Object[6];
        objectArray[0] = sourceFile;
        objectArray[1] = targetFile;
        objectArray[2] = this.repack ? " with recompression" : "";
        Object object = objectArray[3] = this.quality == null ? "" : " (quality " + this.quality + ")";
        objectArray[4] = this.byteOrder == null ? "" : (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? ", little-endian" : ", big-endian");
        objectArray[5] = this.smart ? ", smart mode" : "";
        System.out.printf("Copying %s to %s%s%s%s%s...%n", objectArray);
        long t1 = System.nanoTime();
        try (TiffReader reader = new TiffReader(sourceFile);
             TiffWriter writer = new TiffWriter(targetFile);){
            writer.setFormatLike(reader);
            if (this.byteOrder != null) {
                writer.setByteOrder(this.byteOrder);
            }
            if (this.bigTiff != null) {
                writer.setBigTiff(this.bigTiff);
            }
            writer.setSmartFormatCorrection(this.smart);
            if (this.quality != null) {
                writer.setCompressionQuality(this.quality);
            }
            writer.create();
            copier.copyAllImages(writer, reader);
        }
        long t2 = System.nanoTime();
        System.out.printf(Locale.US, "Copying finished in %.3f seconds%n", (double)(t2 - t1) * 1.0E-9);
    }

    private void updateProgress(TiffCopier.ProgressInformation p) {
        long t = System.currentTimeMillis();
        if (t - this.lastProgressTime > 200L || p.isLastTileCopied()) {
            System.out.printf("\rImage %d/%d, tile %d/%d (%s)%s", p.imageIndex() + 1, p.imageCount(), p.tileIndex() + 1, p.tileCount(), p.copier().actuallyDirectCopy() ? "direct" : "repacking", p.isLastTileCopied() ? "" : "...");
            if (p.isLastTileCopied()) {
                System.out.println();
            }
            this.lastProgressTime = t;
        }
    }
}

