/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.data;

import java.nio.ByteOrder;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.tags.TagPredictor;
import net.algart.matrices.tiff.tiles.TiffTile;

public class TiffPrediction {
    private TiffPrediction() {
    }

    public static void subtractPredictionIfRequested(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        TagPredictor predictor = tile.ifd().getPredictor();
        switch (predictor) {
            case NONE: {
                break;
            }
            case HORIZONTAL: {
                TiffPrediction.subtractPrediction(tile);
                break;
            }
            default: {
                throw new TiffException("Unsupported TIFF Predictor tag: " + tile.ifd().optPredictorCode() + " (" + predictor.prettyName() + ")");
            }
        }
    }

    public static void unsubtractPredictionIfRequested(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        TagPredictor predictor = tile.ifd().getPredictor();
        switch (predictor) {
            case NONE: {
                break;
            }
            case HORIZONTAL: {
                TiffPrediction.unsubtractPrediction(tile);
                break;
            }
            default: {
                throw new TiffException("Unsupported TIFF Predictor tag: " + tile.ifd().optPredictorCode() + " (" + predictor.prettyName() + ")");
            }
        }
    }

    public static void subtractPrediction(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        byte[] data = tile.getDecodedData();
        int bitsPerSample = tile.bitsPerSample();
        TiffPrediction.checkBitDepthForPrediction(bitsPerSample, "for writing");
        int samplesPerPixel = tile.samplesPerPixel();
        int xSize = tile.getSizeX();
        int xSizeInBytes = tile.getLineSizeInBytesInsideTIFF();
        int ySize = data.length / xSizeInBytes;
        switch (bitsPerSample) {
            case 1: {
                int xSizeInBits = xSizeInBytes * 8;
                boolean[] a = PackedBitArraysPer8.unpackBitsInReverseOrder((byte[])data, (long)0L, (long)((long)xSizeInBits * (long)ySize));
                TiffPrediction.subtractBooleanMatrix(a, xSizeInBits, ySize, samplesPerPixel);
                PackedBitArraysPer8.packBitsInReverseOrder((byte[])data, (long)0L, (boolean[])a, (int)0, (int)a.length);
                break;
            }
            case 8: {
                TiffPrediction.subtractByteMatrix(data, xSize, ySize, samplesPerPixel);
                break;
            }
            case 16: {
                short[] a = JArrays.bytesToShortArray((byte[])data, (ByteOrder)tile.byteOrder());
                TiffPrediction.subtractShortMatrix(a, xSize, ySize, samplesPerPixel);
                JArrays.shortArrayToBytes((byte[])data, (short[])a, (int)a.length, (ByteOrder)tile.byteOrder());
                break;
            }
            case 32: {
                int[] a = JArrays.bytesToIntArray((byte[])data, (ByteOrder)tile.byteOrder());
                TiffPrediction.subtractIntMatrix(a, xSize, ySize, samplesPerPixel);
                JArrays.intArrayToBytes((byte[])data, (int[])a, (int)a.length, (ByteOrder)tile.byteOrder());
                break;
            }
            case 64: {
                long[] a = JArrays.bytesToLongArray((byte[])data, (ByteOrder)tile.byteOrder());
                TiffPrediction.subtractLongMatrix(a, xSize, ySize, samplesPerPixel);
                JArrays.longArrayToBytes((byte[])data, (long[])a, (int)a.length, (ByteOrder)tile.byteOrder());
                break;
            }
            default: {
                throw new AssertionError((Object)"Must be checked in checkBitDepthForPrediction");
            }
        }
    }

    public static void unsubtractPrediction(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        byte[] data = tile.getDecodedData();
        int bitsPerSample = tile.bitsPerSample();
        TiffPrediction.checkBitDepthForPrediction(bitsPerSample, "for reading");
        int samplesPerPixel = tile.samplesPerPixel();
        int xSize = tile.getSizeX();
        int xSizeInBytes = tile.getLineSizeInBytesInsideTIFF();
        int ySize = data.length / xSizeInBytes;
        switch (bitsPerSample) {
            case 1: {
                int xSizeInBits = xSizeInBytes * 8;
                boolean[] a = PackedBitArraysPer8.unpackBitsInReverseOrder((byte[])data, (long)0L, (long)((long)xSizeInBits * (long)ySize));
                TiffPrediction.unsubtractBooleanMatrix(a, xSizeInBits, ySize, samplesPerPixel);
                PackedBitArraysPer8.packBitsInReverseOrder((byte[])data, (long)0L, (boolean[])a, (int)0, (int)a.length);
                break;
            }
            case 8: {
                TiffPrediction.unsubtractByteMatrix(data, xSize, ySize, samplesPerPixel);
                break;
            }
            case 16: {
                short[] a = JArrays.bytesToShortArray((byte[])data, (ByteOrder)tile.byteOrder());
                TiffPrediction.unsubtractShortMatrix(a, xSize, ySize, samplesPerPixel);
                JArrays.shortArrayToBytes((byte[])data, (short[])a, (int)a.length, (ByteOrder)tile.byteOrder());
                break;
            }
            case 32: {
                int[] a = JArrays.bytesToIntArray((byte[])data, (ByteOrder)tile.byteOrder());
                TiffPrediction.unsubtractIntMatrix(a, xSize, ySize, samplesPerPixel);
                JArrays.intArrayToBytes((byte[])data, (int[])a, (int)a.length, (ByteOrder)tile.byteOrder());
                break;
            }
            case 64: {
                long[] a = JArrays.bytesToLongArray((byte[])data, (ByteOrder)tile.byteOrder());
                TiffPrediction.unsubtractLongMatrix(a, xSize, ySize, samplesPerPixel);
                JArrays.longArrayToBytes((byte[])data, (long[])a, (int)a.length, (ByteOrder)tile.byteOrder());
                break;
            }
            default: {
                throw new AssertionError((Object)"Must be checked in checkBitDepthForPrediction");
            }
        }
    }

    private static void subtractByteMatrix(byte[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int minOffset = lineOffset + samplesPerPixel;
            for (int k = lineOffset + xSizeInSamples - 1; k >= minOffset; --k) {
                int n = k;
                a[n] = (byte)(a[n] - a[k - samplesPerPixel]);
            }
        }
    }

    private static void unsubtractByteMatrix(byte[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int toOffset = lineOffset + xSizeInSamples;
            for (int k = lineOffset + samplesPerPixel; k < toOffset; ++k) {
                int n = k;
                a[n] = (byte)(a[n] + a[k - samplesPerPixel]);
            }
        }
    }

    private static void subtractShortMatrix(short[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int minOffset = lineOffset + samplesPerPixel;
            for (int k = lineOffset + xSizeInSamples - 1; k >= minOffset; --k) {
                int n = k;
                a[n] = (short)(a[n] - a[k - samplesPerPixel]);
            }
        }
    }

    private static void unsubtractShortMatrix(short[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int toOffset = lineOffset + xSizeInSamples;
            for (int k = lineOffset + samplesPerPixel; k < toOffset; ++k) {
                int n = k;
                a[n] = (short)(a[n] + a[k - samplesPerPixel]);
            }
        }
    }

    private static void subtractIntMatrix(int[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int minOffset = lineOffset + samplesPerPixel;
            for (int k = lineOffset + xSizeInSamples - 1; k >= minOffset; --k) {
                int n = k;
                a[n] = a[n] - a[k - samplesPerPixel];
            }
        }
    }

    private static void unsubtractIntMatrix(int[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int toOffset = lineOffset + xSizeInSamples;
            for (int k = lineOffset + samplesPerPixel; k < toOffset; ++k) {
                int n = k;
                a[n] = a[n] + a[k - samplesPerPixel];
            }
        }
    }

    private static void subtractLongMatrix(long[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int minOffset = lineOffset + samplesPerPixel;
            for (int k = lineOffset + xSizeInSamples - 1; k >= minOffset; --k) {
                int n = k;
                a[n] = a[n] - a[k - samplesPerPixel];
            }
        }
    }

    private static void unsubtractLongMatrix(long[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int toOffset = lineOffset + xSizeInSamples;
            for (int k = lineOffset + samplesPerPixel; k < toOffset; ++k) {
                int n = k;
                a[n] = a[n] + a[k - samplesPerPixel];
            }
        }
    }

    private static void subtractBooleanMatrix(boolean[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int minOffset = lineOffset + samplesPerPixel;
            for (int k = lineOffset + xSizeInSamples - 1; k >= minOffset; --k) {
                int n = k;
                a[n] = a[n] ^ a[k - samplesPerPixel];
            }
        }
    }

    private static void unsubtractBooleanMatrix(boolean[] a, int xSize, int ySize, int samplesPerPixel) {
        int xSizeInSamples = xSize * samplesPerPixel;
        for (int y = 0; y < ySize; ++y) {
            int lineOffset = y * xSizeInSamples;
            int toOffset = lineOffset + xSizeInSamples;
            for (int k = lineOffset + samplesPerPixel; k < toOffset; ++k) {
                int n = k;
                a[n] = a[n] ^ a[k - samplesPerPixel];
            }
        }
    }

    private static void checkBitDepthForPrediction(int bitsPerSample, String where) throws TiffException {
        if (bitsPerSample != 1 && bitsPerSample != 8 && bitsPerSample != 16 && bitsPerSample != 32 && bitsPerSample != 64) {
            throw new TiffException("Cannot use TIFF prediction " + where + " for bit depth " + bitsPerSample);
        }
    }
}

