/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.data;

import java.util.Objects;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.arrays.TooLargeArrayException;
import net.algart.matrices.tiff.tiles.TiffTile;

public class TiffPacking {
    private TiffPacking() {
    }

    public static boolean packTiffBits(TiffTile tile) {
        int sizeInBytes;
        Objects.requireNonNull(tile);
        if (tile.bitsPerPixel() != 1) {
            return false;
        }
        assert (tile.samplesPerPixel() == 1) : "> 1 channel in " + String.valueOf(tile);
        byte[] source = tile.getDecodedData();
        if (source.length < (sizeInBytes = tile.getSizeInBytes())) {
            throw new IllegalArgumentException("Stored data length " + source.length + " does not match tile sizes: " + String.valueOf(tile));
        }
        int sizeX = tile.getSizeX();
        int sizeY = tile.getSizeY();
        assert (tile.getSizeInPixels() == sizeX * sizeY);
        long alignedLine = (long)sizeX + 7L & 0xFFFFFFFFFFFFFFF8L;
        long length = (long)sizeY * alignedLine >>> 3;
        if (length > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large requested TIFF binary image " + sizeX + "x" + sizeY + ": cannot fit into 2^31 bytes after aligning each line");
        }
        byte[] result = new byte[(int)length];
        long sOffset = 0L;
        long tOffset = 0L;
        int yIndex = 0;
        while (yIndex < sizeY) {
            PackedBitArraysPer8.copyBitsFromNormalToReverseOrderNoSync((byte[])result, (long)tOffset, (byte[])source, (long)sOffset, (long)sizeX);
            ++yIndex;
            sOffset += (long)sizeX;
            tOffset += alignedLine;
        }
        tile.setPartiallyDecodedData(result);
        return true;
    }
}

