/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.data;

import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.UnsupportedTiffFormatException;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tiles.TiffTile;

public class TiffJPEGDecodingHelper {
    private TiffJPEGDecodingHelper() {
    }

    public static void embedJPEGTableInDataIfRequested(TiffTile tile, boolean throwExceptionForStrangeDataStream) throws TiffException {
        TiffIFD ifd = tile.ifd();
        TagCompression compression = ifd.optCompression();
        if (compression == null || !compression.isJpegOrOldJpeg()) {
            return;
        }
        byte[] data = tile.getEncodedData();
        byte[] jpegTable = ifd.getValue(347, byte[].class).orElse(null);
        if (data.length < 2 || data[0] != -1 || data[1] != -40) {
            if (compression.isStandardJpeg()) {
                throw new TiffException("Invalid TIFF image: it is declared as JPEG, but the data are not actually JPEG");
            }
            if (!throwExceptionForStrangeDataStream) {
                return;
            }
            throw new UnsupportedTiffFormatException("Unsupported format of TIFF image: it is declared as \"" + compression.prettyName() + "\", but the data are not actually JPEG");
        }
        if (jpegTable != null) {
            if (jpegTable.length <= 4) {
                throw new TiffException("Too short JPEGTables tag: only " + jpegTable.length + " bytes");
            }
            if ((long)jpegTable.length + (long)data.length - 4L >= Integer.MAX_VALUE) {
                throw new TiffException("Too large tile/strip at " + String.valueOf(tile.index()) + ": JPEG table length " + (jpegTable.length - 2) + " + number of bytes " + (data.length - 2) + " > 2^31-1");
            }
            byte[] appended = new byte[jpegTable.length + data.length - 4];
            appended[0] = -1;
            appended[1] = -40;
            System.arraycopy(jpegTable, 2, appended, 2, jpegTable.length - 4);
            System.arraycopy(data, 2, appended, jpegTable.length - 2, data.length - 2);
            tile.setEncodedData(appended);
        }
    }
}

