/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import com.github.jaiimageio.jpeg2000.J2KImageReadParam;
import com.github.jaiimageio.jpeg2000.J2KImageWriteParam;
import com.github.jaiimageio.jpeg2000.impl.J2KImageReader;
import com.github.jaiimageio.jpeg2000.impl.J2KImageWriter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageWriteParam;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.awt.AWTImages;
import net.algart.matrices.tiff.awt.UnsignedIntBuffer;
import net.algart.matrices.tiff.codecs.TiffCodec;

public class JPEG2000Codec
implements TiffCodec {
    @Override
    public byte[] compress(byte[] data, TiffCodec.Options options) throws TiffException {
        BufferedImage img;
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(options, "Null codec options");
        if (options.floatingPoint) {
            throw new TiffException("JPEG-2000 compression cannot be used for floating-point values");
        }
        if (options.signed) {
            throw new TiffException("JPEG compression for signed samples is not supported (only unsigned samples allowed)");
        }
        if (data.length == 0) {
            return data;
        }
        JPEG2000Options jpeg2000Options = new JPEG2000Options().setTo(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int next = 0;
        int plane = jpeg2000Options.width * jpeg2000Options.height;
        if (jpeg2000Options.bitsPerSample == 8) {
            byte[][] b = new byte[jpeg2000Options.numberOfChannels][plane];
            if (jpeg2000Options.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < jpeg2000Options.numberOfChannels; ++c) {
                        b[c][q] = data[next++];
                    }
                }
            } else {
                for (int c = 0; c < jpeg2000Options.numberOfChannels; ++c) {
                    System.arraycopy(data, c * plane, b[c], 0, plane);
                }
            }
            DataBufferByte buffer = new DataBufferByte(b, plane);
            img = AWTImages.constructImage(b.length, 0, jpeg2000Options.width, jpeg2000Options.height, false, true, buffer, jpeg2000Options.colorModel);
        } else if (jpeg2000Options.bitsPerSample == 16) {
            s = new short[jpeg2000Options.numberOfChannels][plane];
            if (jpeg2000Options.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < jpeg2000Options.numberOfChannels; ++c) {
                        s[c][q] = JPEG2000Codec.toShort(data, next, jpeg2000Options.littleEndian);
                        next += 2;
                    }
                }
            } else {
                for (int c = 0; c < jpeg2000Options.numberOfChannels; ++c) {
                    for (int q = 0; q < plane; ++q) {
                        s[c][q] = JPEG2000Codec.toShort(data, next, jpeg2000Options.littleEndian);
                        next += 2;
                    }
                }
            }
            DataBufferUShort buffer = new DataBufferUShort((short[][])s, plane);
            img = AWTImages.constructImage(((short[][])s).length, 1, jpeg2000Options.width, jpeg2000Options.height, false, true, buffer, jpeg2000Options.colorModel);
        } else if (jpeg2000Options.bitsPerSample == 32) {
            s = new int[jpeg2000Options.numberOfChannels][plane];
            if (jpeg2000Options.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < jpeg2000Options.numberOfChannels; ++c) {
                        s[c][q] = JPEG2000Codec.toInt(data, next, jpeg2000Options.littleEndian);
                        next += 4;
                    }
                }
            } else {
                for (int c = 0; c < jpeg2000Options.numberOfChannels; ++c) {
                    for (int q = 0; q < plane; ++q) {
                        s[c][q] = JPEG2000Codec.toInt(data, next, jpeg2000Options.littleEndian);
                        next += 4;
                    }
                }
            }
            UnsignedIntBuffer buffer = new UnsignedIntBuffer((int[][])s, plane);
            img = AWTImages.constructImage(((short[][])s).length, 3, jpeg2000Options.width, jpeg2000Options.height, false, true, buffer, jpeg2000Options.colorModel);
        } else {
            throw new TiffException("JPEG-2000 compression for " + jpeg2000Options.bitsPerSample + "-bit samples is not supported (only 8-bit, 16-bit and 32-bit samples allowed)");
        }
        try {
            JPEG2000Codec.writeImage(out, img, jpeg2000Options);
        }
        catch (IOException e) {
            throw new TiffException("Could not compress JPEG-2000 data.", e);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] decompress(byte[] data, TiffCodec.Options options) throws TiffException {
        int bpp;
        byte[][] single;
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(options, "Null codec options");
        JPEG2000Options jpeg2000Options = new JPEG2000Options().setTo(options);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            WritableRaster b = (WritableRaster)JPEG2000Codec.readRaster(bis, jpeg2000Options);
            single = AWTImages.getPixelBytes(b, jpeg2000Options.littleEndian);
            bpp = single[0].length / (b.getWidth() * b.getHeight());
            bis.close();
        }
        catch (IOException e) {
            throw new TiffException("Could not decompress JPEG2000 image. Please make sure that jai_imageio.jar is installed.", e);
        }
        if (single.length == 1) {
            return single[0];
        }
        byte[] rtn = new byte[single.length * single[0].length];
        if (jpeg2000Options.interleaved) {
            int next = 0;
            for (int i = 0; i < single[0].length / bpp; ++i) {
                for (byte[] bytes : single) {
                    for (int bb = 0; bb < bpp; ++bb) {
                        rtn[next++] = bytes[i * bpp + bb];
                    }
                }
            }
        } else {
            for (int i = 0; i < single.length; ++i) {
                System.arraycopy(single[i], 0, rtn, i * single[0].length, single[i].length);
            }
        }
        return rtn;
    }

    private static void writeImage(OutputStream out, BufferedImage img, JPEG2000Options options) throws IOException {
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(out);
        J2KImageWriter writer = new J2KImageWriter(null);
        writer.setOutput((Object)ios);
        String filter = options.lossless ? "w5x3" : "w9x7";
        IIOImage iioImage = new IIOImage(img, null, null);
        J2KImageWriteParam param = (J2KImageWriteParam)writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("JPEG2000");
        param.setLossless(options.lossless);
        param.setFilter(filter);
        param.setWriteCodeStreamOnly(!options.writeMetadata);
        param.setCodeBlockSize(options.getCodeBlockSize());
        param.setEncodingRate(options.compressionQuality());
        if (options.numberOfDecompositionLevels != null) {
            param.setNumDecompositionLevels(options.numberOfDecompositionLevels.intValue());
        }
        writer.write(null, iioImage, (ImageWriteParam)param);
        ios.close();
    }

    private static Raster readRaster(InputStream in, JPEG2000Options options) throws IOException {
        J2KImageReader reader = new J2KImageReader(null);
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(in);
        reader.setInput((Object)mciis, false, true);
        J2KImageReadParam param = (J2KImageReadParam)reader.getDefaultReadParam();
        if (options.resolution != null) {
            param.setResolution(options.resolution.intValue());
        }
        return reader.readRaster(0, (ImageReadParam)param);
    }

    private static short toShort(byte[] src, int srcPos, boolean little) {
        return (short)(little ? src[srcPos] & 0xFF | (src[srcPos + 1] & 0xFF) << 8 : (src[srcPos] & 0xFF) << 8 | src[srcPos + 1] & 0xFF);
    }

    private static int toInt(byte[] src, int srcPos, boolean little) {
        return little ? src[srcPos] & 0xFF | (src[srcPos + 1] & 0xFF) << 8 | (src[srcPos + 2] & 0xFF) << 16 | (src[srcPos + 3] & 0xFF) << 24 : (src[srcPos] & 0xFF) << 24 | (src[srcPos + 1] & 0xFF) << 16 | (src[srcPos + 2] & 0xFF) << 8 | src[srcPos + 3] & 0xFF;
    }

    public static class JPEG2000Options
    extends TiffCodec.Options {
        public static final double DEFAULT_NORMAL_QUALITY = 5.0;
        public static final boolean DEFAULT_WRITE_METADATA = false;
        boolean lossless = true;
        ColorModel colorModel = null;
        int[] codeBlockSize = new int[]{64, 64};
        Integer numberOfDecompositionLevels = null;
        Integer resolution = null;
        boolean writeMetadata = false;

        public JPEG2000Options() {
            this.setCompressionQuality((Double)Double.MAX_VALUE);
        }

        public boolean isLossless() {
            return this.lossless;
        }

        public JPEG2000Options setLossless(boolean lossless) {
            this.lossless = lossless;
            return this;
        }

        public ColorModel getColorModel() {
            return this.colorModel;
        }

        public JPEG2000Options setColorModel(ColorModel colorModel) {
            this.colorModel = colorModel;
            return this;
        }

        public int[] getCodeBlockSize() {
            return (int[])this.codeBlockSize.clone();
        }

        public JPEG2000Options setCodeBlockSize(int[] codeBlockSize) {
            Objects.requireNonNull(codeBlockSize, "Null codeBlockSize");
            if (codeBlockSize.length < 2) {
                throw new IllegalArgumentException("Too short codeBlockSize array: int[" + codeBlockSize.length + "] (must contain 2 elements)");
            }
            this.codeBlockSize = (int[])codeBlockSize.clone();
            return this;
        }

        public Integer getNumberOfDecompositionLevels() {
            return this.numberOfDecompositionLevels;
        }

        public JPEG2000Options setNumberOfDecompositionLevels(Integer numberOfDecompositionLevels) {
            this.numberOfDecompositionLevels = numberOfDecompositionLevels;
            return this;
        }

        public Integer getResolution() {
            return this.resolution;
        }

        public JPEG2000Options setResolution(Integer resolution) {
            this.resolution = resolution;
            return this;
        }

        public boolean writeMetadata() {
            return this.writeMetadata;
        }

        public JPEG2000Options setWriteMetadata(boolean writeMetadata) {
            this.writeMetadata = writeMetadata;
            return this;
        }

        @Override
        public JPEG2000Options setTo(TiffCodec.Options options) {
            return this.setTo(options, true);
        }

        public JPEG2000Options setTo(TiffCodec.Options options, boolean lossless) {
            super.setTo(options);
            if (options instanceof JPEG2000Options) {
                JPEG2000Options o = (JPEG2000Options)options;
                this.setLossless(o.lossless);
                this.setColorModel(o.colorModel);
                this.setCodeBlockSize(o.codeBlockSize);
                this.setNumberOfDecompositionLevels(o.numberOfDecompositionLevels);
                this.setResolution(o.resolution);
                this.setWriteMetadata(o.writeMetadata);
            } else {
                this.setLossless(lossless);
                if (!this.hasQuality()) {
                    this.setCompressionQuality(lossless ? Double.MAX_VALUE : 5.0);
                }
            }
            return this;
        }

        @Override
        public <T> T toSCIFIOStyleOptions(Class<T> scifioStyleClass) {
            T result = super.toSCIFIOStyleOptions(scifioStyleClass);
            JPEG2000Options.setField(scifioStyleClass, result, "lossless", this.lossless);
            JPEG2000Options.setField(scifioStyleClass, result, "colorModel", this.colorModel);
            return result;
        }

        @Override
        public void setToSCIFIOStyleOptions(Object scifioStyleOptions) {
            super.setToSCIFIOStyleOptions(scifioStyleOptions);
            this.lossless = JPEG2000Options.getField(scifioStyleOptions, Boolean.class, "lossless");
            this.colorModel = JPEG2000Options.getField(scifioStyleOptions, ColorModel.class, "colorModel");
        }

        @Override
        public String toString() {
            return "JPEG2000Options{lossless=" + this.lossless + ", colorModel=" + String.valueOf(this.colorModel) + ", codeBlockSize=" + Arrays.toString(this.codeBlockSize) + ", numberOfDecompositionLevels=" + this.numberOfDecompositionLevels + ", resolution=" + this.resolution + ", writeMetadata=" + this.writeMetadata + "}";
        }
    }
}

