/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.HashMap;
import net.algart.matrices.tiff.TiffException;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

class HuffmanCodecAdaptedAndReduced {
    private static final int LEAVES_OFFSET = 16;
    private int leafCounter;
    private final HashMap<short[], Decoder> cachedDecoders = new HashMap();

    HuffmanCodecAdaptedAndReduced() {
    }

    public byte[] decompress(DataHandle<Location> in, HuffmanCodecOptions options) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null) {
            throw new TiffException("Options must be an instance of loci.formats.codec.HuffmanCodecOptions.");
        }
        byte[] pix = new byte[options.maxBytes];
        in.read(pix);
        BitBuffer bb = new BitBuffer(pix);
        int nSamples = options.maxBytes * 8 / options.bitsPerSample;
        int bytesPerSample = options.bitsPerSample / 8;
        if (options.bitsPerSample % 8 != 0) {
            ++bytesPerSample;
        }
        BitWriter out = new BitWriter();
        for (int i = 0; i < nSamples; ++i) {
            int sample = this.getSample(bb, options);
            out.write(sample, bytesPerSample * 8);
        }
        return out.toByteArray();
    }

    public int getSample(BitBuffer bb, HuffmanCodecOptions options) throws TiffException {
        int v;
        int bitCount;
        if (bb == null) {
            throw new IllegalArgumentException("No data to handle.");
        }
        if (options == null) {
            throw new TiffException("Options must be an instance of loci.formats.codec.HuffmanCodecOptions.");
        }
        Decoder decoder = this.cachedDecoders.get(options.table);
        if (decoder == null) {
            decoder = new Decoder(options.table);
            this.cachedDecoders.put(options.table, decoder);
        }
        if ((bitCount = decoder.decode(bb)) == 16) {
            return 32768;
        }
        if (bitCount < 0) {
            bitCount = 0;
        }
        if (((v = bb.getBits(bitCount) & (int)Math.pow(2.0, bitCount) - 1) & 1 << bitCount - 1) == 0) {
            v -= (1 << bitCount) - 1;
        }
        return v;
    }

    static class HuffmanCodecOptions {
        int width;
        int height;
        int channels;
        int bitsPerSample;
        boolean littleEndian;
        boolean interleaved;
        boolean signed;
        int maxBytes;
        boolean lossless;
        ColorModel colorModel;
        double quality;
        boolean ycbcr;
        short[] table;

        HuffmanCodecOptions() {
        }
    }

    static class BitBuffer {
        private static final int[] BACK_MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
        private static final int[] FRONT_MASK = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
        private final byte[] byteBuffer;
        private int currentByte;
        private int currentBit;
        private final int eofByte;
        private boolean eofFlag;

        public BitBuffer(byte[] byteBuffer) {
            this.byteBuffer = byteBuffer;
            this.currentByte = 0;
            this.currentBit = 0;
            this.eofByte = byteBuffer.length;
        }

        public int getBits(int bitsToRead) {
            if (bitsToRead < 0) {
                throw new IllegalArgumentException("Bits to read may not be negative");
            }
            if (bitsToRead == 0) {
                return 0;
            }
            if (this.eofFlag) {
                return -1;
            }
            int toStore = 0;
            while (bitsToRead != 0) {
                if (this.currentBit < 0 || this.currentBit > 7) {
                    throw new IllegalStateException("byte=" + this.currentByte + ", bit = " + this.currentBit);
                }
                int bitsLeft = 8 - this.currentBit;
                if (bitsToRead >= bitsLeft) {
                    toStore <<= bitsLeft;
                    bitsToRead -= bitsLeft;
                    cb = this.byteBuffer[this.currentByte];
                    if (this.currentBit == 0) {
                        toStore += cb & 0xFF;
                    } else {
                        toStore += cb & BACK_MASK[bitsLeft];
                        this.currentBit = 0;
                    }
                    ++this.currentByte;
                } else {
                    toStore <<= bitsToRead;
                    cb = this.byteBuffer[this.currentByte] & 0xFF;
                    toStore += (cb & 255 - FRONT_MASK[this.currentBit]) >> bitsLeft - bitsToRead;
                    this.currentBit += bitsToRead;
                    bitsToRead = 0;
                }
                if (this.currentByte != this.eofByte) continue;
                this.eofFlag = true;
                return toStore;
            }
            return toStore;
        }
    }

    static class BitWriter {
        private byte[] buf;
        private int index;
        private int bit;

        public BitWriter() {
            this(10);
        }

        public BitWriter(int size) {
            this.buf = new byte[size];
        }

        public void write(int value, int numBits) {
            int i;
            if (numBits <= 0) {
                return;
            }
            byte[] bits = new byte[numBits];
            for (i = 0; i < numBits; ++i) {
                bits[i] = (byte)(value & 1);
                value >>= 1;
            }
            for (i = numBits - 1; i >= 0; --i) {
                int b = bits[i] << 7 - this.bit;
                int n = this.index++;
                this.buf[n] = (byte)(this.buf[n] | (byte)b);
                ++this.bit;
                if (this.bit <= 7) continue;
                this.bit = 0;
                if (this.index < this.buf.length) continue;
                byte[] newBuf = new byte[this.buf.length * 2];
                System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
                this.buf = newBuf;
            }
        }

        public byte[] toByteArray() {
            int size = this.index;
            if (this.bit > 0) {
                ++size;
            }
            byte[] b = new byte[size];
            System.arraycopy(this.buf, 0, b, 0, size);
            return b;
        }
    }

    class Decoder {
        public final Decoder[] branch = new Decoder[2];
        private int leafValue = -1;

        public Decoder() {
        }

        public Decoder(short[] source) {
            HuffmanCodecAdaptedAndReduced.this.leafCounter = 0;
            this.createDecoder(this, source, 0, 0);
        }

        private Decoder createDecoder(short[] source, int start, int level) {
            Decoder dest = new Decoder();
            this.createDecoder(dest, source, start, level);
            return dest;
        }

        private void createDecoder(Decoder dest, short[] source, int start, int level) {
            int i;
            int next = 0;
            for (i = 0; i <= HuffmanCodecAdaptedAndReduced.this.leafCounter && next < 16; i += source[start + next++] & 0xFF) {
            }
            if (level < next && next < 16) {
                dest.branch[0] = this.createDecoder(source, start, level + 1);
                dest.branch[1] = this.createDecoder(source, start, level + 1);
            } else if ((i = start + 16 + HuffmanCodecAdaptedAndReduced.this.leafCounter++) < source.length) {
                dest.leafValue = source[i] & 0xFF;
            }
        }

        public int decode(BitBuffer bb) {
            int v;
            Decoder d = this;
            while (d.branch[0] != null && (v = bb.getBits(1)) >= 0) {
                d = d.branch[v];
            }
            return d.leafValue;
        }
    }

    static class ByteVector {
        private byte[] data;
        private int size;

        public ByteVector() {
            this.data = new byte[10];
            this.size = 0;
        }

        public ByteVector(int initialSize) {
            this.data = new byte[initialSize];
            this.size = 0;
        }

        public ByteVector(byte[] byteBuffer) {
            this.data = byteBuffer;
            this.size = 0;
        }

        public void add(byte x) {
            while (this.size >= this.data.length) {
                this.doubleCapacity();
            }
            this.data[this.size++] = x;
        }

        public int size() {
            return this.size;
        }

        public byte get(int index) {
            return this.data[index];
        }

        public void add(byte[] array) {
            this.add(array, 0, array.length);
        }

        public void add(byte[] array, int off, int len) {
            assert (len >= 0);
            while (this.data.length < this.size + len) {
                this.doubleCapacity();
            }
            if (len == 1) {
                this.data[this.size] = array[off];
            } else {
                System.arraycopy(array, off, this.data, this.size, len);
            }
            this.size += len;
        }

        void doubleCapacity() {
            byte[] tmp = new byte[this.data.length * 2 + 1];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }

        public void clear() {
            this.size = 0;
        }

        public byte[] toByteArray() {
            byte[] bytes = new byte[this.size];
            System.arraycopy(this.data, 0, bytes, 0, this.size);
            return bytes;
        }
    }
}

