/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.scijava.Context;

class SCIFIOBridge {
    static final String SCIFIO_CLASS_NAME = "io.scif.SCIFIO";
    private static final Class<?> SCIFIO_CLASS = SCIFIOBridge.findScifioClass();

    SCIFIOBridge() {
    }

    static boolean isScifioInstalled() {
        return SCIFIO_CLASS != null;
    }

    static Class<?> codecOptionsClass() {
        return SCIFIOBridge.scifioClass("io.scif.codec.CodecOptions");
    }

    static Class<?> scifioIFDClass() {
        return SCIFIOBridge.scifioClass("io.scif.formats.tiff.IFD");
    }

    static Object createScifioFromContext(Context context) {
        if (context == null) {
            return null;
        }
        if (SCIFIO_CLASS == null) {
            throw new UnsupportedOperationException("SCIFIO library is not installed");
        }
        try {
            return SCIFIO_CLASS.getConstructor(Context.class).newInstance(context);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("SCIFIO library cannot be called, probably due to version mismatch", e);
        }
    }

    static Context getDefaultScifioContext() {
        if (SCIFIO_CLASS == null) {
            throw new UnsupportedOperationException("Cannot create SCIFIO context: SCIFIO library is not installed");
        }
        try {
            Object scifio = SCIFIO_CLASS.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (Context)SCIFIO_CLASS.getMethod("getContext", new Class[0]).invoke(scifio, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("SCIFIO library cannot be called, probably due to version mismatch", e);
        }
    }

    static Map<Integer, Object> createIFD(Class<?> ifdClass) {
        Object result;
        Class<?> logServiceClass = SCIFIOBridge.scifioClass("org.scijava.log.LogService");
        try {
            result = ifdClass.getConstructor(logServiceClass).newInstance(new Object[]{null});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("SCIFIO IFD object cannot be created, probably due to version mismatch", e);
        }
        if (!(result instanceof Map)) {
            throw new IllegalStateException("SCIFIO IFD object is not Map and cannot be used, probably due to version mismatch: it is " + String.valueOf(result));
        }
        return (Map)result;
    }

    static Object createTiffCompression(int compressionCode) throws InvocationTargetException {
        Class<?> tiffCompressionClass;
        try {
            tiffCompressionClass = Class.forName("io.scif.formats.tiff.TiffCompression");
        }
        catch (ClassNotFoundException e1) {
            throw new UnsupportedOperationException("Operation is not allowed: SCIFIO TiffCompression class is not found (SCIFIO library is probably not installed correctly or has incompatible version)", e1);
        }
        try {
            return tiffCompressionClass.getMethod("get", Integer.TYPE).invoke(null, compressionCode);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("SCIFIO TiffCompression object cannot be created, probably due to version mismatch", e);
        }
    }

    static Object getCompressionCodecOptions(Object tiffCompression, Object ifd, Object options) throws InvocationTargetException {
        Object result;
        Class<?> scifioIFDClass = SCIFIOBridge.scifioIFDClass();
        Class<?> codecOptionsClass = SCIFIOBridge.codecOptionsClass();
        try {
            result = tiffCompression.getClass().getMethod("getCompressionCodecOptions", scifioIFDClass, codecOptionsClass).invoke(tiffCompression, ifd, options);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("SCIFIO TiffCompression.getCompressionCodecOptions method cannot be called, probably due to version mismatch", e);
        }
        return result;
    }

    static byte[] callDecompress(Object scifio, Object tiffCompression, byte[] input, Object options) throws InvocationTargetException {
        Object result;
        Object codecService = SCIFIOBridge.scifioCodecService(scifio);
        Class<?> codecServiceClass = SCIFIOBridge.scifioClass("io.scif.codec.CodecService");
        Class<?> codecOptionsClass = SCIFIOBridge.codecOptionsClass();
        try {
            result = tiffCompression.getClass().getMethod("decompress", codecServiceClass, byte[].class, codecOptionsClass).invoke(tiffCompression, codecService, input, options);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("SCIFIO TiffCompression.decompress method cannot be called, probably due to version mismatch", e);
        }
        if (result != null && !(result instanceof byte[])) {
            throw new IllegalStateException("SCIFIO TiffCompression.decompress method returns invalid result " + String.valueOf(result) + ", probably due to version mismatch");
        }
        return (byte[])result;
    }

    static byte[] callCompress(Object scifio, Object tiffCompression, byte[] input, Object options) throws InvocationTargetException {
        Object result;
        Object codecService = SCIFIOBridge.scifioCodecService(scifio);
        Class<?> codecServiceClass = SCIFIOBridge.scifioClass("io.scif.codec.CodecService");
        Class<?> codecOptionsClass = SCIFIOBridge.codecOptionsClass();
        try {
            result = tiffCompression.getClass().getMethod("compress", codecServiceClass, byte[].class, codecOptionsClass).invoke(tiffCompression, codecService, input, options);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("SCIFIO TiffCompression.compress method cannot be called, probably due to version mismatch", e);
        }
        if (result != null && !(result instanceof byte[])) {
            throw new IllegalStateException("SCIFIO TiffCompression.compress method returns invalid result " + String.valueOf(result) + ", probably due to version mismatch");
        }
        return (byte[])result;
    }

    private static Class<?> scifioClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("SCIFIO class \"" + className + "\" cannot be found, probably due to version mismatch", e);
        }
    }

    private static Object scifioCodecService(Object scifio) {
        try {
            return scifio.getClass().getMethod("codec", new Class[0]).invoke(scifio, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("SCIFIO codec method cannot be called, probably due to version mismatch", e);
        }
    }

    private static Class<?> findScifioClass() {
        try {
            return Class.forName(SCIFIO_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

