/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.Point;
import net.algart.math.RectangularArea;
import net.algart.math.functions.CoordinateTransformationOperator;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearOperator;
import net.algart.matrices.stitching.FramePosition;

public class UniversalFramePosition
implements FramePosition {
    private final RectangularArea area;
    private final CoordinateTransformationOperator inverseTransform;
    private final boolean isShift;

    UniversalFramePosition(RectangularArea area, CoordinateTransformationOperator inverseTransform) {
        this.area = area;
        this.inverseTransform = inverseTransform;
        this.isShift = inverseTransform instanceof LinearOperator && ((LinearOperator)inverseTransform).isShift();
    }

    public static UniversalFramePosition valueOf(RectangularArea area, CoordinateTransformationOperator inverseTransform) {
        Objects.requireNonNull(area, "Null area argument");
        Objects.requireNonNull(inverseTransform, "Null inverseTransform argument");
        return new UniversalFramePosition(area, inverseTransform);
    }

    public static RectangularArea estimateDestinationAreaByVertices(long[] sourceMatrixDimensions, LinearOperator inverseTransform) {
        Objects.requireNonNull(sourceMatrixDimensions, "Null sourceMatrixDimensions argument");
        int n = sourceMatrixDimensions.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty sourceMatrixDimensions argument");
        }
        if (n > 63) {
            throw new IllegalArgumentException("Too large number of dimensions: " + n + " > 63");
        }
        double[] minDestCoordinates = new double[n];
        double[] maxDestCoordinates = new double[n];
        JArrays.fill(minDestCoordinates, Double.POSITIVE_INFINITY);
        JArrays.fill(maxDestCoordinates, Double.NEGATIVE_INFINITY);
        double[] srcCoordinates = new double[n];
        double[] destCoordinates = new double[n];
        int maxBits = (1 << n) - 1;
        block0: for (int bits = 0; bits <= maxBits; ++bits) {
            for (int k = 0; k < n; ++k) {
                srcCoordinates[k] = (bits >>> k & 1) == 0 ? 0.0 : (double)sourceMatrixDimensions[k];
            }
            inverseTransform.inverseMap(destCoordinates, srcCoordinates);
            for (double v : destCoordinates) {
                if (!Double.isNaN(v)) continue;
                JArrays.fill(minDestCoordinates, Double.NEGATIVE_INFINITY);
                JArrays.fill(maxDestCoordinates, Double.POSITIVE_INFINITY);
                break block0;
            }
            JArrays.minDoubleArray(minDestCoordinates, 0, destCoordinates, 0, n);
            JArrays.maxDoubleArray(maxDestCoordinates, 0, destCoordinates, 0, n);
        }
        return RectangularArea.valueOf(Point.valueOf(minDestCoordinates), Point.valueOf(maxDestCoordinates));
    }

    @Override
    public RectangularArea area() {
        return this.area;
    }

    @Override
    public Func asInterpolationFunc(Matrix<? extends PArray> sourceMatrix) {
        Point o = this.area.min();
        boolean integerShift = this.isShift && o.equals(o.toRoundedPoint().toPoint());
        Func f = Matrices.asInterpolationFunc(sourceMatrix, integerShift ? Matrices.InterpolationMethod.STEP_FUNCTION : Matrices.InterpolationMethod.POLYLINEAR_FUNCTION, Double.NaN);
        return this.inverseTransform.apply(f);
    }

    public CoordinateTransformationOperator inverseTransform() {
        return this.inverseTransform;
    }

    public String toString() {
        return "universal frame position " + String.valueOf(this.area) + " with " + String.valueOf(this.inverseTransform);
    }

    @Override
    public int hashCode() {
        return this.area.hashCode() * 37 + this.inverseTransform.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UniversalFramePosition)) {
            return false;
        }
        UniversalFramePosition ufp = (UniversalFramePosition)obj;
        return this.area.equals(ufp.area) && this.inverseTransform.equals(ufp.inverseTransform);
    }
}

