/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import net.algart.math.functions.Func;

public class MaxExceptingNaN
implements Func {
    private final double defaultValue;

    private MaxExceptingNaN(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static MaxExceptingNaN getInstance(double defaultValue) {
        return new MaxExceptingNaN(defaultValue);
    }

    @Override
    public double get(double ... x) {
        boolean valid = false;
        double max = Double.NEGATIVE_INFINITY;
        for (double v : x) {
            if (v != v) continue;
            if (v > max) {
                max = v;
            }
            valid = true;
        }
        return valid ? max : this.defaultValue;
    }

    @Override
    public double get() {
        return this.defaultValue;
    }

    @Override
    public double get(double x0) {
        return x0 == x0 ? x0 : this.defaultValue;
    }

    @Override
    public double get(double x0, double x1) {
        return x0 == x0 ? (x1 == x1 ? Math.max(x0, x1) : x0) : (x1 == x1 ? x1 : this.defaultValue);
    }

    @Override
    public double get(double x0, double x1, double x2) {
        boolean valid = false;
        if (x0 == x0) {
            valid = true;
        } else {
            x0 = Double.NEGATIVE_INFINITY;
        }
        if (x1 == x1) {
            valid = true;
        } else {
            x1 = Double.NEGATIVE_INFINITY;
        }
        if (x2 == x2) {
            valid = true;
        } else {
            x2 = Double.NEGATIVE_INFINITY;
        }
        if (!valid) {
            return this.defaultValue;
        }
        double x = Math.max(x0, x1);
        return Math.max(x, x2);
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        boolean valid = false;
        if (x0 == x0) {
            valid = true;
        } else {
            x0 = Double.NEGATIVE_INFINITY;
        }
        if (x1 == x1) {
            valid = true;
        } else {
            x1 = Double.NEGATIVE_INFINITY;
        }
        if (x2 == x2) {
            valid = true;
        } else {
            x2 = Double.NEGATIVE_INFINITY;
        }
        if (x3 == x3) {
            valid = true;
        } else {
            x3 = Double.NEGATIVE_INFINITY;
        }
        if (!valid) {
            return this.defaultValue;
        }
        double x = Math.max(x0, x1);
        double y = Math.max(x2, x3);
        return Math.max(x, y);
    }

    public String toString() {
        return "maximum function skipping NaN arguments";
    }
}

