/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

class RootsOfUnity {
    public static final int LOG_CACHE_SIZE = 20;
    public static final int HALF_CACHE_SIZE = 524288;
    public static final int CACHE_SIZE = 0x100000;
    public static final double[] SINE_CACHE = new double[524289];
    public static final double[] LOGARITHMICAL_SINE_CACHE = new double[65];

    RootsOfUnity() {
    }

    public static double quickSin(int angleIndex) {
        return angleIndex < 524288 ? SINE_CACHE[angleIndex] : SINE_CACHE[0x100000 - angleIndex];
    }

    public static double quickCos(int angleIndex) {
        return angleIndex < 524288 ? SINE_CACHE[524288 - angleIndex] : -SINE_CACHE[angleIndex - 524288];
    }

    static {
        RootsOfUnity.SINE_CACHE[0] = 0.0;
        for (int k = 1; k < 524288; ++k) {
            RootsOfUnity.SINE_CACHE[k] = StrictMath.sin(1.5707963267948966 * (double)k / 524288.0);
        }
        RootsOfUnity.SINE_CACHE[524288] = 1.0;
        RootsOfUnity.LOGARITHMICAL_SINE_CACHE[0] = 0.0;
        RootsOfUnity.LOGARITHMICAL_SINE_CACHE[1] = 1.0;
        double angle = 0.7853981633974483;
        for (int log = 2; log <= 64; ++log) {
            RootsOfUnity.LOGARITHMICAL_SINE_CACHE[log] = StrictMath.sin(angle);
            angle *= 0.5;
        }
    }
}

