/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.matrices.spectra.SampleArray;

public abstract class ComplexScalarSampleArray
implements SampleArray {
    public static ComplexScalarSampleArray asSampleArray(UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm) {
        DirectAccessible daIm;
        DirectAccessible daRe;
        Objects.requireNonNull(samplesRe, "Null samplesRe");
        Objects.requireNonNull(samplesIm, "Null samplesIm");
        samplesRe = (UpdatablePNumberArray)samplesRe.asUnresizable();
        samplesIm = (UpdatablePNumberArray)samplesIm.asUnresizable();
        if (samplesRe.length() != samplesIm.length()) {
            throw new SizeMismatchException("Different lengths of samplesRe and samplesIm");
        }
        if (samplesRe instanceof DirectAccessible && (daRe = (DirectAccessible)((Object)samplesRe)).hasJavaArray() && samplesIm instanceof DirectAccessible && (daIm = (DirectAccessible)((Object)samplesIm)).hasJavaArray()) {
            Object arrRe = daRe.javaArray();
            int ofsRe = daRe.javaArrayOffset();
            Object arrIm = daIm.javaArray();
            int ofsIm = daIm.javaArrayOffset();
            if (arrRe instanceof float[] && arrIm instanceof float[]) {
                if (ofsRe == 0 && ofsIm == 0) {
                    return new DirectZeroOffsetsComplexFloatSampleArray((float[])arrRe, (float[])arrIm, (int)samplesRe.length());
                }
                return new DirectComplexFloatSampleArray((float[])arrRe, ofsRe, (float[])arrIm, ofsIm, (int)samplesRe.length());
            }
            if (arrRe instanceof double[] && arrIm instanceof double[]) {
                if (ofsRe == 0 && ofsIm == 0) {
                    return new DirectZeroOffsetsComplexDoubleSampleArray((double[])arrRe, (double[])arrIm, (int)samplesRe.length());
                }
                return new DirectComplexDoubleSampleArray((double[])arrRe, ofsRe, (double[])arrIm, ofsIm, (int)samplesRe.length());
            }
        }
        return new CommonComplexScalarSampleArray(samplesRe, samplesIm);
    }

    @Override
    public final boolean isComplex() {
        return true;
    }

    @Override
    public abstract long length();

    @Override
    public abstract ComplexScalarSampleArray newCompatibleSamplesArray(long var1);

    @Override
    public abstract void copy(long var1, SampleArray var3, long var4);

    @Override
    public abstract void swap(long var1, long var3);

    @Override
    public abstract void add(long var1, SampleArray var3, long var4, long var6);

    @Override
    public abstract void sub(long var1, SampleArray var3, long var4, long var6);

    @Override
    public abstract void add(long var1, long var3, SampleArray var5, long var6);

    @Override
    public abstract void sub(long var1, long var3, SampleArray var5, long var6);

    @Override
    public abstract void add(long var1, long var3, long var5);

    @Override
    public abstract void sub(long var1, long var3, long var5);

    @Override
    public abstract void multiplyByScalar(long var1, SampleArray var3, long var4, double var6, double var8);

    @Override
    public abstract void multiplyByRealScalar(long var1, double var3);

    @Override
    public abstract void combineWithRealMultipliers(long var1, long var3, double var5, long var7, double var9);

    @Override
    public abstract void multiplyRangeByRealScalar(long var1, long var3, double var5);

    @Override
    public abstract String toString(String var1, String var2, int var3);

    static final class DirectZeroOffsetsComplexFloatSampleArray
    extends ComplexScalarSampleArray {
        final float[] samplesRe;
        final float[] samplesIm;
        final int length;

        DirectZeroOffsetsComplexFloatSampleArray(float[] samplesRe, float[] samplesIm, int length) {
            assert (length >= 0);
            assert (length <= samplesRe.length);
            assert (length <= samplesIm.length);
            this.samplesRe = samplesRe;
            this.samplesIm = samplesIm;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public ComplexScalarSampleArray newCompatibleSamplesArray(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length must be less than 2^31");
            }
            int len = (int)length;
            return new DirectZeroOffsetsComplexFloatSampleArray(new float[len], new float[len], len);
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            DirectZeroOffsetsComplexFloatSampleArray a = (DirectZeroOffsetsComplexFloatSampleArray)src;
            this.samplesRe[(int)destIndex] = a.samplesRe[(int)srcIndex];
            this.samplesIm[(int)destIndex] = a.samplesIm[(int)srcIndex];
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            float temp = this.samplesRe[(int)firstIndex];
            this.samplesRe[(int)firstIndex] = this.samplesRe[(int)secondIndex];
            this.samplesRe[(int)secondIndex] = temp;
            temp = this.samplesIm[(int)firstIndex];
            this.samplesIm[(int)firstIndex] = this.samplesIm[(int)secondIndex];
            this.samplesIm[(int)secondIndex] = temp;
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectZeroOffsetsComplexFloatSampleArray a = (DirectZeroOffsetsComplexFloatSampleArray)src;
            this.samplesRe[(int)destIndex] = a.samplesRe[(int)srcIndex1] + a.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = a.samplesIm[(int)srcIndex1] + a.samplesIm[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectZeroOffsetsComplexFloatSampleArray a = (DirectZeroOffsetsComplexFloatSampleArray)src;
            this.samplesRe[(int)destIndex] = a.samplesRe[(int)srcIndex1] - a.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = a.samplesIm[(int)srcIndex1] - a.samplesIm[(int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectZeroOffsetsComplexFloatSampleArray a2 = (DirectZeroOffsetsComplexFloatSampleArray)src2;
            this.samplesRe[(int)destIndex] = this.samplesRe[(int)srcIndex1] + a2.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = this.samplesIm[(int)srcIndex1] + a2.samplesIm[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectZeroOffsetsComplexFloatSampleArray a2 = (DirectZeroOffsetsComplexFloatSampleArray)src2;
            this.samplesRe[(int)destIndex] = this.samplesRe[(int)srcIndex1] - a2.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = this.samplesIm[(int)srcIndex1] - a2.samplesIm[(int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe[(int)destIndex] = this.samplesRe[(int)srcIndex1] + this.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = this.samplesIm[(int)srcIndex1] + this.samplesIm[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe[(int)destIndex] = this.samplesRe[(int)srcIndex1] - this.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = this.samplesIm[(int)srcIndex1] - this.samplesIm[(int)srcIndex2];
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectZeroOffsetsComplexFloatSampleArray a = (DirectZeroOffsetsComplexFloatSampleArray)src;
            double re = a.samplesRe[(int)srcIndex];
            double im = a.samplesIm[(int)srcIndex];
            this.samplesRe[(int)destIndex] = (float)(re * aRe - im * aIm);
            this.samplesIm[(int)destIndex] = (float)(re * aIm + im * aRe);
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            double re = this.samplesRe[(int)index];
            double im = this.samplesIm[(int)index];
            this.samplesRe[(int)index] = (float)(re * a);
            this.samplesIm[(int)index] = (float)(im * a);
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int destI = (int)destIndex;
            int srcI1 = (int)srcIndex1;
            int srcI2 = (int)srcIndex2;
            this.samplesRe[destI] = (float)((double)this.samplesRe[srcI1] * a1 + (double)this.samplesRe[srcI2] * a2);
            this.samplesIm[destI] = (float)((double)this.samplesIm[srcI1] * a1 + (double)this.samplesIm[srcI2] * a2);
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int from = (int)fromIndex;
            int to = (int)toIndex;
            for (int index = from; index < to; ++index) {
                this.samplesRe[index] = (float)((double)this.samplesRe[index] * a);
                this.samplesIm[index] = (float)((double)this.samplesIm[index] * a);
            }
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            if (this.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            format = "(" + (String)format + " " + (String)format + ")";
            sb.append(String.format((String)format, Float.valueOf(this.samplesRe[0]), Float.valueOf(this.samplesIm[0])));
            for (int k = 1; k < this.samplesRe.length; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format((String)format, Float.valueOf(this.samplesRe[k]), Float.valueOf(this.samplesIm[k])));
            }
            return sb.toString();
        }
    }

    static final class DirectComplexFloatSampleArray
    extends ComplexScalarSampleArray {
        final float[] samplesRe;
        final int ofsRe;
        final float[] samplesIm;
        final int ofsIm;
        final int length;

        DirectComplexFloatSampleArray(float[] samplesRe, int ofsRe, float[] samplesIm, int ofsIm, int length) {
            assert (ofsRe >= 0);
            assert (ofsIm >= 0);
            assert (length >= 0);
            assert (ofsRe <= samplesRe.length - length);
            assert (ofsIm <= samplesIm.length - length);
            this.samplesRe = samplesRe;
            this.ofsRe = ofsRe;
            this.samplesIm = samplesIm;
            this.ofsIm = ofsIm;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public ComplexScalarSampleArray newCompatibleSamplesArray(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length must be less than 2^31");
            }
            int len = (int)length;
            return new DirectComplexFloatSampleArray(new float[len], 0, new float[len], 0, len);
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            DirectComplexFloatSampleArray a = (DirectComplexFloatSampleArray)src;
            this.samplesRe[this.ofsRe + (int)destIndex] = a.samplesRe[a.ofsRe + (int)srcIndex];
            this.samplesIm[this.ofsIm + (int)destIndex] = a.samplesIm[a.ofsIm + (int)srcIndex];
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            float temp = this.samplesRe[this.ofsRe + (int)firstIndex];
            this.samplesRe[this.ofsRe + (int)firstIndex] = this.samplesRe[this.ofsRe + (int)secondIndex];
            this.samplesRe[this.ofsRe + (int)secondIndex] = temp;
            temp = this.samplesIm[this.ofsIm + (int)firstIndex];
            this.samplesIm[this.ofsIm + (int)firstIndex] = this.samplesIm[this.ofsIm + (int)secondIndex];
            this.samplesIm[this.ofsIm + (int)secondIndex] = temp;
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectComplexFloatSampleArray a = (DirectComplexFloatSampleArray)src;
            this.samplesRe[this.ofsRe + (int)destIndex] = a.samplesRe[a.ofsRe + (int)srcIndex1] + a.samplesRe[a.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = a.samplesIm[a.ofsIm + (int)srcIndex1] + a.samplesIm[a.ofsIm + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectComplexFloatSampleArray a = (DirectComplexFloatSampleArray)src;
            this.samplesRe[this.ofsRe + (int)destIndex] = a.samplesRe[a.ofsRe + (int)srcIndex1] - a.samplesRe[a.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = a.samplesIm[a.ofsIm + (int)srcIndex1] - a.samplesIm[a.ofsIm + (int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectComplexFloatSampleArray a2 = (DirectComplexFloatSampleArray)src2;
            this.samplesRe[this.ofsRe + (int)destIndex] = this.samplesRe[this.ofsRe + (int)srcIndex1] + a2.samplesRe[a2.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = this.samplesIm[this.ofsIm + (int)srcIndex1] + a2.samplesIm[a2.ofsIm + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectComplexFloatSampleArray a2 = (DirectComplexFloatSampleArray)src2;
            this.samplesRe[this.ofsRe + (int)destIndex] = this.samplesRe[this.ofsRe + (int)srcIndex1] - a2.samplesRe[a2.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = this.samplesIm[this.ofsIm + (int)srcIndex1] - a2.samplesIm[a2.ofsIm + (int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe[this.ofsRe + (int)destIndex] = this.samplesRe[this.ofsRe + (int)srcIndex1] + this.samplesRe[this.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = this.samplesIm[this.ofsIm + (int)srcIndex1] + this.samplesIm[this.ofsIm + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe[this.ofsRe + (int)destIndex] = this.samplesRe[this.ofsRe + (int)srcIndex1] - this.samplesRe[this.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = this.samplesIm[this.ofsIm + (int)srcIndex1] - this.samplesIm[this.ofsIm + (int)srcIndex2];
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectComplexFloatSampleArray a = (DirectComplexFloatSampleArray)src;
            double re = a.samplesRe[a.ofsRe + (int)srcIndex];
            double im = a.samplesIm[a.ofsIm + (int)srcIndex];
            this.samplesRe[this.ofsRe + (int)destIndex] = (float)(re * aRe - im * aIm);
            this.samplesIm[this.ofsIm + (int)destIndex] = (float)(re * aIm + im * aRe);
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            double re = this.samplesRe[this.ofsRe + (int)index];
            double im = this.samplesIm[this.ofsIm + (int)index];
            this.samplesRe[this.ofsRe + (int)index] = (float)(re * a);
            this.samplesIm[this.ofsIm + (int)index] = (float)(im * a);
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int destI = (int)destIndex;
            int srcI1 = (int)srcIndex1;
            int srcI2 = (int)srcIndex2;
            this.samplesRe[this.ofsRe + destI] = (float)((double)this.samplesRe[this.ofsRe + srcI1] * a1 + (double)this.samplesRe[this.ofsRe + srcI2] * a2);
            this.samplesIm[this.ofsIm + destI] = (float)((double)this.samplesIm[this.ofsIm + srcI1] * a1 + (double)this.samplesIm[this.ofsIm + srcI2] * a2);
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int indexRe = this.ofsRe + (int)fromIndex;
            int indexIm = this.ofsIm + (int)fromIndex;
            int indexReMax = indexRe + (int)(toIndex - fromIndex);
            while (indexRe < indexReMax) {
                this.samplesRe[indexRe] = (float)((double)this.samplesRe[indexRe] * a);
                this.samplesIm[indexIm] = (float)((double)this.samplesIm[indexIm] * a);
                ++indexRe;
                ++indexIm;
            }
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            if (this.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            format = "(" + (String)format + " " + (String)format + ")";
            sb.append(String.format((String)format, Float.valueOf(this.samplesRe[this.ofsRe]), Float.valueOf(this.samplesIm[this.ofsIm])));
            for (int k = 1; k < this.length; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format((String)format, Float.valueOf(this.samplesRe[this.ofsRe + k]), Float.valueOf(this.samplesIm[this.ofsIm + k])));
            }
            return sb.toString();
        }
    }

    static final class DirectZeroOffsetsComplexDoubleSampleArray
    extends ComplexScalarSampleArray {
        final double[] samplesRe;
        final double[] samplesIm;
        final int length;

        DirectZeroOffsetsComplexDoubleSampleArray(double[] samplesRe, double[] samplesIm, int length) {
            assert (length >= 0);
            assert (length <= samplesRe.length);
            assert (length <= samplesIm.length);
            this.samplesRe = samplesRe;
            this.samplesIm = samplesIm;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public ComplexScalarSampleArray newCompatibleSamplesArray(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length must be less than 2^31");
            }
            int len = (int)length;
            return new DirectZeroOffsetsComplexDoubleSampleArray(new double[len], new double[len], len);
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            DirectZeroOffsetsComplexDoubleSampleArray a = (DirectZeroOffsetsComplexDoubleSampleArray)src;
            this.samplesRe[(int)destIndex] = a.samplesRe[(int)srcIndex];
            this.samplesIm[(int)destIndex] = a.samplesIm[(int)srcIndex];
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            double temp = this.samplesRe[(int)firstIndex];
            this.samplesRe[(int)firstIndex] = this.samplesRe[(int)secondIndex];
            this.samplesRe[(int)secondIndex] = temp;
            temp = this.samplesIm[(int)firstIndex];
            this.samplesIm[(int)firstIndex] = this.samplesIm[(int)secondIndex];
            this.samplesIm[(int)secondIndex] = temp;
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectZeroOffsetsComplexDoubleSampleArray a = (DirectZeroOffsetsComplexDoubleSampleArray)src;
            this.samplesRe[(int)destIndex] = a.samplesRe[(int)srcIndex1] + a.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = a.samplesIm[(int)srcIndex1] + a.samplesIm[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectZeroOffsetsComplexDoubleSampleArray a = (DirectZeroOffsetsComplexDoubleSampleArray)src;
            this.samplesRe[(int)destIndex] = a.samplesRe[(int)srcIndex1] - a.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = a.samplesIm[(int)srcIndex1] - a.samplesIm[(int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectZeroOffsetsComplexDoubleSampleArray a2 = (DirectZeroOffsetsComplexDoubleSampleArray)src2;
            this.samplesRe[(int)destIndex] = this.samplesRe[(int)srcIndex1] + a2.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = this.samplesIm[(int)srcIndex1] + a2.samplesIm[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectZeroOffsetsComplexDoubleSampleArray a2 = (DirectZeroOffsetsComplexDoubleSampleArray)src2;
            this.samplesRe[(int)destIndex] = this.samplesRe[(int)srcIndex1] - a2.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = this.samplesIm[(int)srcIndex1] - a2.samplesIm[(int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe[(int)destIndex] = this.samplesRe[(int)srcIndex1] + this.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = this.samplesIm[(int)srcIndex1] + this.samplesIm[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe[(int)destIndex] = this.samplesRe[(int)srcIndex1] - this.samplesRe[(int)srcIndex2];
            this.samplesIm[(int)destIndex] = this.samplesIm[(int)srcIndex1] - this.samplesIm[(int)srcIndex2];
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectZeroOffsetsComplexDoubleSampleArray a = (DirectZeroOffsetsComplexDoubleSampleArray)src;
            double re = a.samplesRe[(int)srcIndex];
            double im = a.samplesIm[(int)srcIndex];
            this.samplesRe[(int)destIndex] = re * aRe - im * aIm;
            this.samplesIm[(int)destIndex] = re * aIm + im * aRe;
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            double re = this.samplesRe[(int)index];
            double im = this.samplesIm[(int)index];
            this.samplesRe[(int)index] = re * a;
            this.samplesIm[(int)index] = im * a;
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int destI = (int)destIndex;
            int srcI1 = (int)srcIndex1;
            int srcI2 = (int)srcIndex2;
            this.samplesRe[destI] = this.samplesRe[srcI1] * a1 + this.samplesRe[srcI2] * a2;
            this.samplesIm[destI] = this.samplesIm[srcI1] * a1 + this.samplesIm[srcI2] * a2;
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int from = (int)fromIndex;
            int to = (int)toIndex;
            for (int index = from; index < to; ++index) {
                this.samplesRe[index] = this.samplesRe[index] * a;
                this.samplesIm[index] = this.samplesIm[index] * a;
            }
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            if (this.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            format = "(" + (String)format + " " + (String)format + ")";
            sb.append(String.format((String)format, this.samplesRe[0], this.samplesIm[0]));
            for (int k = 1; k < this.samplesRe.length; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format((String)format, this.samplesRe[k], this.samplesIm[k]));
            }
            return sb.toString();
        }
    }

    static final class DirectComplexDoubleSampleArray
    extends ComplexScalarSampleArray {
        final double[] samplesRe;
        final int ofsRe;
        final double[] samplesIm;
        final int ofsIm;
        final int length;

        DirectComplexDoubleSampleArray(double[] samplesRe, int ofsRe, double[] samplesIm, int ofsIm, int length) {
            assert (ofsRe >= 0);
            assert (ofsIm >= 0);
            assert (length >= 0);
            assert (ofsRe <= samplesRe.length - length);
            assert (ofsIm <= samplesIm.length - length);
            this.samplesRe = samplesRe;
            this.ofsRe = ofsRe;
            this.samplesIm = samplesIm;
            this.ofsIm = ofsIm;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public ComplexScalarSampleArray newCompatibleSamplesArray(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length must be less than 2^31");
            }
            int len = (int)length;
            return new DirectComplexDoubleSampleArray(new double[len], 0, new double[len], 0, len);
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            DirectComplexDoubleSampleArray a = (DirectComplexDoubleSampleArray)src;
            this.samplesRe[this.ofsRe + (int)destIndex] = a.samplesRe[a.ofsRe + (int)srcIndex];
            this.samplesIm[this.ofsIm + (int)destIndex] = a.samplesIm[a.ofsIm + (int)srcIndex];
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            double temp = this.samplesRe[this.ofsRe + (int)firstIndex];
            this.samplesRe[this.ofsRe + (int)firstIndex] = this.samplesRe[this.ofsRe + (int)secondIndex];
            this.samplesRe[this.ofsRe + (int)secondIndex] = temp;
            temp = this.samplesIm[this.ofsIm + (int)firstIndex];
            this.samplesIm[this.ofsIm + (int)firstIndex] = this.samplesIm[this.ofsIm + (int)secondIndex];
            this.samplesIm[this.ofsIm + (int)secondIndex] = temp;
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectComplexDoubleSampleArray a = (DirectComplexDoubleSampleArray)src;
            this.samplesRe[this.ofsRe + (int)destIndex] = a.samplesRe[a.ofsRe + (int)srcIndex1] + a.samplesRe[a.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = a.samplesIm[a.ofsIm + (int)srcIndex1] + a.samplesIm[a.ofsIm + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectComplexDoubleSampleArray a = (DirectComplexDoubleSampleArray)src;
            this.samplesRe[this.ofsRe + (int)destIndex] = a.samplesRe[a.ofsRe + (int)srcIndex1] - a.samplesRe[a.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = a.samplesIm[a.ofsIm + (int)srcIndex1] - a.samplesIm[a.ofsIm + (int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectComplexDoubleSampleArray a2 = (DirectComplexDoubleSampleArray)src2;
            this.samplesRe[this.ofsRe + (int)destIndex] = this.samplesRe[this.ofsRe + (int)srcIndex1] + a2.samplesRe[a2.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = this.samplesIm[this.ofsIm + (int)srcIndex1] + a2.samplesIm[a2.ofsIm + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectComplexDoubleSampleArray a2 = (DirectComplexDoubleSampleArray)src2;
            this.samplesRe[this.ofsRe + (int)destIndex] = this.samplesRe[this.ofsRe + (int)srcIndex1] - a2.samplesRe[a2.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = this.samplesIm[this.ofsIm + (int)srcIndex1] - a2.samplesIm[a2.ofsIm + (int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe[this.ofsRe + (int)destIndex] = this.samplesRe[this.ofsRe + (int)srcIndex1] + this.samplesRe[this.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = this.samplesIm[this.ofsIm + (int)srcIndex1] + this.samplesIm[this.ofsIm + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe[this.ofsRe + (int)destIndex] = this.samplesRe[this.ofsRe + (int)srcIndex1] - this.samplesRe[this.ofsRe + (int)srcIndex2];
            this.samplesIm[this.ofsIm + (int)destIndex] = this.samplesIm[this.ofsIm + (int)srcIndex1] - this.samplesIm[this.ofsIm + (int)srcIndex2];
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectComplexDoubleSampleArray a = (DirectComplexDoubleSampleArray)src;
            double re = a.samplesRe[a.ofsRe + (int)srcIndex];
            double im = a.samplesIm[a.ofsIm + (int)srcIndex];
            this.samplesRe[this.ofsRe + (int)destIndex] = re * aRe - im * aIm;
            this.samplesIm[this.ofsIm + (int)destIndex] = re * aIm + im * aRe;
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            double re = this.samplesRe[this.ofsRe + (int)index];
            double im = this.samplesIm[this.ofsIm + (int)index];
            this.samplesRe[this.ofsRe + (int)index] = re * a;
            this.samplesIm[this.ofsIm + (int)index] = im * a;
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int destI = (int)destIndex;
            int srcI1 = (int)srcIndex1;
            int srcI2 = (int)srcIndex2;
            this.samplesRe[this.ofsRe + destI] = this.samplesRe[this.ofsRe + srcI1] * a1 + this.samplesRe[this.ofsRe + srcI2] * a2;
            this.samplesIm[this.ofsIm + destI] = this.samplesIm[this.ofsIm + srcI1] * a1 + this.samplesIm[this.ofsIm + srcI2] * a2;
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int indexRe = this.ofsRe + (int)fromIndex;
            int indexIm = this.ofsIm + (int)fromIndex;
            int indexReMax = indexRe + (int)(toIndex - fromIndex);
            while (indexRe < indexReMax) {
                this.samplesRe[indexRe] = this.samplesRe[indexRe] * a;
                this.samplesIm[indexIm] = this.samplesIm[indexIm] * a;
                ++indexRe;
                ++indexIm;
            }
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            if (this.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            format = "(" + (String)format + " " + (String)format + ")";
            sb.append(String.format((String)format, this.samplesRe[this.ofsRe], this.samplesIm[this.ofsIm]));
            for (int k = 1; k < this.length; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format((String)format, this.samplesRe[this.ofsRe + k], this.samplesIm[this.ofsIm + k]));
            }
            return sb.toString();
        }
    }

    static final class CommonComplexScalarSampleArray
    extends ComplexScalarSampleArray {
        private final UpdatablePNumberArray samplesRe;
        private final UpdatablePNumberArray samplesIm;

        CommonComplexScalarSampleArray(UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm) {
            Objects.requireNonNull(samplesRe, "Null samplesRe");
            Objects.requireNonNull(samplesIm, "Null samplesIm");
            if (samplesRe.length() != samplesIm.length()) {
                throw new IllegalArgumentException("Different lengths of samplesRe and samplesIm");
            }
            this.samplesRe = samplesRe;
            this.samplesIm = samplesIm;
        }

        @Override
        public long length() {
            return this.samplesRe.length();
        }

        @Override
        public ComplexScalarSampleArray newCompatibleSamplesArray(long length) {
            return new CommonComplexScalarSampleArray((UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samplesRe), (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samplesIm));
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            CommonComplexScalarSampleArray a = (CommonComplexScalarSampleArray)src;
            this.samplesRe.setDouble(destIndex, a.samplesRe.getDouble(srcIndex));
            this.samplesIm.setDouble(destIndex, a.samplesIm.getDouble(srcIndex));
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            this.samplesRe.swap(firstIndex, secondIndex);
            this.samplesIm.swap(firstIndex, secondIndex);
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            CommonComplexScalarSampleArray a = (CommonComplexScalarSampleArray)src;
            this.samplesRe.setDouble(destIndex, a.samplesRe.getDouble(srcIndex1) + a.samplesRe.getDouble(srcIndex2));
            this.samplesIm.setDouble(destIndex, a.samplesIm.getDouble(srcIndex1) + a.samplesIm.getDouble(srcIndex2));
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            CommonComplexScalarSampleArray a = (CommonComplexScalarSampleArray)src;
            this.samplesRe.setDouble(destIndex, a.samplesRe.getDouble(srcIndex1) - a.samplesRe.getDouble(srcIndex2));
            this.samplesIm.setDouble(destIndex, a.samplesIm.getDouble(srcIndex1) - a.samplesIm.getDouble(srcIndex2));
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            CommonComplexScalarSampleArray a2 = (CommonComplexScalarSampleArray)src2;
            this.samplesRe.setDouble(destIndex, this.samplesRe.getDouble(srcIndex1) + a2.samplesRe.getDouble(srcIndex2));
            this.samplesIm.setDouble(destIndex, this.samplesIm.getDouble(srcIndex1) + a2.samplesIm.getDouble(srcIndex2));
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            CommonComplexScalarSampleArray a2 = (CommonComplexScalarSampleArray)src2;
            this.samplesRe.setDouble(destIndex, this.samplesRe.getDouble(srcIndex1) - a2.samplesRe.getDouble(srcIndex2));
            this.samplesIm.setDouble(destIndex, this.samplesIm.getDouble(srcIndex1) - a2.samplesIm.getDouble(srcIndex2));
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe.setDouble(destIndex, this.samplesRe.getDouble(srcIndex1) + this.samplesRe.getDouble(srcIndex2));
            this.samplesIm.setDouble(destIndex, this.samplesIm.getDouble(srcIndex1) + this.samplesIm.getDouble(srcIndex2));
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samplesRe.setDouble(destIndex, this.samplesRe.getDouble(srcIndex1) - this.samplesRe.getDouble(srcIndex2));
            this.samplesIm.setDouble(destIndex, this.samplesIm.getDouble(srcIndex1) - this.samplesIm.getDouble(srcIndex2));
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            CommonComplexScalarSampleArray a = (CommonComplexScalarSampleArray)src;
            double re = a.samplesRe.getDouble(srcIndex);
            double im = a.samplesIm.getDouble(srcIndex);
            this.samplesRe.setDouble(destIndex, re * aRe - im * aIm);
            this.samplesIm.setDouble(destIndex, re * aIm + im * aRe);
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            this.samplesRe.setDouble(index, this.samplesRe.getDouble(index) * a);
            this.samplesIm.setDouble(index, this.samplesIm.getDouble(index) * a);
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            for (long index = fromIndex; index < toIndex; ++index) {
                this.samplesRe.setDouble(index, this.samplesRe.getDouble(index) * a);
                this.samplesIm.setDouble(index, this.samplesIm.getDouble(index) * a);
            }
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            this.samplesRe.setDouble(destIndex, this.samplesRe.getDouble(srcIndex1) * a1 + this.samplesRe.getDouble(srcIndex2) * a2);
            this.samplesIm.setDouble(destIndex, this.samplesIm.getDouble(srcIndex1) * a1 + this.samplesIm.getDouble(srcIndex2) * a2);
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            long n = this.samplesRe.length();
            if (n == 0L) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            format = "(" + (String)format + " " + (String)format + ")";
            sb.append(String.format((String)format, this.samplesRe.getDouble(0L), this.samplesIm.getDouble(0L)));
            for (long k = 1L; k < n; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format((String)format, this.samplesRe.getDouble(k), this.samplesIm.getDouble(k)));
            }
            return sb.toString();
        }
    }
}

