/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.math.IPoint;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Patterns;
import net.algart.matrices.morphology.IterativeErosion;

class ThinningTools {
    private ThinningTools() {
    }

    static long estimatedNumberOfIterations(Matrix<? extends BitArray> matrix, boolean topological) {
        int dc = matrix.dimCount();
        long n = IterativeErosion.estimatedNumberOfIterations(matrix, Patterns.newRectangularIntegerPattern(ThinningTools.point(-1, -1, dc), ThinningTools.point(1, 1, dc)));
        if (topological) {
            n = Math.min(n, 0xFFFFFFFFFFFFFFFL) * 8L;
        }
        return n;
    }

    private static long[] coordinates(int x, int y, int dimCount) {
        long[] coordinates = new long[dimCount];
        coordinates[0] = x;
        if (coordinates.length > 0) {
            coordinates[1] = y;
        }
        return coordinates;
    }

    private static IPoint point(int x, int y, int dimCount) {
        return IPoint.valueOf(ThinningTools.coordinates(x, y, dimCount));
    }

    static Matrix<?>[] shifts(Matrix<? extends BitArray> bitMatrix, int[] xy) {
        assert (xy.length % 2 == 0);
        Matrix[] result = new Matrix[xy.length / 2];
        for (int k = 0; k < result.length; ++k) {
            result[k] = Matrices.asShifted(bitMatrix, ThinningTools.coordinates(xy[2 * k], xy[2 * k + 1], bitMatrix.dimCount()));
        }
        return result;
    }

    static Matrix<BitArray> shift(Matrix<? extends BitArray> bitMatrix, int[] xy) {
        return Matrices.asShifted(bitMatrix, ThinningTools.coordinates(xy[0], xy[1], bitMatrix.dimCount())).cast(BitArray.class);
    }

    static Matrix<BitArray> or(Matrix<?> ... bitMatrices) {
        return Matrices.asFuncMatrix(Func.MAX, BitArray.class, Matrices.several(BitArray.class, bitMatrices));
    }

    static Matrix<BitArray> and(Matrix<?> ... bitMatrices) {
        return Matrices.asFuncMatrix(Func.MIN, BitArray.class, Matrices.several(BitArray.class, bitMatrices));
    }

    static Matrix<BitArray> andNot(Matrix<BitArray> a, Matrix<BitArray> b) {
        return Matrices.asFuncMatrix(Func.POSITIVE_DIFF, BitArray.class, a, b);
    }

    static Matrix<BitArray> not(Matrix<? extends BitArray> bitMatrix) {
        return Matrices.asFuncMatrix((Func)Func.REVERSE, BitArray.class, bitMatrix);
    }

    static int[][] rotate90(int[][] xy) {
        int[][] result = new int[xy.length][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = ThinningTools.rotate90(xy[k]);
        }
        return result;
    }

    static int[][] rotate180(int[][] xy) {
        int[][] result = new int[xy.length][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = ThinningTools.rotate180(xy[k]);
        }
        return result;
    }

    static int[][] rotate270(int[][] xy) {
        int[][] result = new int[xy.length][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = ThinningTools.rotate270(xy[k]);
        }
        return result;
    }

    private static int[] rotate90(int[] xy) {
        int[] result = new int[xy.length];
        for (int k = 0; k < result.length; k += 2) {
            result[k] = -xy[k + 1];
            result[k + 1] = xy[k];
        }
        return result;
    }

    private static int[] rotate180(int[] xy) {
        int[] result = new int[xy.length];
        for (int k = 0; k < result.length; k += 2) {
            result[k] = -xy[k];
            result[k + 1] = -xy[k + 1];
        }
        return result;
    }

    private static int[] rotate270(int[] xy) {
        int[] result = new int[xy.length];
        for (int k = 0; k < result.length; k += 2) {
            result[k] = xy[k + 1];
            result[k + 1] = -xy[k];
        }
        return result;
    }
}

