/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import java.util.Objects;
import net.algart.arrays.AbstractIterativeArrayProcessor;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.UpdatableBitArray;
import net.algart.matrices.skeletons.ErodingSkeleton;
import net.algart.matrices.skeletons.ThinningSkeleton;

abstract class AbstractThinningSkeleton2D
extends AbstractIterativeArrayProcessor<Matrix<? extends UpdatableBitArray>>
implements ThinningSkeleton {
    final boolean straightThinning;
    final boolean diagonalThinning;
    final MemoryModel mm;
    Matrix<? extends UpdatableBitArray> result;
    Matrix<? extends UpdatableBitArray> temp;
    private long cardinality = -1L;
    boolean done = false;

    AbstractThinningSkeleton2D(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix, boolean straightThinning, boolean diagonalThinning) {
        super(context);
        Objects.requireNonNull(matrix, "Null matrix argument");
        this.mm = ErodingSkeleton.mm(this.memoryModel, matrix, 1);
        this.result = matrix;
        this.temp = this.mm.newMatrix(UpdatableBitArray.class, Boolean.TYPE, matrix.dimensions());
        this.straightThinning = straightThinning;
        this.diagonalThinning = diagonalThinning;
    }

    @Override
    public final void performIteration(ArrayContext context) {
        ArrayContext c;
        ArrayContext arrayContext = c = this.cardinality == -1L ? AbstractThinningSkeleton2D.part(context, 0.02, 0.98) : AbstractThinningSkeleton2D.part(context, 0.02, 1.0);
        if (this.cardinality == -1L) {
            this.cardinality = Arrays.cardinality(AbstractThinningSkeleton2D.part(context, 0.0, 0.02), this.result.array());
        }
        long lastCardinality = this.cardinality;
        double part = this.straightThinning && this.diagonalThinning ? 0.125 : 0.25;
        for (int k = 0; k < 8; ++k) {
            if (!this.isThinningRequired(k)) continue;
            Matrices.copy(AbstractThinningSkeleton2D.part(c, (double)k * 0.125, Math.min((double)k * 0.125 + part, 1.0)), this.temp, this.asThinning(k));
            Matrix<? extends UpdatableBitArray> t = this.temp;
            this.temp = this.result;
            this.result = t;
        }
        this.cardinality = Arrays.cardinality(AbstractThinningSkeleton2D.part(context, 0.98, 1.0), this.result.array());
        this.done = this.cardinality == lastCardinality;
    }

    @Override
    public final boolean done() {
        return this.done;
    }

    @Override
    public abstract long estimatedNumberOfIterations();

    @Override
    public final Matrix<? extends UpdatableBitArray> result() {
        return this.result;
    }

    @Override
    public final void freeResources(ArrayContext context) {
        this.temp.freeResources(context == null ? null : context.part(0.0, 0.5));
        this.result.freeResources(context == null ? null : context.part(0.5, 1.0));
    }

    @Override
    public final boolean isThinningRequired(int directionIndex) {
        if (directionIndex < 0 || directionIndex > 7) {
            throw new IllegalArgumentException("Illegal directionIndex = " + directionIndex + " (must be 0..7)");
        }
        return directionIndex % 2 == 0 ? this.straightThinning : this.diagonalThinning;
    }

    @Override
    public abstract Matrix<BitArray> asThinning(int var1);
}

