/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.algart.arrays.AbstractArrayProcessorWithContextSwitching;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayProcessorWithContextSwitching;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.ApertureProcessor;
import net.algart.matrices.DependenceApertureBuilder;
import net.algart.matrices.TiledApertureProcessorFactory;
import net.algart.matrices.morphology.Continuer;
import net.algart.matrices.morphology.RankMorphology;
import net.algart.matrices.morphology.TiledMorphology;

public class TiledRankMorphology
extends TiledMorphology
implements RankMorphology {
    private final RankMorphology parent;
    private final Matrix.ContinuationMode continuationMode;

    TiledRankMorphology(RankMorphology parent, TiledApertureProcessorFactory tiler) {
        super(parent, tiler);
        this.parent = parent;
        this.continuationMode = tiler.continuationMode();
    }

    public static TiledRankMorphology getInstance(RankMorphology parent, TiledApertureProcessorFactory tiler) {
        return new TiledRankMorphology(parent, tiler);
    }

    @Override
    public RankMorphology parent() {
        return this.parent;
    }

    @Override
    public RankMorphology context(ArrayContext newContext) {
        return new TiledRankMorphology(this.parent.context(newContext), this.tiler);
    }

    @Override
    public Matrix<? extends PArray> asPercentile(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, Pattern pattern) {
        Continuer c = new Continuer(null, src, percentileIndexes, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asPercentile(c.get(0), c.get(1), pattern));
    }

    @Override
    public Matrix<? extends PArray> asPercentile(Matrix<? extends PArray> src, double percentileIndex, Pattern pattern) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asPercentile(c.get(0), percentileIndex, pattern));
    }

    @Override
    public <T extends PArray> Matrix<T> asRank(Class<? extends T> requiredType, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, Pattern pattern) {
        Continuer c = new Continuer(null, baseMatrix, rankedMatrix, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asRank(requiredType, c.get(0), c.get(1), pattern));
    }

    @Override
    public Matrix<? extends PArray> asMeanBetweenPercentiles(Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentileIndexes, Matrix<? extends PArray> toPercentileIndexes, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, fromPercentileIndexes, toPercentileIndexes, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asMeanBetweenPercentiles(c.get(0), c.get(1), c.get(2), pattern, filler));
    }

    @Override
    public Matrix<? extends PArray> asMeanBetweenPercentiles(Matrix<? extends PArray> src, double fromPercentileIndex, double toPercentileIndex, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asMeanBetweenPercentiles(c.get(0), fromPercentileIndex, toPercentileIndex, pattern, filler));
    }

    @Override
    public Matrix<? extends PArray> asMeanBetweenValues(Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, Pattern pattern, double filler) {
        Continuer c = new Continuer(null, src, minValues, maxValues, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asMeanBetweenValues(c.get(0), c.get(1), c.get(2), pattern, filler));
    }

    @Override
    public Matrix<? extends PArray> asMean(Matrix<? extends PArray> src, Pattern pattern) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asMean(c.get(0), pattern));
    }

    @Override
    public Matrix<? extends PArray> asFunctionOfSum(Matrix<? extends PArray> src, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asFunctionOfSum(c.get(0), pattern, processingFunc));
    }

    @Override
    public Matrix<? extends PArray> asFunctionOfPercentilePair(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes1, Matrix<? extends PArray> percentileIndexes2, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, percentileIndexes1, percentileIndexes2, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asFunctionOfPercentilePair(c.get(0), c.get(1), c.get(2), pattern, processingFunc));
    }

    @Override
    public Matrix<? extends PArray> asFunctionOfPercentilePair(Matrix<? extends PArray> src, double percentileIndex1, double percentileIndex2, Pattern pattern, Func processingFunc) {
        Continuer c = new Continuer(null, src, pattern, this.parent, this.continuationMode);
        return c.reduce(this.parent.asFunctionOfPercentilePair(c.get(0), percentileIndex1, percentileIndex2, pattern, processingFunc));
    }

    @Override
    public Matrix<? extends UpdatablePArray> percentile(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, final Pattern pattern) {
        return this.tilingProcess(new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().percentile(src.get(0), src.get(1), pattern);
            }
        }, null, src, percentileIndexes);
    }

    @Override
    public Matrix<? extends UpdatablePArray> percentile(Matrix<? extends PArray> src, final double percentileIndex, final Pattern pattern) {
        return this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().percentile(src.get(0), percentileIndex, pattern);
            }
        }, null, src);
    }

    @Override
    public <T extends PArray> Matrix<? extends T> rank(final Class<? extends T> requiredType, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, final Pattern pattern) {
        return this.tilingProcess(new RankMorphologyProcessor(this, baseMatrix.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().rank(requiredType, src.get(0), src.get(1), pattern);
            }
        }, null, baseMatrix, rankedMatrix).cast(requiredType);
    }

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenPercentiles(Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentileIndexes, Matrix<? extends PArray> toPercentileIndexes, final Pattern pattern, final double filler) {
        return this.tilingProcess(new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().meanBetweenPercentiles(src.get(0), src.get(1), src.get(2), pattern, filler);
            }
        }, null, src, fromPercentileIndexes, toPercentileIndexes);
    }

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenPercentiles(Matrix<? extends PArray> src, final double fromPercentileIndex, final double toPercentileIndex, final Pattern pattern, final double filler) {
        return this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().meanBetweenPercentiles(src.get(0), fromPercentileIndex, toPercentileIndex, pattern, filler);
            }
        }, null, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenValues(Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, final Pattern pattern, final double filler) {
        return this.tilingProcess(new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().meanBetweenValues(src.get(0), src.get(1), src.get(2), pattern, filler);
            }
        }, null, src, minValues, maxValues);
    }

    @Override
    public Matrix<? extends UpdatablePArray> mean(Matrix<? extends PArray> src, final Pattern pattern) {
        return this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().mean(src.get(0), pattern);
            }
        }, null, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> functionOfSum(Matrix<? extends PArray> src, final Pattern pattern, final Func processingFunc) {
        return this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().functionOfSum(src.get(0), pattern, processingFunc);
            }
        }, null, src);
    }

    @Override
    public Matrix<? extends UpdatablePArray> functionOfPercentilePair(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes1, Matrix<? extends PArray> percentileIndexes2, final Pattern pattern, final Func processingFunc) {
        return this.tilingProcess(new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().functionOfPercentilePair(src.get(0), src.get(1), src.get(2), pattern, processingFunc);
            }
        }, null, src, percentileIndexes1, percentileIndexes2);
    }

    @Override
    public Matrix<? extends UpdatablePArray> functionOfPercentilePair(Matrix<? extends PArray> src, final double percentileIndex1, final double percentileIndex2, final Pattern pattern, final Func processingFunc) {
        return this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyProcessor(this, src.dimCount(), pattern){

            @Override
            public Matrix<? extends PArray> process(List<Matrix<? extends PArray>> src) {
                return this.parent().functionOfPercentilePair(src.get(0), percentileIndex1, percentileIndex2, pattern, processingFunc);
            }
        }, null, src);
    }

    @Override
    public void percentile(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, final Pattern pattern) {
        this.tilingProcess(new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().percentile(dest, src.get(0), src.get(1), pattern);
            }
        }, dest, src, percentileIndexes);
    }

    @Override
    public void percentile(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, final double percentileIndex, final Pattern pattern) {
        this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().percentile(dest, src.get(0), percentileIndex, pattern);
            }
        }, dest, src);
    }

    @Override
    public void rank(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, final Pattern pattern) {
        this.tilingProcess(new RankMorphologyInPlaceProcessor(this, baseMatrix.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().rank(dest, src.get(0), src.get(1), pattern);
            }
        }, dest, baseMatrix, rankedMatrix);
    }

    @Override
    public void meanBetweenPercentiles(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentileIndexes, Matrix<? extends PArray> toPercentileIndexes, final Pattern pattern, final double filler) {
        this.tilingProcess(new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().meanBetweenPercentiles(dest, src.get(0), src.get(1), src.get(2), pattern, filler);
            }
        }, dest, src, fromPercentileIndexes, toPercentileIndexes);
    }

    @Override
    public void meanBetweenPercentiles(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, final double fromPercentileIndex, final double toPercentileIndex, final Pattern pattern, final double filler) {
        this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().meanBetweenPercentiles(dest, src.get(0), fromPercentileIndex, toPercentileIndex, pattern, filler);
            }
        }, dest, src);
    }

    @Override
    public void meanBetweenValues(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, final Pattern pattern, final double filler) {
        this.tilingProcess(new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().meanBetweenValues(dest, src.get(0), src.get(1), src.get(2), pattern, filler);
            }
        }, dest, src, minValues, maxValues);
    }

    @Override
    public void mean(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, final Pattern pattern) {
        this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().mean(dest, src.get(0), pattern);
            }
        }, dest, src);
    }

    @Override
    public void functionOfSum(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, final Pattern pattern, final Func processingFunc) {
        this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().functionOfSum(dest, src.get(0), pattern, processingFunc);
            }
        }, dest, src);
    }

    @Override
    public void functionOfPercentilePair(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes1, Matrix<? extends PArray> percentileIndexes2, final Pattern pattern, final Func processingFunc) {
        this.tilingProcess(new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().functionOfPercentilePair(dest, src.get(0), src.get(1), src.get(2), pattern, processingFunc);
            }
        }, dest, src, percentileIndexes1, percentileIndexes2);
    }

    @Override
    public void functionOfPercentilePair(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, final double percentileIndex1, final double percentileIndex2, final Pattern pattern, final Func processingFunc) {
        this.tilingProcess((ApertureProcessor<Integer>)new RankMorphologyInPlaceProcessor(this, src.dimCount(), pattern){

            @Override
            public void process(Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
                this.parent().functionOfPercentilePair(dest, src.get(0), percentileIndex1, percentileIndex2, pattern, processingFunc);
            }
        }, dest, src);
    }

    private Matrix<? extends UpdatablePArray> tilingProcess(ApertureProcessor<Integer> processor, Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
        return this.tilingProcess(processor, dest, Matrices.several(PArray.class, src));
    }

    private Matrix<? extends UpdatablePArray> tilingProcess(ApertureProcessor<Integer> processor, Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> additional) {
        return this.tilingProcess(processor, dest, Matrices.several(PArray.class, src, additional));
    }

    private Matrix<? extends UpdatablePArray> tilingProcess(ApertureProcessor<Integer> processor, Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> additional1, Matrix<? extends PArray> additional2) {
        return this.tilingProcess(processor, dest, Matrices.several(PArray.class, src, additional1, additional2));
    }

    private Matrix<? extends UpdatablePArray> tilingProcess(ApertureProcessor<Integer> processor, Matrix<? extends UpdatablePArray> dest, List<Matrix<? extends PArray>> src) {
        LinkedHashMap<Integer, Matrix<? extends UpdatablePArray>> destMatrices = new LinkedHashMap<Integer, Matrix<? extends UpdatablePArray>>();
        LinkedHashMap<Integer, Matrix<? extends PArray>> srcMatrices = new LinkedHashMap<Integer, Matrix<? extends PArray>>();
        destMatrices.put(0, dest);
        int n = src.size();
        for (int i = 0; i < n; ++i) {
            srcMatrices.put(i, src.get(i));
        }
        this.tiler.tile(processor).process(destMatrices, srcMatrices);
        return ((Matrix)destMatrices.get(0)).cast(UpdatablePArray.class);
    }

    private abstract class RankMorphologyInPlaceProcessor
    extends AbstractArrayProcessorWithContextSwitching
    implements ApertureProcessor<Integer>,
    ArrayProcessorWithContextSwitching {
        private final IRectangularArea dependenceAperture;
        private final IRectangularArea emptyAperture;

        private RankMorphologyInPlaceProcessor(int dimCount, Pattern pattern) {
            super(null);
            this.dependenceAperture = DependenceApertureBuilder.SUM_MAX_0.getAperture(dimCount, pattern, false);
            this.emptyAperture = IRectangularArea.valueOf(IPoint.origin(dimCount), IPoint.origin(dimCount));
        }

        public RankMorphology parent() {
            return TiledRankMorphology.this.parent.context(this.context());
        }

        @Override
        public void process(Map<Integer, Matrix<?>> dest, Map<Integer, Matrix<?>> src) {
            assert (src.size() <= 3);
            assert (dest.size() == 1);
            ArrayList<Matrix<? extends PArray>> srcMatrices = new ArrayList<Matrix<? extends PArray>>();
            for (int i = 0; i < 3; ++i) {
                Matrix<?> m = src.get(i);
                if (m == null) continue;
                srcMatrices.add(src.get(i).cast(PArray.class));
            }
            assert (srcMatrices.size() == src.size()) : "not all arguments specified";
            this.process(dest.get(0).cast(UpdatablePArray.class), srcMatrices);
        }

        public abstract void process(Matrix<? extends UpdatablePArray> var1, List<Matrix<? extends PArray>> var2);

        @Override
        public IRectangularArea dependenceAperture(Integer srcMatrixKey) {
            return srcMatrixKey == 0 ? this.dependenceAperture : this.emptyAperture;
        }
    }

    private abstract class RankMorphologyProcessor
    extends AbstractArrayProcessorWithContextSwitching
    implements ApertureProcessor<Integer>,
    ArrayProcessorWithContextSwitching {
        private final IRectangularArea dependenceAperture;
        private final IRectangularArea emptyAperture;

        private RankMorphologyProcessor(int dimCount, Pattern pattern) {
            super(null);
            this.dependenceAperture = DependenceApertureBuilder.SUM_MAX_0.getAperture(dimCount, pattern, false);
            this.emptyAperture = IRectangularArea.valueOf(IPoint.origin(dimCount), IPoint.origin(dimCount));
        }

        public RankMorphology parent() {
            return TiledRankMorphology.this.parent.context(this.context());
        }

        @Override
        public void process(Map<Integer, Matrix<?>> dest, Map<Integer, Matrix<?>> src) {
            assert (src.size() <= 3);
            assert (dest.size() == 1);
            ArrayList<Matrix<? extends PArray>> srcMatrices = new ArrayList<Matrix<? extends PArray>>();
            for (int i = 0; i < 3; ++i) {
                Matrix<?> m = src.get(i);
                if (m == null) continue;
                srcMatrices.add(src.get(i).cast(PArray.class));
            }
            assert (srcMatrices.size() == src.size()) : "not all arguments specified";
            dest.put(0, this.process(srcMatrices));
        }

        public abstract Matrix<? extends PArray> process(List<Matrix<? extends PArray>> var1);

        @Override
        public IRectangularArea dependenceAperture(Integer srcMatrixKey) {
            return srcMatrixKey == 0 ? this.dependenceAperture : this.emptyAperture;
        }
    }
}

