/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.matrices.filters3x3.DilationByCross3x3;
import net.algart.matrices.filters3x3.DilationBySquare3x3;
import net.algart.matrices.filters3x3.ErosionByCross3x3;
import net.algart.matrices.filters3x3.ErosionBySquare3x3;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.ContinuedMorphology;
import net.algart.matrices.morphology.Morphology;

public final class MatrixPairMorphology {
    private static final Pattern CROSS = Patterns.newIntegerPattern(IPoint.valueOf(0L, 0L), IPoint.valueOf(1L, 0L), IPoint.valueOf(0L, 1L), IPoint.valueOf(-1L, 0L), IPoint.valueOf(0L, -1L));
    private static final Morphology MULTITHREADING_MORPHOLOGY = BasicMorphology.getInstance(null);
    private static final Morphology SINGLETHREADING_MORPHOLOGY = BasicMorphology.getInstance(ArrayContext.DEFAULT_SINGLE_THREAD);
    private final boolean binary;
    private final DilationByCross3x3 dilationByCross3x3;
    private final ErosionByCross3x3 erosionByCross3x3;
    private final DilationBySquare3x3 dilationBySquare3x3;
    private final ErosionBySquare3x3 erosionBySquare3x3;
    private boolean multithreading = Arrays.SystemSettings.cpuCount() > 1;
    private Matrix.ContinuationMode continuationMode = null;
    private Matrix<? extends UpdatablePArray> originalResult;
    Matrix<? extends UpdatablePArray> result = null;
    Matrix<? extends UpdatablePArray> work;

    private MatrixPairMorphology(Matrix<? extends UpdatablePArray> work) {
        this.work = Objects.requireNonNull(work, "Null work matrix");
        Class<?> elementType = work.elementType();
        boolean bl = this.binary = elementType == Boolean.TYPE;
        if (this.binary) {
            this.dilationByCross3x3 = null;
            this.erosionByCross3x3 = null;
            this.dilationBySquare3x3 = null;
            this.erosionBySquare3x3 = null;
        } else {
            this.dilationByCross3x3 = DilationByCross3x3.newInstance(elementType, work.dimensions());
            this.erosionByCross3x3 = ErosionByCross3x3.newInstance(elementType, work.dimensions());
            this.dilationBySquare3x3 = DilationBySquare3x3.newInstance(elementType, work.dimensions());
            this.erosionBySquare3x3 = ErosionBySquare3x3.newInstance(elementType, work.dimensions());
        }
    }

    public static MatrixPairMorphology newInstance(Matrix<? extends UpdatablePArray> work) {
        return new MatrixPairMorphology(work);
    }

    public boolean isMultithreading() {
        return this.multithreading;
    }

    public MatrixPairMorphology setMultithreading(boolean multithreading) {
        this.multithreading = multithreading;
        if (!this.binary) {
            this.dilationByCross3x3.setMultithreading(multithreading);
            this.erosionByCross3x3.setMultithreading(multithreading);
            this.dilationBySquare3x3.setMultithreading(multithreading);
            this.erosionBySquare3x3.setMultithreading(multithreading);
        }
        return this;
    }

    public Matrix.ContinuationMode continuationMode() {
        return this.continuationMode;
    }

    public MatrixPairMorphology setContinuationMode(Matrix.ContinuationMode continuationMode) {
        this.continuationMode = continuationMode;
        return this;
    }

    public MatrixPairMorphology setMatrixToProcess(Matrix<? extends UpdatablePArray> matrix) {
        Matrices.checkDimensionEquality(matrix, this.work);
        if (matrix.elementType() != this.work.elementType()) {
            throw new IllegalArgumentException("Element type of new " + String.valueOf(matrix) + " does not match the element type of this object: " + String.valueOf(this.work.elementType()));
        }
        this.result = Objects.requireNonNull(matrix);
        this.originalResult = matrix;
        return this;
    }

    public MatrixPairMorphology copyFrom(Matrix<? extends PArray> source) {
        if (this.result == null) {
            throw new IllegalArgumentException("Matrix to process was not specified yet");
        }
        Matrices.copy(null, this.result, source);
        return this;
    }

    public MatrixPairMorphology openBySquare(long side) {
        this.erosionByRectangle(0L, 0L, side, side, false);
        this.dilationByRectangle(0L, 0L, side, side, true);
        return this;
    }

    public MatrixPairMorphology closeBySquare(long side) {
        this.dilationByRectangle(0L, 0L, side, side, true);
        this.erosionByRectangle(0L, 0L, side, side, false);
        return this;
    }

    public static void dilationBySquare(Matrix<? extends UpdatablePArray> matrix, Matrix<? extends UpdatablePArray> temporaryMatrix, long side) {
        new MatrixPairMorphology(temporaryMatrix).setMatrixToProcess(matrix).dilationBySquare(side);
    }

    public MatrixPairMorphology dilationBySquare(long side) {
        return this.dilationByRectangle(-side / 2L, -side / 2L, side, side);
    }

    public MatrixPairMorphology dilationByDoubleSquare(int halfSide) {
        return this.dilationByRectangle(-halfSide, -halfSide, 2L * (long)halfSide + 1L, 2L * (long)halfSide + 1L);
    }

    public MatrixPairMorphology dilationByRectangle(long minX, long minY, long sizeX, long sizeY) {
        return this.dilationByRectangle(minX, minY, sizeX, sizeY, true);
    }

    public MatrixPairMorphology dilationByRectangle(long minX, long minY, long sizeX, long sizeY, boolean provideResult) {
        if (sizeX < 0L || sizeY < 0L) {
            throw new IllegalArgumentException("Negative sizeX=" + sizeX + " or sizeY=" + sizeY);
        }
        if (minX == -1L && minY == -1L && sizeX == 3L && sizeY == 3L && this.simple3x3Optimization()) {
            this.dilationBySquare3x3.filter(this.work, this.result);
            this.swap();
        } else {
            this.shiftAndSwap(IPoint.valueOf(minX, minY));
            IPoint origin = IPoint.valueOf(0L, 0L);
            long i = 1L;
            while (2L * i <= sizeX) {
                this.dilationAndSwap(origin, IPoint.valueOf(i, 0L));
                i *= 2L;
            }
            if (i < sizeX) {
                this.dilationAndSwap(origin, IPoint.valueOf(sizeX - i, 0L));
            }
            i = 1L;
            while (2L * i <= sizeY) {
                this.dilationAndSwap(origin, IPoint.valueOf(0L, i));
                i *= 2L;
            }
            if (i < sizeY) {
                this.dilationAndSwap(origin, IPoint.valueOf(0L, sizeY - i));
            }
        }
        if (provideResult) {
            this.provideResult();
        }
        return this;
    }

    public MatrixPairMorphology dilationByOctagonWithDiameter(long diameter) {
        return this.dilationByOctagon(diameter / 2L, diameter % 2L != 0L);
    }

    public MatrixPairMorphology dilationByOctagon(long radius) {
        return this.dilationByOctagon(radius, false);
    }

    public MatrixPairMorphology dilationByOctagon(long radius, boolean addHalf) {
        if (radius < 0L) {
            throw new IllegalArgumentException("Negative radius=" + radius);
        }
        long crossCount = radius + 1L >>> 1;
        for (long i = 0L; i < crossCount; ++i) {
            if (this.simple3x3Optimization()) {
                this.dilationByCross3x3.filter(this.work, this.result);
                this.swap();
                continue;
            }
            this.dilationAndSwap(CROSS);
        }
        long squareCount = radius >>> 1;
        long squareSide = 2L * squareCount + 1L + (long)(addHalf ? 1 : 0);
        this.dilationByRectangle(-squareCount, -squareCount, squareSide, squareSide);
        return this;
    }

    public static void erosionBySquare(Matrix<? extends UpdatablePArray> matrix, Matrix<? extends UpdatablePArray> temporaryMatrix, long side) {
        new MatrixPairMorphology(temporaryMatrix).setMatrixToProcess(matrix).erosionBySquare(side);
    }

    public MatrixPairMorphology erosionBySquare(long side) {
        return this.erosionByRectangle(-side / 2L, -side / 2L, side, side);
    }

    public MatrixPairMorphology erosionByDoubleSquare(int halfSide) {
        return this.erosionByRectangle(-halfSide, -halfSide, 2L * (long)halfSide + 1L, 2L * (long)halfSide + 1L);
    }

    public MatrixPairMorphology erosionByRectangle(long minX, long minY, long sizeX, long sizeY) {
        return this.erosionByRectangle(minX, minY, sizeX, sizeY, true);
    }

    public MatrixPairMorphology erosionByRectangle(long minX, long minY, long sizeX, long sizeY, boolean provideResult) {
        if (sizeX < 0L || sizeY < 0L) {
            throw new IllegalArgumentException("Negative sizeX=" + sizeX + " or sizeY=" + sizeY);
        }
        if (minX == -1L && minY == -1L && sizeX == 3L && sizeY == 3L && this.simple3x3Optimization()) {
            this.erosionBySquare3x3.filter(this.work, this.result);
            this.swap();
        } else {
            this.shiftBackAndSwap(IPoint.valueOf(minX, minY));
            IPoint origin = IPoint.valueOf(0L, 0L);
            long i = 1L;
            while (2L * i <= sizeX) {
                this.erosionAndSwap(origin, IPoint.valueOf(i, 0L));
                i *= 2L;
            }
            if (i < sizeX) {
                this.erosionAndSwap(origin, IPoint.valueOf(sizeX - i, 0L));
            }
            i = 1L;
            while (2L * i <= sizeY) {
                this.erosionAndSwap(origin, IPoint.valueOf(0L, i));
                i *= 2L;
            }
            if (i < sizeY) {
                this.erosionAndSwap(origin, IPoint.valueOf(0L, sizeY - i));
            }
        }
        if (provideResult) {
            this.provideResult();
        }
        return this;
    }

    public MatrixPairMorphology erosionByOctagonWithDiameter(long diameter) {
        return this.erosionByOctagon(diameter / 2L, diameter % 2L != 0L);
    }

    public MatrixPairMorphology erosionByOctagon(long radius) {
        return this.erosionByOctagon(radius, false);
    }

    public MatrixPairMorphology erosionByOctagon(long radius, boolean addHalf) {
        if (radius < 0L) {
            throw new IllegalArgumentException("Negative radius=" + radius);
        }
        long crossCount = radius + 1L >>> 1;
        for (long i = 0L; i < crossCount; ++i) {
            if (this.simple3x3Optimization()) {
                this.erosionByCross3x3.filter(this.work, this.result);
                this.swap();
                continue;
            }
            this.erosionAndSwap(CROSS);
        }
        long squareCount = radius >>> 1;
        long squareSide = 2L * squareCount + 1L + (long)(addHalf ? 1 : 0);
        this.erosionByRectangle(-squareCount, -squareCount, squareSide, squareSide);
        return this;
    }

    public void shiftAndSwap(IPoint p) {
        if (!p.isOrigin()) {
            this.getSinglethreadingMorphology().dilation(this.work, this.result, Patterns.newIntegerPattern(p), true);
            this.swap();
        }
    }

    public void shiftBackAndSwap(IPoint p) {
        this.shiftAndSwap(p.symmetric());
    }

    public void dilationAndSwap(IPoint p1, IPoint p2) {
        this.dilationAndSwap(Arrays.asList(p1, p2));
    }

    public void dilationAndSwap(List<IPoint> points) {
        this.dilationAndSwap(Patterns.newIntegerPattern(points));
    }

    public void dilationAndSwap(Pattern pattern) {
        this.getMorphology().dilation(this.work, this.result, pattern, true);
        this.swap();
    }

    public void erosionAndSwap(IPoint p1, IPoint p2) {
        this.erosionAndSwap(Arrays.asList(p1, p2));
    }

    public void erosionAndSwap(List<IPoint> points) {
        this.erosionAndSwap(Patterns.newIntegerPattern(points));
    }

    public void erosionAndSwap(Pattern pattern) {
        this.getMorphology().erosion(this.work, this.result, pattern, true);
        this.swap();
    }

    public void provideResult() {
        if (this.result != this.originalResult) {
            this.originalResult.array().copy(this.result.array());
            this.swap();
        }
    }

    public Morphology getSinglethreadingMorphology() {
        Morphology morphology = SINGLETHREADING_MORPHOLOGY;
        if (this.continuationMode != null) {
            morphology = ContinuedMorphology.getInstance(morphology, this.continuationMode);
        }
        return morphology;
    }

    public Morphology getMorphology() {
        Morphology morphology;
        Morphology morphology2 = morphology = this.multithreading ? MULTITHREADING_MORPHOLOGY : SINGLETHREADING_MORPHOLOGY;
        if (this.continuationMode != null) {
            morphology = ContinuedMorphology.getInstance(morphology, this.continuationMode);
        }
        return morphology;
    }

    private void swap() {
        Matrix<? extends UpdatablePArray> temp = this.result;
        this.result = this.work;
        this.work = temp;
    }

    private boolean simple3x3Optimization() {
        return (this.continuationMode == null || this.continuationMode == Matrix.ContinuationMode.CYCLIC) && this.work.elementType() != Boolean.TYPE;
    }
}

