/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFloatingArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.BasicRankMorphology;
import net.algart.matrices.morphology.RankMorphology;

class FixedPercentileRankMorphology
extends BasicRankMorphology
implements RankMorphology {
    private final double dilationLevel;

    FixedPercentileRankMorphology(ArrayContext context, double dilationLevel, boolean interpolated, int[] bitLevels) {
        super(context, interpolated, bitLevels);
        if (dilationLevel < 0.0 || dilationLevel > 1.0) {
            throw new IllegalArgumentException("Illegal dilationLevel = " + dilationLevel + ": it must be in 0..1 range");
        }
        this.dilationLevel = dilationLevel;
    }

    @Override
    protected Matrix<? extends PArray> asDilationOrErosion(Matrix<? extends PArray> src, Pattern pattern, boolean isDilation) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        long patternSize = pattern.pointCount();
        assert (patternSize >= 1L);
        double percentileIndex = (isDilation ? this.dilationLevel : 1.0 - this.dilationLevel) * (double)(patternSize - 1L);
        return this.asPercentile(src, this.interpolated || src.array() instanceof PFloatingArray ? percentileIndex : (double)Math.round(percentileIndex), isDilation ? pattern : pattern.symmetric());
    }

    @Override
    protected Matrix<? extends UpdatablePArray> dilationOrErosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, boolean isDilation, boolean disableMemoryAllocation) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (dest == null) {
            dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        }
        long patternSize = pattern.pointCount();
        assert (patternSize >= 1L);
        double percentileIndex = (isDilation ? this.dilationLevel : 1.0 - this.dilationLevel) * (double)(patternSize - 1L);
        this.percentile(dest, src, this.interpolated || src.array() instanceof PFloatingArray ? percentileIndex : (double)Math.round(percentileIndex), isDilation ? pattern : pattern.symmetric());
        return dest;
    }
}

