/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.filters3x3;

import net.algart.matrices.filters3x3.PercentileBySquare3x3;

public abstract class DilationBySquare3x3
extends PercentileBySquare3x3 {
    DilationBySquare3x3(Class<?> elementType, long[] dimensions) {
        super(elementType, dimensions, 8);
    }

    public static DilationBySquare3x3 newInstance(Class<?> elementType, long dimX, long dimY) {
        return DilationBySquare3x3.newInstance(elementType, new long[]{dimX, dimY});
    }

    public static DilationBySquare3x3 newInstance(Class<?> elementType, long[] dimensions) {
        if (elementType == Character.TYPE) {
            return new ForChar(dimensions);
        }
        if (elementType == Boolean.TYPE) {
            return new ForBit(dimensions);
        }
        if (elementType == Byte.TYPE) {
            return new ForByte(dimensions);
        }
        if (elementType == Short.TYPE) {
            return new ForShort(dimensions);
        }
        if (elementType == Integer.TYPE) {
            return new ForInt(dimensions);
        }
        if (elementType == Long.TYPE) {
            return new ForLong(dimensions);
        }
        if (elementType == Float.TYPE) {
            return new ForFloat(dimensions);
        }
        if (elementType == Double.TYPE) {
            return new ForDouble(dimensions);
        }
        throw new UnsupportedOperationException("Non-primitive element type " + String.valueOf(elementType) + " is not supported");
    }

    private static class ForChar
    extends DilationBySquare3x3 {
        private ForChar(long[] dimensions) {
            super(Character.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            char[] result = (char[])resultJavaArray;
            char[] source = (char[])sourceJavaArray;
            char v0 = source[firstLineOffset + this.dimXm1];
            char v1 = source[firstLineOffset];
            char v2 = source[firstLineOffset + this.rem1ForDimX];
            char v3 = source[middleLineOffset + this.dimXm1];
            char v4 = source[middleLineOffset];
            char v5 = source[middleLineOffset + this.rem1ForDimX];
            char v6 = source[lastLineOffset + this.dimXm1];
            char v7 = source[lastLineOffset];
            char v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = (char)ForChar.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                int max1 = Math.max(v0, v1);
                int max2 = Math.max(v2, v3);
                int max3 = Math.max(v4, v5);
                int max4 = Math.max(v6, v7);
                max3 = Math.max(max3, v8);
                max1 = Math.max(max1, max2);
                max3 = Math.max(max3, max4);
                result[++resultLineOffset] = (char)Math.max(max1, max3);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = (char)ForChar.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static int max(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            int max1 = Math.max(w0, w1);
            int max2 = Math.max(w2, w3);
            int max3 = Math.max(w4, w5);
            int max4 = Math.max(w6, w7);
            max3 = Math.max(max3, w8);
            max1 = Math.max(max1, max2);
            max3 = Math.max(max3, max4);
            return Math.max(max1, max3);
        }
    }

    private static class ForBit
    extends DilationBySquare3x3 {
        private ForBit(long[] dimensions) {
            super(Boolean.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            boolean[] result = (boolean[])resultJavaArray;
            boolean[] source = (boolean[])sourceJavaArray;
            boolean v0 = source[firstLineOffset + this.dimXm1];
            boolean v1 = source[firstLineOffset];
            boolean v2 = source[firstLineOffset + this.rem1ForDimX];
            boolean v3 = source[middleLineOffset + this.dimXm1];
            boolean v4 = source[middleLineOffset];
            boolean v5 = source[middleLineOffset + this.rem1ForDimX];
            boolean v6 = source[lastLineOffset + this.dimXm1];
            boolean v7 = source[lastLineOffset];
            boolean v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = v0 || v1 || v2 || v3 || v4 || v5 || v6 || v7 || v8;
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = v0 || v1 || v2 || v3 || v4 || v5 || v6 || v7 || v8;
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = v0 || v1 || v2 || v3 || v4 || v5 || v6 || v7 || v8;
            }
        }
    }

    private static class ForByte
    extends DilationBySquare3x3 {
        private ForByte(long[] dimensions) {
            super(Byte.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            byte[] result = (byte[])resultJavaArray;
            byte[] source = (byte[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFF;
            int v1 = source[firstLineOffset] & 0xFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFF;
            int v4 = source[middleLineOffset] & 0xFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFF;
            int v7 = source[lastLineOffset] & 0xFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFF;
            result[resultLineOffset] = (byte)ForByte.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFF;
                int max1 = Math.max(v0, v1);
                int max2 = Math.max(v2, v3);
                int max3 = Math.max(v4, v5);
                int max4 = Math.max(v6, v7);
                max3 = Math.max(max3, v8);
                max1 = Math.max(max1, max2);
                max3 = Math.max(max3, max4);
                result[++resultLineOffset] = (byte)Math.max(max1, max3);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFF;
                result[++resultLineOffset] = (byte)ForByte.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static int max(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            int max1 = Math.max(w0, w1);
            int max2 = Math.max(w2, w3);
            int max3 = Math.max(w4, w5);
            int max4 = Math.max(w6, w7);
            max3 = Math.max(max3, w8);
            max1 = Math.max(max1, max2);
            max3 = Math.max(max3, max4);
            return Math.max(max1, max3);
        }
    }

    private static class ForShort
    extends DilationBySquare3x3 {
        private ForShort(long[] dimensions) {
            super(Short.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            short[] result = (short[])resultJavaArray;
            short[] source = (short[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFFFF;
            int v1 = source[firstLineOffset] & 0xFFFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFFFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFFFF;
            int v4 = source[middleLineOffset] & 0xFFFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFFFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFFFF;
            int v7 = source[lastLineOffset] & 0xFFFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFFFF;
            result[resultLineOffset] = (short)ForShort.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFFFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFFFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFFFF;
                int max1 = Math.max(v0, v1);
                int max2 = Math.max(v2, v3);
                int max3 = Math.max(v4, v5);
                int max4 = Math.max(v6, v7);
                max3 = Math.max(max3, v8);
                max1 = Math.max(max1, max2);
                max3 = Math.max(max3, max4);
                result[++resultLineOffset] = (short)Math.max(max1, max3);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFFFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFFFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFFFF;
                result[++resultLineOffset] = (short)ForShort.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static int max(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            int max1 = Math.max(w0, w1);
            int max2 = Math.max(w2, w3);
            int max3 = Math.max(w4, w5);
            int max4 = Math.max(w6, w7);
            max3 = Math.max(max3, w8);
            max1 = Math.max(max1, max2);
            max3 = Math.max(max3, max4);
            return Math.max(max1, max3);
        }
    }

    private static class ForInt
    extends DilationBySquare3x3 {
        private ForInt(long[] dimensions) {
            super(Integer.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            int[] result = (int[])resultJavaArray;
            int[] source = (int[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1];
            int v1 = source[firstLineOffset];
            int v2 = source[firstLineOffset + this.rem1ForDimX];
            int v3 = source[middleLineOffset + this.dimXm1];
            int v4 = source[middleLineOffset];
            int v5 = source[middleLineOffset + this.rem1ForDimX];
            int v6 = source[lastLineOffset + this.dimXm1];
            int v7 = source[lastLineOffset];
            int v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForInt.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                int max1 = Math.max(v0, v1);
                int max2 = Math.max(v2, v3);
                int max3 = Math.max(v4, v5);
                int max4 = Math.max(v6, v7);
                max3 = Math.max(max3, v8);
                max1 = Math.max(max1, max2);
                max3 = Math.max(max3, max4);
                result[++resultLineOffset] = Math.max(max1, max3);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForInt.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static int max(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            int max1 = Math.max(w0, w1);
            int max2 = Math.max(w2, w3);
            int max3 = Math.max(w4, w5);
            int max4 = Math.max(w6, w7);
            max3 = Math.max(max3, w8);
            max1 = Math.max(max1, max2);
            max3 = Math.max(max3, max4);
            return Math.max(max1, max3);
        }
    }

    private static class ForLong
    extends DilationBySquare3x3 {
        private ForLong(long[] dimensions) {
            super(Long.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            long[] result = (long[])resultJavaArray;
            long[] source = (long[])sourceJavaArray;
            long v0 = source[firstLineOffset + this.dimXm1];
            long v1 = source[firstLineOffset];
            long v2 = source[firstLineOffset + this.rem1ForDimX];
            long v3 = source[middleLineOffset + this.dimXm1];
            long v4 = source[middleLineOffset];
            long v5 = source[middleLineOffset + this.rem1ForDimX];
            long v6 = source[lastLineOffset + this.dimXm1];
            long v7 = source[lastLineOffset];
            long v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForLong.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                long max1 = Math.max(v0, v1);
                long max2 = Math.max(v2, v3);
                long max3 = Math.max(v4, v5);
                long max4 = Math.max(v6, v7);
                max3 = Math.max(max3, v8);
                max1 = Math.max(max1, max2);
                max3 = Math.max(max3, max4);
                result[++resultLineOffset] = Math.max(max1, max3);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForLong.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static long max(long w0, long w1, long w2, long w3, long w4, long w5, long w6, long w7, long w8) {
            long max1 = Math.max(w0, w1);
            long max2 = Math.max(w2, w3);
            long max3 = Math.max(w4, w5);
            long max4 = Math.max(w6, w7);
            max3 = Math.max(max3, w8);
            max1 = Math.max(max1, max2);
            max3 = Math.max(max3, max4);
            return Math.max(max1, max3);
        }
    }

    private static class ForFloat
    extends DilationBySquare3x3 {
        private ForFloat(long[] dimensions) {
            super(Float.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            float[] result = (float[])resultJavaArray;
            float[] source = (float[])sourceJavaArray;
            float v0 = source[firstLineOffset + this.dimXm1];
            float v1 = source[firstLineOffset];
            float v2 = source[firstLineOffset + this.rem1ForDimX];
            float v3 = source[middleLineOffset + this.dimXm1];
            float v4 = source[middleLineOffset];
            float v5 = source[middleLineOffset + this.rem1ForDimX];
            float v6 = source[lastLineOffset + this.dimXm1];
            float v7 = source[lastLineOffset];
            float v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForFloat.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                float max1 = Math.max(v0, v1);
                float max2 = Math.max(v2, v3);
                float max3 = Math.max(v4, v5);
                float max4 = Math.max(v6, v7);
                max3 = Math.max(max3, v8);
                max1 = Math.max(max1, max2);
                max3 = Math.max(max3, max4);
                result[++resultLineOffset] = Math.max(max1, max3);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForFloat.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static float max(float w0, float w1, float w2, float w3, float w4, float w5, float w6, float w7, float w8) {
            float max1 = Math.max(w0, w1);
            float max2 = Math.max(w2, w3);
            float max3 = Math.max(w4, w5);
            float max4 = Math.max(w6, w7);
            max3 = Math.max(max3, w8);
            max1 = Math.max(max1, max2);
            max3 = Math.max(max3, max4);
            return Math.max(max1, max3);
        }
    }

    private static class ForDouble
    extends DilationBySquare3x3 {
        private ForDouble(long[] dimensions) {
            super(Double.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            double[] result = (double[])resultJavaArray;
            double[] source = (double[])sourceJavaArray;
            double v0 = source[firstLineOffset + this.dimXm1];
            double v1 = source[firstLineOffset];
            double v2 = source[firstLineOffset + this.rem1ForDimX];
            double v3 = source[middleLineOffset + this.dimXm1];
            double v4 = source[middleLineOffset];
            double v5 = source[middleLineOffset + this.rem1ForDimX];
            double v6 = source[lastLineOffset + this.dimXm1];
            double v7 = source[lastLineOffset];
            double v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = ForDouble.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                double max1 = Math.max(v0, v1);
                double max2 = Math.max(v2, v3);
                double max3 = Math.max(v4, v5);
                double max4 = Math.max(v6, v7);
                max3 = Math.max(max3, v8);
                max1 = Math.max(max1, max2);
                max3 = Math.max(max3, max4);
                result[++resultLineOffset] = Math.max(max1, max3);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = ForDouble.max(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        private static double max(double w0, double w1, double w2, double w3, double w4, double w5, double w6, double w7, double w8) {
            double max1 = Math.max(w0, w1);
            double max2 = Math.max(w2, w3);
            double max3 = Math.max(w4, w5);
            double max4 = Math.max(w6, w7);
            max3 = Math.max(max3, w8);
            max1 = Math.max(max1, max2);
            max3 = Math.max(max3, max4);
            return Math.max(max1, max3);
        }
    }
}

