/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.Point;
import net.algart.math.functions.Func;
import net.algart.math.patterns.AbstractUniformGridPattern;
import net.algart.math.patterns.BasicDirectPointSetUniformGridPattern;
import net.algart.math.patterns.BasicRectangularPattern;
import net.algart.math.patterns.DirectPointSetPattern;
import net.algart.math.patterns.DirectPointSetUniformGridPattern;
import net.algart.math.patterns.MinkowskiSum;
import net.algart.math.patterns.OnePointPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.RectangularPattern;
import net.algart.math.patterns.SimplePattern;
import net.algart.math.patterns.TooManyPointsInPatternError;
import net.algart.math.patterns.TwoPointsPattern;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.math.patterns.Union;

public class Patterns {
    private static final BigDecimal BIG_DECIMAL_MAX_COORDINATE = new BigDecimal(0x10000000000000L);

    private Patterns() {
    }

    public static DirectPointSetPattern newPattern(Collection<Point> points) {
        Objects.requireNonNull(points, "Null points argument");
        points = new ArrayList<Point>(points);
        boolean allInteger = true;
        for (Point p : points) {
            Objects.requireNonNull(p, "Null point in the set");
            allInteger &= p.isInteger() & AbstractUniformGridPattern.isAllowedGridIndex(p.toIntegerPoint());
        }
        if (allInteger) {
            HashSet<IPoint> integerPoints = new HashSet<IPoint>();
            for (Point p : points) {
                integerPoints.add(p.toIntegerPoint());
            }
            return Patterns.newIntegerPattern(integerPoints);
        }
        if (points.size() <= 2) {
            Point[] pointsArray = points.toArray(new Point[0]);
            if (pointsArray.length == 1 || pointsArray[0].equals(pointsArray[1])) {
                return new OnePointPattern(pointsArray[0]);
            }
            return new TwoPointsPattern(pointsArray[0], pointsArray[1]);
        }
        return new SimplePattern(points);
    }

    public static DirectPointSetPattern newPattern(Point ... points) {
        Objects.requireNonNull(points, "Null points argument");
        return Patterns.newPattern(List.of(points));
    }

    public static DirectPointSetUniformGridPattern newUniformGridPattern(Point originOfGrid, double[] stepsOfGrid, Collection<IPoint> gridIndexes) {
        Objects.requireNonNull(originOfGrid, "Null originOfGrid");
        Objects.requireNonNull(gridIndexes, "Null gridIndexes argument");
        return new BasicDirectPointSetUniformGridPattern(originOfGrid, stepsOfGrid, new HashSet<IPoint>(gridIndexes));
    }

    public static DirectPointSetUniformGridPattern newIntegerPattern(Collection<IPoint> points) {
        Objects.requireNonNull(points, "Null points argument");
        HashSet<IPoint> gridIndexes = new HashSet<IPoint>(points);
        return new BasicDirectPointSetUniformGridPattern(gridIndexes.isEmpty() ? 1 : gridIndexes.iterator().next().coordCount(), gridIndexes);
    }

    public static DirectPointSetUniformGridPattern newIntegerPattern(IPoint ... points) {
        Objects.requireNonNull(points, "Null points argument");
        return Patterns.newIntegerPattern(List.of(points));
    }

    public static UniformGridPattern newSphereIntegerPattern(Point center, double r) {
        Objects.requireNonNull(center, "Null center argument");
        if (r < 0.0) {
            throw new IllegalArgumentException("Negative sphere radius");
        }
        double[] semiAxes = new double[center.coordCount()];
        Arrays.fill(semiAxes, r);
        return Patterns.newEllipsoidIntegerPattern(center, semiAxes);
    }

    public static UniformGridPattern newEllipsoidIntegerPattern(Point center, double ... semiAxes) {
        Objects.requireNonNull(center, "Null center argument");
        Objects.requireNonNull(semiAxes, "Null semiAxes argument");
        int n = center.coordCount();
        if (semiAxes.length != n) {
            throw new IllegalArgumentException("Number of semi-axes " + semiAxes.length + " is not equal to center.coordCount()=" + n);
        }
        final double[] semiAxesClone = (double[])semiAxes.clone();
        double[] semiAxesInv = new double[n];
        int[] semiAxesUpperBounds = new int[n];
        for (int k = 0; k < n; ++k) {
            double semiAxis = semiAxesClone[k];
            if (semiAxis < 0.0) {
                throw new IllegalArgumentException("Negative semiAxes[" + k + "] = " + semiAxis);
            }
            semiAxesUpperBounds[k] = (int)(semiAxis + 2.0);
            if (semiAxesUpperBounds[k] == Integer.MAX_VALUE) {
                throw new TooManyPointsInPatternError("Too large desired " + n + "D ellipsoid: semiAxes[" + k + "]=" + semiAxis);
            }
            semiAxesInv[k] = 1.0 / semiAxis;
        }
        if (n == 1) {
            return Patterns.newIntegerPattern(Patterns.newRectangularIntegerPattern(IRange.valueOf(StrictMath.round(StrictMath.ceil(center.coord(0) - semiAxesClone[0])), StrictMath.round(StrictMath.floor(center.coord(0) + semiAxesClone[0])))).roundedPoints());
        }
        final IRange[] oneSegmentCoordRanges = new IRange[n];
        HashSet<IPoint> points = new HashSet<IPoint>();
        for (int k = 0; k < oneSegmentCoordRanges.length; ++k) {
            Patterns.addPointsToEllipsoid(points, new double[]{center.coord(k)}, new int[]{semiAxesUpperBounds[k]}, new double[]{semiAxesInv[k]}, new long[]{0L}, 0, 0.0);
            oneSegmentCoordRanges[k] = new BasicDirectPointSetUniformGridPattern(1, points).gridIndexRange(0);
            points.clear();
        }
        Patterns.addPointsToEllipsoid(points, center.coordinates(), semiAxesUpperBounds, semiAxesInv, new long[n], 0, 0.0);
        return new BasicDirectPointSetUniformGridPattern(n, points){

            @Override
            public IRange gridIndexRange(int coordIndex) {
                return oneSegmentCoordRanges[coordIndex];
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (int k = 0; k < this.dimCount; ++k) {
                    if (k > 0) {
                        sb.append(",");
                    }
                    sb.append(semiAxesClone[k]);
                }
                return super.toString() + " (" + (this.dimCount == 1 ? "segment" : (this.dimCount == 2 ? "ellipse" : "ellipsoid")) + ", semiAxes = " + String.valueOf(sb) + ")";
            }
        };
    }

    public static Pattern newSurface(Pattern projection, final Func surface) {
        Objects.requireNonNull(projection, "Null projection argument");
        Objects.requireNonNull(surface, "Null surface argument");
        int dimCount = projection.dimCount();
        Set<Point> projectionPoints = projection.points();
        HashSet<Point> resultPoints = new HashSet<Point>();
        double[] coordinates = new double[dimCount];
        double[] resultPoint = new double[dimCount + 1];
        for (Point projectionPoint : projectionPoints) {
            projectionPoint.coordinates(coordinates);
            System.arraycopy(coordinates, 0, resultPoint, 0, dimCount);
            resultPoint[dimCount] = surface.get(coordinates);
            resultPoints.add(Point.valueOf(resultPoint));
        }
        return new SimplePattern(resultPoints){

            @Override
            public String toString() {
                return super.toString() + " (surface " + String.valueOf(surface) + ")";
            }
        };
    }

    public static UniformGridPattern newSpaceSegment(UniformGridPattern projection, final Func minSurface, final Func maxSurface, double lastCoordinateOfOrigin, double lastCoordinateStep) {
        Objects.requireNonNull(projection, "Null projection argument");
        Objects.requireNonNull(minSurface, "Null minSurface argument");
        Objects.requireNonNull(maxSurface, "Null maxSurface argument");
        if (lastCoordinateStep <= 0.0) {
            throw new IllegalArgumentException("Zero or negative last step of the grid is not allowed");
        }
        int dimCount = projection.dimCount();
        Set<IPoint> projectionIndexes = projection.gridIndexes();
        Point projectionOrigin = projection.originOfGrid();
        double[] projectionSteps = projection.stepsOfGrid();
        double[] origin = new double[dimCount + 1];
        projectionOrigin.coordinates(origin);
        origin[dimCount] = lastCoordinateOfOrigin;
        double[] steps = new double[dimCount + 1];
        System.arraycopy(projectionSteps, 0, steps, 0, dimCount);
        steps[dimCount] = lastCoordinateStep;
        HashSet<IPoint> resultIndexes = new HashSet<IPoint>();
        double[] coordinates = new double[dimCount];
        long[] resultIndex = new long[dimCount + 1];
        for (IPoint projectionIndex : projectionIndexes) {
            double max;
            projectionIndex.scaleAndShift(coordinates, projectionSteps, projectionOrigin);
            double min = minSurface.get(coordinates);
            if (min > (max = maxSurface.get(coordinates))) continue;
            long minIndex = (long)StrictMath.ceil(lastCoordinateStep == 1.0 ? min - lastCoordinateOfOrigin : (min - lastCoordinateOfOrigin) / lastCoordinateStep);
            long maxIndex = (long)StrictMath.floor(lastCoordinateStep == 1.0 ? max - lastCoordinateOfOrigin : (max - lastCoordinateOfOrigin) / lastCoordinateStep);
            projectionIndex.coordinates(resultIndex);
            long i = minIndex;
            while (i <= maxIndex) {
                resultIndex[dimCount] = i++;
                resultIndexes.add(IPoint.valueOf(resultIndex));
            }
        }
        if (resultIndexes.isEmpty()) {
            throw new IllegalArgumentException("Empty pattern: in all points of the projection pattern the minimal surface is above the maximal surface");
        }
        return new BasicDirectPointSetUniformGridPattern(Point.valueOf(origin), steps, resultIndexes){

            @Override
            public String toString() {
                return super.toString() + " (segment between surfaces " + String.valueOf(minSurface) + " and " + String.valueOf(maxSurface) + ")";
            }
        };
    }

    public static RectangularPattern newRectangularUniformGridPattern(Point originOfGrid, double[] stepsOfGrid, IRange ... gridIndexRanges) {
        Objects.requireNonNull(originOfGrid, "Null originOfGrid");
        Objects.requireNonNull(gridIndexRanges, "Null gridIndexRanges argument");
        if (gridIndexRanges.length == 0) {
            throw new IllegalArgumentException("Empty gridIndexRanges array");
        }
        return new BasicRectangularPattern(originOfGrid, stepsOfGrid, gridIndexRanges);
    }

    public static RectangularPattern newRectangularIntegerPattern(IRange ... ranges) {
        Objects.requireNonNull(ranges, "Null ranges argument");
        if (ranges.length == 0) {
            throw new IllegalArgumentException("Empty ranges array");
        }
        return new BasicRectangularPattern(ranges);
    }

    public static UniformGridPattern newRectangularIntegerPattern(IPoint min, IPoint max) {
        int n = min.coordCount();
        if (n != max.coordCount()) {
            throw new IllegalArgumentException("Coordinates count mismatch: \"min\" is " + n + "-dimensional, \"max\" is " + max.coordCount() + "-dimensional");
        }
        IRange[] ranges = new IRange[n];
        for (int k = 0; k < n; ++k) {
            ranges[k] = IRange.valueOf(min.coord(k), max.coord(k));
        }
        return new BasicRectangularPattern(ranges);
    }

    public static Pattern newMinkowskiSum(Pattern ... patterns) {
        return Patterns.newMinkowskiSum(List.of(patterns));
    }

    public static Pattern newMinkowskiSum(Collection<Pattern> patterns) {
        Objects.requireNonNull(patterns, "Null patterns argument");
        if (patterns.isEmpty()) {
            throw new IllegalArgumentException("Empty patterns array");
        }
        Pattern[] patternsArray = patterns.toArray(new Pattern[0]);
        boolean allCompatibleRectangular = true;
        Pattern first = patternsArray[0];
        for (int k = 0; k < patternsArray.length; ++k) {
            Objects.requireNonNull(patternsArray[k], "Null pattern #" + k + " in the list");
            if (patternsArray[k].dimCount() != first.dimCount()) {
                throw new IllegalArgumentException("Patterns dimensions mismatch: the first pattern has " + first.dimCount() + " dimensions, but pattern #" + k + " has " + patternsArray[k].dimCount());
            }
            if (!allCompatibleRectangular || patternsArray[k] instanceof RectangularPattern && ((UniformGridPattern)patternsArray[k]).stepsOfGridEqual((UniformGridPattern)first)) continue;
            allCompatibleRectangular = false;
        }
        if (allCompatibleRectangular) {
            UniformGridPattern ugFirst = (UniformGridPattern)first;
            Pattern result = new BasicRectangularPattern(ugFirst.originOfGrid(), ugFirst.stepsOfGrid(), ugFirst.gridIndexArea().ranges());
            for (int k = 1; k < patternsArray.length; ++k) {
                if (!((result = result.minkowskiAdd(patternsArray[k])) instanceof RectangularPattern)) {
                    throw new AssertionError((Object)"Invalid SimpleRectangularGridPattern.minkowskiAdd implementation");
                }
            }
            if (result.pointCount() == 1L) {
                return new OnePointPattern(result.coordMin());
            }
            return result;
        }
        return new MinkowskiSum(patternsArray);
    }

    public static Pattern newMinkowskiMultiplePattern(Pattern pattern, int n) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (n <= 0) {
            throw new IllegalArgumentException("Negative or zero n argument");
        }
        Object[] patterns = new Pattern[n];
        Arrays.fill(patterns, pattern);
        return new MinkowskiSum((Pattern[])patterns);
    }

    public static Pattern newUnion(Pattern ... patterns) {
        Objects.requireNonNull(patterns, "Null patterns argument");
        return new Union((Pattern[])patterns.clone());
    }

    public static Pattern newUnion(Collection<Pattern> patterns) {
        Objects.requireNonNull(patterns, "Null patterns argument");
        return new Union(patterns.toArray(new Pattern[0]));
    }

    public static boolean isAllowedDifference(double x1, double x2) {
        double a;
        if (Double.isNaN(x1) || Double.isNaN(x2) || Double.isInfinite(x1) || Double.isInfinite(x2)) {
            return false;
        }
        double b = x1 <= x2 ? x2 : x1;
        double diff = b - (a = x1 <= x2 ? x1 : x2);
        if (diff < 4.503599627370495E15) {
            return true;
        }
        if (diff > 4.503599627370497E15) {
            return false;
        }
        BigDecimal bigB = new BigDecimal(b);
        BigDecimal bigA = new BigDecimal(a);
        BigDecimal bigDiff = bigB.subtract(bigA);
        return bigDiff.compareTo(BIG_DECIMAL_MAX_COORDINATE) <= 0;
    }

    private static void addPointsToSphere(Set<IPoint> points, double[] center, long[] coordinates, int lastCoordinatesCount, int ir, double rSqr, double rSum) {
        int dimCount = coordinates.length;
        int currentCoordIndex = dimCount - 1 - lastCoordinatesCount;
        int min = (int)center[currentCoordIndex] - ir;
        int max = (int)center[currentCoordIndex] + ir;
        if (currentCoordIndex == 0) {
            for (int i = min; i <= max; ++i) {
                double diff = (double)i - center[currentCoordIndex];
                if (!(rSum + diff * diff <= rSqr)) continue;
                coordinates[0] = i;
                points.add(IPoint.valueOf(coordinates));
            }
        } else {
            for (int i = min; i <= max; ++i) {
                coordinates[currentCoordIndex] = i;
                double diff = (double)i - center[currentCoordIndex];
                Patterns.addPointsToSphere(points, center, coordinates, lastCoordinatesCount + 1, ir, rSqr, rSum + diff * diff);
            }
        }
    }

    private static void addPointsToEllipsoid(Set<IPoint> points, double[] center, int[] semiAxesUpperBounds, double[] semiAxesInv, long[] coordinates, int lastCoordinatesCount, double sum) {
        int dimCount = coordinates.length;
        int currentCoordIndex = dimCount - 1 - lastCoordinatesCount;
        double rInv = semiAxesInv[currentCoordIndex];
        int min = (int)center[currentCoordIndex] - semiAxesUpperBounds[currentCoordIndex];
        int max = (int)center[currentCoordIndex] + semiAxesUpperBounds[currentCoordIndex];
        if (currentCoordIndex == 0) {
            for (int i = min; i <= max; ++i) {
                double diff = (double)i - center[currentCoordIndex];
                double ratio = diff == 0.0 ? 0.0 : diff * rInv;
                double newSum = sum + ratio * ratio;
                if (!(newSum <= 1.000000001)) continue;
                coordinates[0] = i;
                points.add(IPoint.valueOf(coordinates));
            }
        } else {
            for (int i = min; i <= max; ++i) {
                double diff = (double)i - center[currentCoordIndex];
                double ratio = diff == 0.0 ? 0.0 : diff * rInv;
                double newSum = sum + ratio * ratio;
                if (!(newSum <= 1.000000001)) continue;
                coordinates[currentCoordIndex] = i;
                Patterns.addPointsToEllipsoid(points, center, semiAxesUpperBounds, semiAxesInv, coordinates, lastCoordinatesCount + 1, newSum);
            }
        }
    }
}

