/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.patterns.AbstractPattern;
import net.algart.math.patterns.DirectPointSetPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.SimplePattern;

final class OnePointPattern
extends AbstractPattern
implements DirectPointSetPattern {
    private final Point p;

    OnePointPattern(Point p) {
        super(p.coordCount());
        this.p = p;
        this.fillCoordRangesWithCheck(Collections.singletonList(this.p));
    }

    @Override
    public long pointCount() {
        return 1L;
    }

    @Override
    public Set<Point> points() {
        return Collections.singleton(this.p);
    }

    @Override
    public Range coordRange(int coordIndex) {
        return this.coordRanges[coordIndex];
    }

    @Override
    public Point coordMin() {
        return this.p;
    }

    @Override
    public Point coordMax() {
        return this.p;
    }

    @Override
    public boolean isSurelySinglePoint() {
        return true;
    }

    @Override
    public boolean isSurelyOriginPoint() {
        return this.p.isOrigin();
    }

    @Override
    public boolean isSurelyInteger() {
        return this.p.isInteger();
    }

    @Override
    public DirectPointSetPattern shift(Point shift) {
        Objects.requireNonNull(shift, "Null shift argument");
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        if (shift.isOrigin()) {
            return this;
        }
        return new OnePointPattern(this.p.add(shift));
    }

    @Override
    public DirectPointSetPattern symmetric() {
        return (DirectPointSetPattern)super.symmetric();
    }

    @Override
    public DirectPointSetPattern multiply(double multiplier) {
        return (DirectPointSetPattern)super.multiply(multiplier);
    }

    @Override
    public DirectPointSetPattern scale(double ... multipliers) {
        Objects.requireNonNull(multipliers, "Null multipliers argument");
        if (multipliers.length != this.dimCount) {
            throw new IllegalArgumentException("Illegal number of multipliers: " + multipliers.length + " instead of " + this.dimCount);
        }
        boolean allUnit = true;
        for (double m : multipliers) {
            allUnit &= m == 1.0;
        }
        if (allUnit) {
            return this;
        }
        return new OnePointPattern(this.p.scale(multipliers));
    }

    @Override
    public DirectPointSetPattern projectionAlongAxis(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        assert (this.dimCount > 0);
        if (this.dimCount == 1) {
            throw new IllegalStateException("Cannot perform projection for 1-dimensional pattern");
        }
        return new OnePointPattern(this.p.projectionAlongAxis(coordIndex));
    }

    @Override
    public DirectPointSetPattern minBound(int coordIndex) {
        return (DirectPointSetPattern)super.minBound(coordIndex);
    }

    @Override
    public DirectPointSetPattern maxBound(int coordIndex) {
        return (DirectPointSetPattern)super.maxBound(coordIndex);
    }

    @Override
    public Pattern minkowskiAdd(Pattern added) {
        Objects.requireNonNull(added, "Null added argument");
        if (added.dimCount() != this.dimCount) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + added.dimCount() + " instead of " + this.dimCount);
        }
        return added.shift(this.p);
    }

    public String toString() {
        return this.dimCount + "D 1-point pattern (" + String.valueOf(this.p) + ")";
    }

    public int hashCode() {
        return this.points().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Pattern && SimplePattern.simplePatternsEqual(this, (Pattern)obj);
    }
}

