/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import java.util.Locale;
import java.util.Objects;
import net.algart.math.Range;
import net.algart.math.functions.Func;

public abstract class LinearFunc
implements Func {
    final double b;
    final double[] a;
    final int n;
    final double a0;
    private final boolean nonweighted;

    private LinearFunc(double b, double[] a) {
        Objects.requireNonNull(a, "Null a argument");
        this.b = b == -0.0 ? 0.0 : b;
        this.n = a.length;
        this.a0 = a.length == 0 ? Double.NaN : a[0];
        boolean eq = true;
        for (int k = 1; k < a.length; ++k) {
            if (a[k] == a[0]) continue;
            eq = false;
            break;
        }
        this.nonweighted = eq;
        this.a = (double[])(eq && a.length > 3 ? null : (double[])a.clone());
    }

    private LinearFunc(double b, double a, int n) {
        assert (n >= 3);
        this.b = b == -0.0 ? 0.0 : b;
        this.n = n;
        this.a0 = a;
        this.nonweighted = true;
        this.a = null;
    }

    public static LinearFunc getInstance(double b, double ... a) {
        if (a.length == 0) {
            return new LinearFunc(b, a){

                @Override
                public double get(double ... x) {
                    return this.b;
                }

                @Override
                public double get() {
                    return this.b;
                }

                @Override
                public double get(double x0) {
                    return this.b;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.b;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.b;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.b;
                }
            };
        }
        if (a.length == 1) {
            if (a[0] == 1.0) {
                return new LinearFunc(b, a){

                    @Override
                    public double get(double ... x) {
                        return this.b + x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return this.b + x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return this.b + x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return this.b + x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return this.b + x0;
                    }
                };
            }
            return new LinearFunc(b, a){

                @Override
                public double get(double ... x) {
                    return this.b + this.a[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.b + this.a[0] * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.b + this.a[0] * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.b + this.a[0] * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.b + this.a[0] * x0;
                }
            };
        }
        if (a.length == 2) {
            return new LinearFunc(b, a){

                @Override
                public double get(double ... x) {
                    return this.b + this.a[0] * x[0] + this.a[1] * x[1];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 2 arguments required");
                }

                @Override
                public double get(double x0) {
                    throw new IndexOutOfBoundsException("At least 2 arguments required");
                }

                @Override
                public double get(double x0, double x1) {
                    return this.b + this.a[0] * x0 + this.a[1] * x1;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.b + this.a[0] * x0 + this.a[1] * x1;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.b + this.a[0] * x0 + this.a[1] * x1;
                }
            };
        }
        assert (a.length >= 3);
        boolean eq = true;
        for (int k = 1; k < a.length; ++k) {
            if (a[k] == a[0]) continue;
            eq = false;
            break;
        }
        if (eq) {
            return LinearFunc.getNonweightedInstance(b, a[0], a.length);
        }
        return new LinearFunc(b, a){

            @Override
            public double get(double ... x) {
                double result = this.b;
                for (int k = 0; k < this.n; ++k) {
                    result += this.a[k] * x[k];
                }
                return result;
            }

            @Override
            public double get() {
                throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
            }

            @Override
            public double get(double x0) {
                throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
            }

            @Override
            public double get(double x0, double x1) {
                throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
            }

            @Override
            public double get(double x0, double x1, double x2) {
                if (this.n > 3) {
                    throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
                }
                return this.b + this.a[0] * x0 + this.a[1] * x1 + this.a[2] * x2;
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                if (this.n > 4) {
                    throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
                }
                return this.b + this.a[0] * x0 + this.a[1] * x1 + this.a[2] * x2 + this.a[3] * x3;
            }
        };
    }

    public static LinearFunc getNonweightedInstance(double b, double a, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative n argument");
        }
        return switch (n) {
            case 0 -> LinearFunc.getInstance(b, new double[0]);
            case 1 -> LinearFunc.getInstance(b, a);
            case 2 -> LinearFunc.getInstance(b, a, a);
            default -> new LinearFunc(b, a, n){

                @Override
                public double get(double ... x) {
                    double sum = 0.0;
                    for (int k = 0; k < this.n; ++k) {
                        sum += x[k];
                    }
                    return this.b + this.a0 * sum;
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
                }

                @Override
                public double get(double x0) {
                    throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
                }

                @Override
                public double get(double x0, double x1) {
                    throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    if (this.n > 3) {
                        throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
                    }
                    return this.b + this.a0 * (x0 + x1 + x2);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    if (this.n > 4) {
                        throw new IndexOutOfBoundsException("At least " + this.n + " arguments required");
                    }
                    return this.b + this.a0 * (x0 + x1 + x2 + x3);
                }
            };
        };
    }

    public static LinearFunc getAveragingInstance(int n) {
        return LinearFunc.getNonweightedInstance(0.0, 1.0 / (double)n, n);
    }

    public static LinearFunc getInstance(Range destRange, Range srcRange) {
        double mult = destRange.size() / srcRange.size();
        double b = destRange.min() - srcRange.min() * mult;
        return LinearFunc.getInstance(b, mult);
    }

    public static Updatable getUpdatableInstance(double b, double a) {
        return new Updatable(b, a);
    }

    @Override
    public abstract double get(double ... var1);

    @Override
    public abstract double get();

    @Override
    public abstract double get(double var1);

    @Override
    public abstract double get(double var1, double var3);

    @Override
    public abstract double get(double var1, double var3, double var5);

    @Override
    public abstract double get(double var1, double var3, double var5, double var7);

    public int n() {
        return this.n;
    }

    public double b() {
        return this.b;
    }

    public double a(int i) {
        if (this.a != null) {
            return this.a[i];
        }
        if (i < 0 || i >= this.n) {
            throw new IndexOutOfBoundsException("Index (" + i + ") is out of bounds 0.." + (this.n - 1));
        }
        return this.a0;
    }

    public double[] a() {
        double[] result = new double[this.n];
        if (this.a != null) {
            System.arraycopy(this.a, 0, result, 0, this.n);
        } else {
            for (int k = 0; k < this.n; ++k) {
                result[k] = this.a0;
            }
        }
        return result;
    }

    public boolean isNonweighted() {
        return this.nonweighted;
    }

    public String toString() {
        int k;
        StringBuilder sb = new StringBuilder("linear function f(");
        for (k = 0; k < this.n; ++k) {
            if (k > 0) {
                sb.append(",");
            }
            if (k >= 2 && k < this.n - 2) {
                sb.append("...");
                k = this.n - 2;
                continue;
            }
            sb.append("x").append(k);
        }
        sb.append(")=");
        if (this.n > 1 && this.nonweighted) {
            sb.append(LinearFunc.goodFormat(this.a0)).append("*(x0+x1+...)");
        } else {
            for (k = 0; k < this.a.length; ++k) {
                if (k > 0 && this.a[k] >= 0.0) {
                    sb.append("+");
                }
                sb.append(LinearFunc.goodFormat(this.a[k])).append("*x").append(k);
            }
        }
        if (this.b != 0.0) {
            if (this.b >= 0.0) {
                sb.append("+");
            }
            sb.append(LinearFunc.goodFormat(this.b));
        }
        return sb.toString();
    }

    static String goodFormat(double v) {
        return String.format(Locale.US, Math.abs(v) >= 0.1 && Math.abs(v) <= 1000000.0 ? "%.3f" : "%.3g", v);
    }

    public static class Updatable
    extends LinearFunc
    implements Func.Updatable {
        private final double aInv;

        private Updatable(double b, double a) {
            super(b, new double[]{a});
            this.aInv = 1.0 / a;
        }

        @Override
        public double get(double ... x) {
            return this.b + this.a[0] * x[0];
        }

        @Override
        public double get() {
            throw new IndexOutOfBoundsException("At least 1 argument required");
        }

        @Override
        public double get(double x0) {
            return this.b + this.a[0] * x0;
        }

        @Override
        public double get(double x0, double x1) {
            return this.b + this.a[0] * x0;
        }

        @Override
        public double get(double x0, double x1, double x2) {
            return this.b + this.a[0] * x0;
        }

        @Override
        public double get(double x0, double x1, double x2, double x3) {
            return this.b + this.a[0] * x0;
        }

        @Override
        public void set(double[] x, double newResult) {
            x[0] = (newResult - this.b) * this.aInv;
        }
    }
}

