/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

public class InverseNumberFunc
implements Func {
    final double c;

    private InverseNumberFunc(double c) {
        this.c = c;
    }

    public static InverseNumberFunc getInstance(double c) {
        return new InverseNumberFunc(c);
    }

    public static Updatable getUpdatableInstance(double c) {
        return new Updatable(c);
    }

    @Override
    public double get(double ... x) {
        return this.c / x[0];
    }

    @Override
    public double get() {
        throw new IndexOutOfBoundsException("At least 1 argument required");
    }

    @Override
    public double get(double x0) {
        return this.c / x0;
    }

    @Override
    public double get(double x0, double x1) {
        return this.c / x0;
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return this.c / x0;
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return this.c / x0;
    }

    public String toString() {
        return "inverse function f(x)=" + this.c + "/x";
    }

    public static class Updatable
    extends InverseNumberFunc
    implements Func.Updatable {
        private Updatable(double c) {
            super(c);
        }

        @Override
        public void set(double[] x, double newResult) {
            x[0] = this.c / newResult;
        }
    }
}

