/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import java.util.Objects;
import net.algart.math.functions.ApertureFilteredFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.Operator;

public final class ApertureFilterOperator
implements Operator {
    final long[] apertureDim;
    final double[] apertureFrom;
    final double[] apertureSteps;
    final int totalCount;
    final Func apertureFunc;
    final boolean isNonweightedSum;
    final double a;
    final double b;

    private ApertureFilterOperator(Func apertureFunc, long[] apertureDim, double[] apertureFrom, double[] apertureSteps) {
        int k;
        Objects.requireNonNull(apertureDim, "Null apertureDim argument");
        if (apertureDim.length == 0) {
            throw new IllegalArgumentException("Empty apertureDim array");
        }
        long product = 1L;
        for (k = 0; k < apertureDim.length; ++k) {
            long d = apertureDim[k];
            if (d <= 0L) {
                throw new IllegalArgumentException("Negative or zero aperture dimension #" + k + ": " + d);
            }
            if (d <= Integer.MAX_VALUE && (product *= d) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Too large number of points in the aperture: apertureDim[0] * apertureDim[1] * ... > Integer.MAX_VALUE");
        }
        this.totalCount = (int)product;
        if (apertureFrom != null) {
            if (apertureFrom.length != apertureDim.length) {
                throw new IllegalArgumentException("apertureFrom.length (" + apertureFrom.length + ") does not match apertureDim.length (" + apertureDim.length + ")");
            }
        } else {
            apertureFrom = new double[apertureDim.length];
        }
        if (apertureSteps != null) {
            if (apertureSteps.length != apertureDim.length) {
                throw new IllegalArgumentException("apertureSteps.length (" + apertureSteps.length + ") does not match apertureDim.length (" + apertureDim.length + ")");
            }
        } else {
            apertureSteps = new double[apertureDim.length];
            for (k = 0; k < apertureDim.length; ++k) {
                apertureSteps[k] = 1.0 / (double)apertureDim[k];
            }
        }
        if (apertureFunc == null) {
            this.a = 1.0 / (double)this.totalCount;
            this.b = 0.0;
            this.isNonweightedSum = true;
        } else if (apertureFunc instanceof LinearFunc) {
            LinearFunc lf = (LinearFunc)apertureFunc;
            this.b = lf.b();
            if (lf.n() > this.totalCount) {
                throw new IllegalArgumentException("Insufficient number of aperture points for the aperture function");
            }
            if (lf.n() == this.totalCount) {
                this.a = lf.a(0);
                this.isNonweightedSum = lf.isNonweighted();
            } else {
                this.a = Double.NaN;
                this.isNonweightedSum = false;
            }
        } else {
            this.b = Double.NaN;
            this.a = Double.NaN;
            this.isNonweightedSum = false;
        }
        this.apertureDim = (long[])apertureDim.clone();
        this.apertureFrom = (double[])apertureFrom.clone();
        this.apertureSteps = (double[])apertureSteps.clone();
        this.apertureFunc = apertureFunc;
    }

    public static ApertureFilterOperator getInstance(Func apertureFunc, long[] apertureDim, double[] apertureFrom, double[] apertureSteps) {
        Objects.requireNonNull(apertureFrom, "Null apertureFrom argument");
        Objects.requireNonNull(apertureSteps, "Null apertureSteps argument");
        Objects.requireNonNull(apertureFunc, "Null apertureFunc argument");
        return new ApertureFilterOperator(apertureFunc, apertureDim, apertureFrom, apertureSteps);
    }

    public static ApertureFilterOperator getInstance(Func apertureFunc, long ... apertureDim) {
        Objects.requireNonNull(apertureFunc, "Null apertureFunc argument");
        return new ApertureFilterOperator(apertureFunc, apertureDim, null, null);
    }

    public static ApertureFilterOperator getAveragingInstance(long[] apertureDim, double[] apertureFrom, double[] apertureSteps) {
        Objects.requireNonNull(apertureFrom, "Null apertureFrom argument");
        Objects.requireNonNull(apertureSteps, "Null apertureSteps argument");
        return new ApertureFilterOperator(null, apertureDim, apertureFrom, apertureSteps);
    }

    public static ApertureFilterOperator getAveragingInstance(long ... apertureDim) {
        return new ApertureFilterOperator(null, apertureDim, null, null);
    }

    public static boolean tooLargeAperture(long ... apertureDim) {
        long totalCount = 1L;
        for (int k = 0; k < apertureDim.length; ++k) {
            long d = apertureDim[k];
            if (d <= 0L) {
                throw new IllegalArgumentException("Negative or zero aperture dimension #" + k + ": " + d);
            }
            assert (totalCount <= Integer.MAX_VALUE);
            if (d <= Integer.MAX_VALUE && (totalCount *= d) <= Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    @Override
    public Func apply(Func f) {
        return ApertureFilteredFunc.getInstance(f, this);
    }

    public int n() {
        return this.apertureDim.length;
    }

    public long[] apertureDim() {
        return (long[])this.apertureDim.clone();
    }

    public double[] apertureFrom() {
        return (double[])this.apertureFrom.clone();
    }

    public double[] apertureSteps() {
        return (double[])this.apertureSteps.clone();
    }

    public double apertureDim(int coordIndex) {
        return this.apertureDim[coordIndex];
    }

    public double apertureFrom(int coordIndex) {
        return this.apertureFrom[coordIndex];
    }

    public double apertureTo(int coordIndex) {
        return this.apertureFrom[coordIndex] + (double)(this.apertureDim[coordIndex] - 1L) * this.apertureSteps[coordIndex];
    }

    public double apertureStep(int coordIndex) {
        return this.apertureSteps[coordIndex];
    }

    public double maxApertureSize() {
        double result = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < this.apertureDim.length; ++k) {
            result = Math.max(result, (double)(this.apertureDim[k] - 1L) * this.apertureSteps[k]);
        }
        return result;
    }

    public Func apertureFunc() {
        if (this.apertureFunc != null) {
            return this.apertureFunc;
        }
        return LinearFunc.getNonweightedInstance(0.0, this.a, this.totalCount);
    }

    public boolean isAveraging() {
        return this.isNonweightedSum && this.a == 1.0 / (double)this.totalCount && this.b == 0.0;
    }

    public String toString() {
        return "aperture filter " + this.apertureDim.length + "-dimensional operator" + (String)(this.isAveraging() ? " (averaging)" : " (based on " + String.valueOf(this.apertureFunc) + ")");
    }
}

