/*
 * Decompiled with CFR 0.152.
 */
package net.algart.io.awt;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.ByteArray;
import net.algart.arrays.ColorChannelOrder;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.math.functions.LinearFunc;

public abstract class MatrixToImage {
    private boolean unsignedInt32 = false;
    private boolean bytesRequired = false;

    public static BufferedImage ofChannels(List<? extends Matrix<? extends PArray>> channels) {
        return MatrixToImage.ofChannels(channels, true);
    }

    public static BufferedImage ofChannels(List<? extends Matrix<? extends PArray>> channels, boolean convertAllElementTypesToByte) {
        Objects.requireNonNull(channels, "Null channels");
        return MatrixToImage.ofInterleaved(Matrices.interleave(channels), convertAllElementTypesToByte);
    }

    public static BufferedImage ofInterleaved(Matrix<? extends PArray> interleavedMatrix) {
        return MatrixToImage.ofInterleaved(interleavedMatrix, true);
    }

    public static BufferedImage ofInterleaved(Matrix<? extends PArray> interleavedMatrix, boolean convertAllElementTypesToByte) {
        return new InterleavedRGBToInterleaved().setBytesRequired(convertAllElementTypesToByte).toBufferedImage(interleavedMatrix);
    }

    public static BufferedImage ofInterleavedBGR(Matrix<? extends PArray> interleavedMatrix) {
        return MatrixToImage.ofInterleavedBGR(interleavedMatrix, true);
    }

    public static BufferedImage ofInterleavedBGR(Matrix<? extends PArray> interleavedMatrix, boolean convertAllElementTypesToByte) {
        return new InterleavedBGRToInterleaved().setBytesRequired(convertAllElementTypesToByte).toBufferedImage(interleavedMatrix);
    }

    public boolean isUnsignedInt32() {
        return this.unsignedInt32;
    }

    public MatrixToImage setUnsignedInt32(boolean unsignedInt32) {
        this.unsignedInt32 = unsignedInt32;
        return this;
    }

    public boolean isBytesRequired() {
        return this.bytesRequired;
    }

    public MatrixToImage setBytesRequired(boolean bytesRequired) {
        this.bytesRequired = bytesRequired;
        return this;
    }

    public final BufferedImage toBufferedImage(Matrix<? extends PArray> interleavedMatrix) {
        return this.toBufferedImage(interleavedMatrix, null);
    }

    public final BufferedImage toBufferedImage(Matrix<? extends PArray> interleavedMatrix, DataBuffer dataBuffer) {
        WritableRaster wr;
        this.checkMatrix(interleavedMatrix);
        if (dataBuffer == null) {
            dataBuffer = this.toDataBuffer(interleavedMatrix);
        }
        int dimX = this.dimX(interleavedMatrix);
        int dimY = this.dimY(interleavedMatrix);
        int bandCount = this.numberOfChannels(interleavedMatrix);
        int resultNumberOfChannels = this.resultNumberOfChannels(bandCount);
        byte[][] palette = this.palette();
        if (palette != null) {
            if (bandCount != 1) {
                throw new AssertionError((Object)(bandCount + " > 1 bands must not be allowed when palette() method returns non-null value"));
            }
            if (palette.length < 3) {
                throw new AssertionError((Object)"palette() method must return palette with 3 or 4 bands");
            }
            IndexColorModel cm = palette.length == 3 ? new IndexColorModel(8, 256, palette[0], palette[1], palette[2]) : new IndexColorModel(8, 256, palette[0], palette[1], palette[2], palette[3]);
            WritableRaster wr2 = Raster.createInterleavedRaster(dataBuffer, dimX, dimY, dimX, 1, new int[]{0}, null);
            return new BufferedImage(cm, wr2, false, null);
        }
        int[] bandMasks = this.packedSamplesRGBAMasks(bandCount);
        if (bandMasks != null) {
            if (resultNumberOfChannels != bandMasks.length) {
                throw new AssertionError((Object)("packedSamplesRGBAMasks() array must contain " + resultNumberOfChannels + " elements"));
            }
            WritableRaster wr3 = Raster.createPackedRaster(dataBuffer, dimX, dimY, dimX, bandMasks, null);
            DirectColorModel cm = bandMasks.length > 3 ? new DirectColorModel(32, bandMasks[0], bandMasks[1], bandMasks[2], bandMasks[3]) : new DirectColorModel(24, bandMasks[0], bandMasks[1], bandMasks[2], 0);
            return new BufferedImage(cm, wr3, false, null);
        }
        int[] sampleOffsets = this.interleavedSamplesRGBAOffsets(resultNumberOfChannels);
        if (sampleOffsets == null || sampleOffsets.length != resultNumberOfChannels) {
            throw new AssertionError((Object)("interleavedSamplesRGBAOffsets() must return non-empty array with " + resultNumberOfChannels + " elements, but it returns " + Arrays.toString(sampleOffsets)));
        }
        int numberOfBanks = dataBuffer.getNumBanks();
        if (numberOfBanks == 1) {
            wr = Raster.createInterleavedRaster(dataBuffer, dimX, dimY, dimX * resultNumberOfChannels, resultNumberOfChannels, sampleOffsets, null);
        } else {
            int[] indexes = this.bandedSamplesRGBABankIndexes(numberOfBanks);
            int[] offsets = new int[numberOfBanks];
            wr = Raster.createBandedRaster(dataBuffer, dimX, dimY, dimX, indexes, offsets, null);
        }
        ComponentColorModel cm = MatrixToImage.componentColorModel(dataBuffer, resultNumberOfChannels);
        return new BufferedImage(cm, wr, false, null);
    }

    public int dimX(Matrix<? extends PArray> interleavedMatrix) {
        this.checkMatrix(interleavedMatrix);
        return (int)interleavedMatrix.dim(interleavedMatrix.dimCount() - 2);
    }

    public int dimY(Matrix<? extends PArray> interleavedMatrix) {
        this.checkMatrix(interleavedMatrix);
        return (int)interleavedMatrix.dim(interleavedMatrix.dimCount() - 1);
    }

    public int numberOfChannels(Matrix<? extends PArray> interleavedMatrix) {
        this.checkMatrix(interleavedMatrix);
        return interleavedMatrix.dimCount() == 2 ? 1 : (int)interleavedMatrix.dim(0);
    }

    /*
     * Unable to fully structure code
     */
    public final DataBuffer toDataBuffer(Matrix<? extends PArray> interleavedMatrix) {
        block4: {
            this.checkMatrix(interleavedMatrix);
            bandCount = interleavedMatrix.dimCount() == 2 ? 1L : interleavedMatrix.dim(0);
            array = interleavedMatrix.array();
            if (this.elementTypeSupported(array.elementType())) break block4;
            if (!(array instanceof IntArray)) ** GOTO lbl-1000
            ia = (IntArray)array;
            if (this.unsignedInt32) {
                ints = ia.ja();
                bytes = new byte[ints.length];
                for (k = 0; k < bytes.length; ++k) {
                    bytes[k] = (byte)(ints[k] >>> 24);
                }
                array = SimpleMemoryModel.asUpdatableByteArray(bytes);
            } else lbl-1000:
            // 2 sources

            {
                array = net.algart.arrays.Arrays.asFuncArray(LinearFunc.getInstance(0.0, new double[]{255.0 / array.maxPossibleValue(1.0)}), ByteArray.class, new PArray[]{array});
            }
        }
        if (!SimpleMemoryModel.isSimpleArray(array)) {
            array = array.updatableClone(net.algart.arrays.Arrays.SMM);
        }
        return this.toDataBuffer(array, (int)bandCount);
    }

    public abstract ColorChannelOrder channelOrder();

    public boolean elementTypeSupported(Class<?> elementType) {
        return elementType == Byte.TYPE;
    }

    public long colorValue(Matrix<? extends PArray> interleavedMatrix, Color color, int bankIndex) {
        int bandCount = this.numberOfChannels(interleavedMatrix);
        if (bandCount == 1) {
            return Math.round(0.3 * (double)color.getRed() + 0.59 * (double)color.getGreen() + 0.11 * (double)color.getBlue());
        }
        if (color == null) {
            throw new NullPointerException("Null color argument");
        }
        return switch (bankIndex) {
            case 0 -> color.getRed();
            case 1 -> color.getGreen();
            case 2 -> color.getBlue();
            case 3 -> color.getAlpha();
            default -> 0L;
        };
    }

    public byte[][] palette() {
        return null;
    }

    protected abstract DataBuffer toDataBuffer(PArray var1, int var2);

    public int resultNumberOfChannels(int sourceNumberOfChannels) {
        return sourceNumberOfChannels;
    }

    protected int[] packedSamplesRGBAMasks(int bandCount) {
        return null;
    }

    protected int[] interleavedSamplesRGBAOffsets(int bandCount) {
        return MatrixToImage.increasedIndexes(bandCount);
    }

    protected int[] bandedSamplesRGBABankIndexes(int bankCount) {
        return MatrixToImage.increasedIndexes(bankCount);
    }

    public static Object dataArray(DataBuffer dataBuffer, int bankIndex) {
        if (dataBuffer instanceof DataBufferByte) {
            return ((DataBufferByte)dataBuffer).getData(bankIndex);
        }
        if (dataBuffer instanceof DataBufferShort) {
            return ((DataBufferShort)dataBuffer).getData(bankIndex);
        }
        if (dataBuffer instanceof DataBufferUShort) {
            return ((DataBufferUShort)dataBuffer).getData(bankIndex);
        }
        if (dataBuffer instanceof DataBufferInt) {
            return ((DataBufferInt)dataBuffer).getData(bankIndex);
        }
        if (dataBuffer instanceof DataBufferFloat) {
            return ((DataBufferFloat)dataBuffer).getData(bankIndex);
        }
        if (dataBuffer instanceof DataBufferDouble) {
            return ((DataBufferDouble)dataBuffer).getData(bankIndex);
        }
        throw new UnsupportedOperationException("Unknown DataBuffer type");
    }

    int checkArray(PArray interleavedArray, int bandCount) {
        Objects.requireNonNull(interleavedArray, "Null source array");
        if (!this.elementTypeSupported(interleavedArray.elementType())) {
            throw new IllegalArgumentException("Unsupported element type: " + String.valueOf(interleavedArray.elementType()));
        }
        int len = interleavedArray.length32() / bandCount;
        if ((long)len * (long)bandCount != interleavedArray.length()) {
            throw new IllegalArgumentException("Unaligned ByteArray: its length " + interleavedArray.length() + " is not divided by band count = " + bandCount);
        }
        return len;
    }

    private static ComponentColorModel componentColorModel(DataBuffer dataBuffer, int numberOfChannels) {
        ColorSpace cs = ColorSpace.getInstance(numberOfChannels < 3 ? 1003 : 1000);
        boolean hasAlpha = numberOfChannels == 2 || numberOfChannels > 3;
        return new ComponentColorModel(cs, null, hasAlpha, false, hasAlpha ? 3 : 1, dataBuffer.getDataType());
    }

    private static int increaseNumberOfChannelsTo4(int sourceNumberOfChannels, boolean alwaysAddAlpha) {
        return switch (sourceNumberOfChannels) {
            case 1, 3 -> {
                if (alwaysAddAlpha) {
                    yield 4;
                }
                yield sourceNumberOfChannels;
            }
            case 2, 4 -> 4;
            default -> throw new IllegalArgumentException("Illegal sourceNumberOfChannels = " + sourceNumberOfChannels);
        };
    }

    private static int[] increasedIndexes(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Zero or negative number of channels: " + length);
        }
        int[] result = new int[length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = k;
        }
        return result;
    }

    private static int[] increasedIndexesFlipRB(int length) {
        int[] result = MatrixToImage.increasedIndexes(length);
        if (length == 3 || length == 4) {
            result[0] = 2;
            result[2] = 0;
        }
        return result;
    }

    private void checkMatrix(Matrix<? extends PArray> interleavedMatrix) {
        long numberOfChannels;
        Objects.requireNonNull(interleavedMatrix, "Null interleaved matrix");
        if (interleavedMatrix.dimCount() != 3 && interleavedMatrix.dimCount() != 2) {
            throw new IllegalArgumentException("Interleaved matrix must be 2- or 3-dimensional");
        }
        long l = numberOfChannels = interleavedMatrix.dimCount() == 2 ? 1L : interleavedMatrix.dim(0);
        if (numberOfChannels < 1L || numberOfChannels > 4L) {
            throw new IllegalArgumentException("Unsupported number " + numberOfChannels + " of color channels: it must be in range from 1 (monochrome) to 4 (usually red, green, blue, alpha)");
        }
        if (interleavedMatrix.size() > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large interleaved matrix " + String.valueOf(interleavedMatrix) + ": number of elements must be <= Integer.MAX_VALUE");
        }
    }

    public static class InterleavedRGBToInterleaved
    extends MatrixToImage {
        @Override
        public boolean elementTypeSupported(Class<?> elementType) {
            return this.isBytesRequired() ? elementType == Byte.TYPE : elementType == Byte.TYPE || elementType == Short.TYPE;
        }

        @Override
        public ColorChannelOrder channelOrder() {
            return ColorChannelOrder.RGB;
        }

        public String toString() {
            return "InterleavedRGBToInterleaved";
        }

        @Override
        protected DataBuffer toDataBuffer(PArray interleavedArray, int bandCount) {
            this.checkArray(interleavedArray, bandCount);
            if (interleavedArray instanceof ByteArray) {
                ByteArray a = (ByteArray)interleavedArray;
                byte[] result = a.toJavaArray();
                return new DataBufferByte(result, result.length);
            }
            if (interleavedArray instanceof ShortArray) {
                ShortArray a = (ShortArray)interleavedArray;
                short[] result = a.toJavaArray();
                return new DataBufferUShort(result, result.length);
            }
            throw new AssertionError((Object)("Unsupported element type: " + String.valueOf(interleavedArray.elementType())));
        }
    }

    public static class InterleavedBGRToInterleaved
    extends InterleavedRGBToInterleaved {
        @Override
        public ColorChannelOrder channelOrder() {
            return ColorChannelOrder.BGR;
        }

        @Override
        protected int[] interleavedSamplesRGBAOffsets(int bandCount) {
            return MatrixToImage.increasedIndexesFlipRB(bandCount);
        }
    }

    public static class MonochromeToIndexed
    extends InterleavedRGBToPacked {
        private final byte[] baseColor0;
        private final byte[] baseColor255;

        public MonochromeToIndexed(Color baseColor0, Color baseColor255) {
            Objects.requireNonNull(baseColor0, "Null baseColor0");
            Objects.requireNonNull(baseColor255, "Null baseColor255");
            this.baseColor0 = new byte[]{(byte)baseColor0.getRed(), (byte)baseColor0.getGreen(), (byte)baseColor0.getBlue(), (byte)baseColor0.getAlpha()};
            this.baseColor255 = new byte[]{(byte)baseColor255.getRed(), (byte)baseColor255.getGreen(), (byte)baseColor255.getBlue(), (byte)baseColor255.getAlpha()};
        }

        public MonochromeToIndexed(double[] baseColor0, double[] baseColor255) {
            Objects.requireNonNull(baseColor0, "Null baseColor0");
            Objects.requireNonNull(baseColor255, "Null baseColor255");
            this.baseColor0 = new byte[4];
            this.baseColor255 = new byte[4];
            for (int k = 0; k < 4; ++k) {
                double bc0 = baseColor0[k];
                this.baseColor0[k] = (byte)(bc0 < 0.0 ? 0L : (bc0 > 1.0 ? 255L : Math.round(bc0 * 255.0)));
                double bc255 = baseColor255[k];
                this.baseColor255[k] = (byte)(bc255 < 0.0 ? 0L : (bc255 > 1.0 ? 255L : Math.round(bc255 * 255.0)));
            }
        }

        @Override
        public long colorValue(Matrix<? extends PArray> interleavedMatrix, Color color, int bankIndex) {
            return Math.round(0.3 * (double)color.getRed() + 0.59 * (double)color.getGreen() + 0.11 * (double)color.getBlue());
        }

        @Override
        public byte[][] palette() {
            byte[][] result = new byte[4][256];
            for (int k = 0; k < 256; ++k) {
                for (int bandIndex = 0; bandIndex < 4; ++bandIndex) {
                    double bc0 = this.baseColor0[bandIndex] & 0xFF;
                    double bc255 = this.baseColor255[bandIndex] & 0xFF;
                    result[bandIndex][k] = (byte)Math.round(bc0 + (bc255 - bc0) * (double)k / 255.0);
                }
            }
            return result;
        }

        @Override
        public String toString() {
            return "MonochromeToIndexed: baseColor0=(" + JArrays.toString(this.baseColor0, Locale.US, "0x%X", ",", 100) + "), baseColor255=(" + JArrays.toString(this.baseColor255, Locale.US, "0x%X", ",", 100) + ")";
        }

        @Override
        protected DataBuffer toDataBuffer(PArray interleavedArray, int bandCount) {
            if (bandCount != 1) {
                throw new IllegalArgumentException("Illegal bandCount = " + bandCount + ": must be 1 for " + String.valueOf(this));
            }
            return super.toDataBuffer(interleavedArray, bandCount);
        }
    }

    public static class InterleavedBGRToBanded
    extends InterleavedRGBToBanded {
        @Override
        public InterleavedBGRToBanded setAlwaysAddAlpha(boolean alwaysAddAlpha) {
            super.setAlwaysAddAlpha(alwaysAddAlpha);
            return this;
        }

        @Override
        public ColorChannelOrder channelOrder() {
            return ColorChannelOrder.BGR;
        }

        @Override
        public String toString() {
            return "InterleavedBGRToBanded" + (this.isAlwaysAddAlpha() ? " (always adding alpha)" : "");
        }

        @Override
        protected int[] bandedSamplesRGBABankIndexes(int bankCount) {
            return MatrixToImage.increasedIndexesFlipRB(bankCount);
        }
    }

    public static class InterleavedRGBToBanded
    extends MatrixToImage {
        private boolean alwaysAddAlpha = false;

        public boolean isAlwaysAddAlpha() {
            return this.alwaysAddAlpha;
        }

        public InterleavedRGBToBanded setAlwaysAddAlpha(boolean alwaysAddAlpha) {
            this.alwaysAddAlpha = alwaysAddAlpha;
            return this;
        }

        @Override
        public ColorChannelOrder channelOrder() {
            return ColorChannelOrder.RGB;
        }

        public String toString() {
            return "InterleavedToBandedRGB" + (this.isAlwaysAddAlpha() ? " (always adding alpha)" : "");
        }

        @Override
        protected DataBuffer toDataBuffer(PArray interleavedArray, int bandCount) {
            int len = this.checkArray(interleavedArray, bandCount);
            byte[] ja = interleavedArray.jaByte();
            switch (bandCount) {
                case 1: {
                    if (this.alwaysAddAlpha) {
                        byte[][] result = new byte[4][len];
                        System.arraycopy(ja, 0, result[0], 0, len);
                        System.arraycopy(ja, 0, result[1], 0, len);
                        System.arraycopy(ja, 0, result[2], 0, len);
                        JArrays.fill(result[3], (byte)-1);
                        return new DataBufferByte(result, len);
                    }
                    byte[] result = new byte[len];
                    System.arraycopy(ja, 0, result, 0, len);
                    return new DataBufferByte(result, len);
                }
                case 2: {
                    byte[][] result = new byte[4][len];
                    int j = 0;
                    int disp = 0;
                    while (j < len) {
                        result[0][j] = ja[disp];
                        result[1][j] = ja[disp];
                        result[2][j] = ja[disp];
                        result[3][j] = ja[disp + 1];
                        ++j;
                        disp += 2;
                    }
                    return new DataBufferByte(result, len);
                }
                case 3: {
                    byte[][] result;
                    if (this.alwaysAddAlpha) {
                        result = new byte[4][len];
                        int j = 0;
                        int disp = 0;
                        while (j < len) {
                            result[0][j] = ja[disp];
                            result[1][j] = ja[disp + 1];
                            result[2][j] = ja[disp + 2];
                            result[3][j] = -1;
                            ++j;
                            disp += 3;
                        }
                    } else {
                        result = new byte[3][len];
                        int j = 0;
                        int disp = 0;
                        while (j < len) {
                            result[0][j] = ja[disp];
                            result[1][j] = ja[disp + 1];
                            result[2][j] = ja[disp + 2];
                            ++j;
                            disp += 3;
                        }
                    }
                    return new DataBufferByte(result, len);
                }
                case 4: {
                    byte[][] result = new byte[4][len];
                    int j = 0;
                    int disp = 0;
                    while (j < len) {
                        result[0][j] = ja[disp];
                        result[1][j] = ja[disp + 1];
                        result[2][j] = ja[disp + 2];
                        result[3][j] = ja[disp + 3];
                        ++j;
                        disp += 4;
                    }
                    return new DataBufferByte(result, len);
                }
            }
            throw new IllegalArgumentException("Illegal bandCount = " + bandCount);
        }

        @Override
        public int resultNumberOfChannels(int sourceNumberOfChannels) {
            return MatrixToImage.increaseNumberOfChannelsTo4(sourceNumberOfChannels, this.alwaysAddAlpha);
        }
    }

    public static class InterleavedBGRToPacked
    extends InterleavedRGBToPacked {
        @Override
        public InterleavedBGRToPacked setAlwaysAddAlpha(boolean alwaysAddAlpha) {
            super.setAlwaysAddAlpha(alwaysAddAlpha);
            return this;
        }

        @Override
        public ColorChannelOrder channelOrder() {
            return ColorChannelOrder.BGR;
        }

        @Override
        protected int[] packedSamplesRGBAMasks(int bandCount) {
            if (bandCount == 4 || bandCount == 2 || this.isAlwaysAddAlpha()) {
                return new int[]{255, 65280, 0xFF0000, -16777216};
            }
            if (bandCount == 3) {
                return new int[]{255, 65280, 0xFF0000};
            }
            return null;
        }

        @Override
        public String toString() {
            return "InterleavedBGRToPacked" + (this.isAlwaysAddAlpha() ? " (always adding alpha)" : "");
        }
    }

    public static class InterleavedRGBToPacked
    extends MatrixToImage {
        private boolean alwaysAddAlpha = false;

        public boolean isAlwaysAddAlpha() {
            return this.alwaysAddAlpha;
        }

        public InterleavedRGBToPacked setAlwaysAddAlpha(boolean alwaysAddAlpha) {
            this.alwaysAddAlpha = alwaysAddAlpha;
            return this;
        }

        @Override
        public ColorChannelOrder channelOrder() {
            return ColorChannelOrder.RGB;
        }

        @Override
        public long colorValue(Matrix<? extends PArray> interleavedMatrix, Color color, int bankIndex) {
            return color.getRGB();
        }

        public String toString() {
            return "InterleavedRGBToPacked" + (this.isAlwaysAddAlpha() ? " (always adding alpha)" : "");
        }

        @Override
        protected DataBuffer toDataBuffer(PArray interleavedArray, int bandCount) {
            int len = this.checkArray(interleavedArray, bandCount);
            byte[] ja = interleavedArray.jaByte();
            switch (bandCount) {
                case 1: {
                    if (this.alwaysAddAlpha) {
                        int[] result = new int[len];
                        int j = 0;
                        int disp = 0;
                        while (j < len) {
                            result[j] = (ja[disp] & 0xFF) << 16 | (ja[disp] & 0xFF) << 8 | ja[disp] & 0xFF | 0xFF000000;
                            ++j;
                            ++disp;
                        }
                        return new DataBufferInt(result, len);
                    }
                    byte[] result = new byte[len];
                    System.arraycopy(ja, 0, result, 0, result.length);
                    return new DataBufferByte(result, len);
                }
                case 2: {
                    int[] result = new int[len];
                    int j = 0;
                    int disp = 0;
                    while (j < len) {
                        result[j] = (ja[disp] & 0xFF) << 16 | (ja[disp] & 0xFF) << 8 | ja[disp] & 0xFF | (ja[disp + 1] & 0xFF) << 24;
                        ++j;
                        disp += 2;
                    }
                    return new DataBufferInt(result, len);
                }
                case 3: {
                    int[] result = new int[len];
                    int j = 0;
                    int disp = 0;
                    while (j < len) {
                        result[j] = (ja[disp] & 0xFF) << 16 | (ja[disp + 1] & 0xFF) << 8 | ja[disp + 2] & 0xFF | 0xFF000000;
                        ++j;
                        disp += 3;
                    }
                    return new DataBufferInt(result, len);
                }
                case 4: {
                    int[] result = new int[len];
                    int j = 0;
                    int disp = 0;
                    while (j < len) {
                        result[j] = (ja[disp] & 0xFF) << 16 | (ja[disp + 1] & 0xFF) << 8 | ja[disp + 2] & 0xFF | (ja[disp + 3] & 0xFF) << 24;
                        ++j;
                        disp += 4;
                    }
                    return new DataBufferInt(result, len);
                }
            }
            throw new IllegalArgumentException("Illegal bandCount = " + bandCount);
        }

        @Override
        public int resultNumberOfChannels(int sourceNumberOfChannels) {
            return MatrixToImage.increaseNumberOfChannelsTo4(sourceNumberOfChannels, this.alwaysAddAlpha);
        }

        @Override
        protected int[] packedSamplesRGBAMasks(int bandCount) {
            if (bandCount == 4 || bandCount == 2 || this.isAlwaysAddAlpha()) {
                return new int[]{0xFF0000, 65280, 255, -16777216};
            }
            if (bandCount == 3) {
                return new int[]{0xFF0000, 65280, 255};
            }
            return null;
        }
    }
}

