/*
 * Decompiled with CFR 0.152.
 */
package net.algart.io;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.algart.arrays.DataFileModel;
import net.algart.arrays.DefaultDataFileModel;
import net.algart.arrays.IllegalInfoSyntaxException;
import net.algart.arrays.LargeMemoryModel;
import net.algart.arrays.Matrix;
import net.algart.arrays.MatrixInfo;
import net.algart.arrays.PArray;
import net.algart.arrays.StandardIODataFileModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.io.UnsupportedImageFormatException;
import net.algart.io.awt.ImageToMatrix;
import net.algart.io.awt.MatrixToImage;

public class MatrixIO {
    public static String extension(Path file) {
        Objects.requireNonNull(file, "Null file");
        Path fileName = file.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("Path without file name is not allowed: \"" + String.valueOf(file) + "\"");
        }
        return MatrixIO.extension(fileName.toString());
    }

    public static String extension(Path file, String defaultExtension) {
        Objects.requireNonNull(file, "Null file");
        Path fileName = file.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("Path without file name is not allowed: \"" + String.valueOf(file) + "\"");
        }
        return MatrixIO.extension(fileName.toString(), defaultExtension);
    }

    public static String extension(File file) {
        Objects.requireNonNull(file, "Null file");
        return MatrixIO.extension(file.getName());
    }

    public static String extension(File file, String defaultExtension) {
        Objects.requireNonNull(file, "Null file");
        return MatrixIO.extension(file.getName(), defaultExtension);
    }

    public static String extension(String fileName) {
        String extension = MatrixIO.extension(fileName, null);
        if (extension == null) {
            throw new IllegalArgumentException("File name without extension is not allowed: \"" + fileName + "\"");
        }
        return extension;
    }

    public static String extension(String fileName, String defaultExtension) {
        Objects.requireNonNull(fileName, "Null fileName");
        if (fileName.isEmpty()) {
            throw new IllegalArgumentException("Empty file name is not allowed");
        }
        int p = fileName.lastIndexOf(46);
        if (p == -1) {
            return defaultExtension;
        }
        String result = fileName.substring(p + 1);
        return result.isEmpty() ? defaultExtension : result;
    }

    public static String removeExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int p = fileName.lastIndexOf(46);
        return p == -1 ? fileName : fileName.substring(0, p);
    }

    public static boolean setQuality(ImageWriteParam parameters, Double quality) {
        Objects.requireNonNull(parameters, "Null parameters (ImageWriteParam)");
        if (quality == null) {
            return false;
        }
        parameters.setCompressionMode(2);
        if (parameters.getCompressionType() != null) {
            parameters.setCompressionQuality(quality.floatValue());
            return true;
        }
        return false;
    }

    public static void writeBufferedImage(Path file, BufferedImage image) throws IOException {
        MatrixIO.writeBufferedImage(file, image, null);
    }

    public static void writeBufferedImage(Path file, BufferedImage image, Consumer<ImageWriteParam> customizer) throws IOException {
        MatrixIO.writeBufferedImageByExtension(file, image, MatrixIO.extension(file), customizer);
    }

    public static void writeBufferedImageByExtension(Path file, BufferedImage image, String fileExtension) throws IOException {
        MatrixIO.writeBufferedImageByExtension(file, image, fileExtension, null);
    }

    public static void writeBufferedImageByExtension(Path file, BufferedImage image, String fileExtension, Consumer<ImageWriteParam> customizer) throws IOException {
        ImageWriter writer;
        Objects.requireNonNull(file, "Null file");
        Objects.requireNonNull(image, "Null image");
        Objects.requireNonNull(fileExtension, "Null fileExtension");
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(fileExtension);
        ImageWriter imageWriter = writer = writers.hasNext() ? writers.next() : null;
        if (writer == null) {
            throw new UnsupportedImageFormatException("Cannot write " + String.valueOf(file) + ": no writers found for file suffix \"" + fileExtension + "\"");
        }
        MatrixIO.writeBufferedImage(file, image, writer, customizer);
    }

    public static void writeBufferedImageByFormatName(Path file, BufferedImage image, String formatName) throws IOException {
        MatrixIO.writeBufferedImageByFormatName(file, image, formatName, null);
    }

    public static void writeBufferedImageByFormatName(Path file, BufferedImage image, String formatName, Consumer<ImageWriteParam> customizer) throws IOException {
        ImageWriter writer;
        Objects.requireNonNull(file, "Null file");
        Objects.requireNonNull(image, "Null image");
        Objects.requireNonNull(formatName, "Null formatName");
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
        Iterator<ImageWriter> writers = ImageIO.getImageWriters(type, formatName);
        ImageWriter imageWriter = writer = writers.hasNext() ? writers.next() : null;
        if (writer == null) {
            throw new UnsupportedImageFormatException("Cannot write " + String.valueOf(file) + ": no writers found for format name \"" + formatName + "\" for writing " + String.valueOf(image));
        }
        MatrixIO.writeBufferedImage(file, image, writer, customizer);
    }

    public static void writeBufferedImage(Path file, BufferedImage image, ImageWriter writer, Consumer<ImageWriteParam> customizer) throws IOException {
        Objects.requireNonNull(file, "Null file");
        Objects.requireNonNull(image, "Null image");
        Objects.requireNonNull(writer, "Null writer");
        File output = file.toFile();
        output.delete();
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(output);){
            if (ios == null) {
                throw new IIOException("Cannot write image to " + String.valueOf(file) + ", possibly because the containing folder is invalid or not permitted for writing");
            }
            writer.setOutput(ios);
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            if (customizer != null) {
                customizer.accept(writeParam);
            }
            IIOImage iioImage = new IIOImage(image, null, null);
            writer.write(null, iioImage, writeParam);
        }
    }

    public static BufferedImage readBufferedImage(Path file) throws IOException {
        Objects.requireNonNull(file, "Null file");
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException("Image file " + String.valueOf(file) + " does not exist");
        }
        BufferedImage image = ImageIO.read(file.toFile());
        if (image == null) {
            throw new UnsupportedImageFormatException("Cannot read " + String.valueOf(file) + ": no suitable reader");
        }
        return image;
    }

    public static void writeImage(Path file, List<? extends Matrix<? extends PArray>> channels) throws IOException {
        MatrixIO.writeImage(file, channels, true, null);
    }

    public static void writeImage(Path file, List<? extends Matrix<? extends PArray>> channels, boolean convertAllElementTypesToByte, Consumer<ImageWriteParam> customizer) throws IOException {
        Objects.requireNonNull(file, "Null file");
        BufferedImage bi = MatrixToImage.ofChannels(channels, convertAllElementTypesToByte);
        MatrixIO.writeBufferedImage(file, bi, customizer);
    }

    public static List<Matrix<UpdatablePArray>> readImage(Path file) throws IOException {
        BufferedImage bi = MatrixIO.readBufferedImage(file);
        return ImageToMatrix.toChannels(bi);
    }

    public static void clearImageFolderTemporaryStatus(List<Matrix<? extends PArray>> channels) {
        for (Matrix<? extends PArray> m : channels) {
            PArray a = m.array();
            if (!LargeMemoryModel.isLargeArray(a)) continue;
            LargeMemoryModel.setTemporary(a, false);
            a.flushResources(null, true);
        }
    }

    public static void writeImageFolder(Path folder, List<? extends Matrix<? extends PArray>> channels) throws IOException {
        MatrixIO.writeImageFolder(folder, channels, false);
    }

    public static void writeImageFolder(Path folder, List<? extends Matrix<? extends PArray>> channels, boolean allowReferencesToStandardLargeFiles) throws IOException {
        Objects.requireNonNull(folder, "Null folder");
        Objects.requireNonNull(channels, "Null channels");
        channels = new ArrayList<Matrix<? extends PArray>>(channels);
        if (channels.isEmpty()) {
            throw new IllegalArgumentException("Empty list of image bands");
        }
        if (!Files.exists(folder, new LinkOption[0])) {
            Files.createDirectory(folder, new FileAttribute[0]);
        }
        File f = folder.toFile();
        Files.writeString(new File(f, "version").toPath(), (CharSequence)"1.0", new OpenOption[0]);
        int index = 0;
        for (Matrix<? extends PArray> matrix : channels) {
            DataFileModel<?> dataFileModel;
            if (allowReferencesToStandardLargeFiles && LargeMemoryModel.isLargeArray(matrix.array()) && ((dataFileModel = LargeMemoryModel.getDataFileModel(matrix.array())) instanceof DefaultDataFileModel || dataFileModel instanceof StandardIODataFileModel)) {
                infFile = new File(f, index + ".inf");
                File refFile = new File(f, index + ".ref");
                LargeMemoryModel<File> lmm = LargeMemoryModel.getInstance(dataFileModel).cast(File.class);
                MatrixInfo mi = LargeMemoryModel.getMatrixInfoForSavingInFile(matrix, 0L);
                PArray raw = LargeMemoryModel.getRawArrayForSavingInFile(matrix);
                assert (raw != null) : "Null raw array for LargeMemoryModel";
                Files.writeString(infFile.toPath(), (CharSequence)mi.toChars(), new OpenOption[0]);
                Files.writeString(refFile.toPath(), (CharSequence)lmm.getDataFilePath(raw).toString(), new OpenOption[0]);
                raw.flushResources(null, true);
            } else {
                infFile = new File(f, index + ".inf");
                File rawFile = new File(f, String.valueOf(index));
                LargeMemoryModel<File> mm = LargeMemoryModel.getInstance(new StandardIODataFileModel(rawFile, false, false));
                Matrix<UpdatablePArray> clone = mm.newMatrix(UpdatablePArray.class, matrix);
                LargeMemoryModel.setTemporary(clone.array(), false);
                clone = clone.structureLike(matrix);
                MatrixInfo mi = LargeMemoryModel.getMatrixInfoForSavingInFile(clone, 0L);
                Files.writeString(infFile.toPath(), (CharSequence)mi.toChars(), new OpenOption[0]);
                clone.array().copy(matrix.array());
                clone.array().freeResources(null, true);
            }
            ++index;
        }
        while (true) {
            File infFile = new File(f, index + ".inf");
            File file = new File(f, String.valueOf(index));
            if (!infFile.exists()) break;
            infFile.delete();
            file.delete();
            ++index;
        }
    }

    public static List<Matrix<? extends PArray>> readImageFolder(Path folder) throws IOException {
        Objects.requireNonNull(folder, "Null folder");
        File f = folder.toFile();
        if (!f.exists()) {
            throw new FileNotFoundException("Image subdirectory " + String.valueOf(f) + " does not exist");
        }
        if (!f.isDirectory()) {
            throw new FileNotFoundException("Image subdirectory " + String.valueOf(f) + " is not a directory");
        }
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        int index = 0;
        while (true) {
            File infFile = new File(f, index + ".inf");
            File refFile = new File(f, index + ".ref");
            File rawFile = new File(f, String.valueOf(index));
            if (!infFile.exists()) {
                if (index > 0) break;
                throw new FileNotFoundException("Image subdirectory " + String.valueOf(f) + " does not contain 0.inf file (meta-information of the 1st image component)");
            }
            if (refFile.exists()) {
                rawFile = new File(Files.readString(refFile.toPath()).trim());
            }
            LargeMemoryModel<File> mm = LargeMemoryModel.getInstance(new StandardIODataFileModel());
            try {
                MatrixInfo matrixInfo = MatrixInfo.valueOf(Files.readString(infFile.toPath()));
                result.add(mm.asMatrix(rawFile, matrixInfo));
            }
            catch (IllegalInfoSyntaxException e) {
                throw new IOException("Invalid meta-information file " + String.valueOf(infFile) + ": " + e.getMessage());
            }
            ++index;
        }
        return result;
    }
}

