/*
 * Decompiled with CFR 0.152.
 */
package net.algart.finalizing;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;

public final class Finalizer {
    private Thread thread = null;
    private int priority = 5;
    private final Set<PhantomFinalizeHolder> taskSet = new HashSet<PhantomFinalizeHolder>();
    private boolean shutdownRequested = false;
    private ReferenceQueue<Object> refQueue = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeOnDeallocation(Object checkedForDeallocation, Runnable task) {
        Set<PhantomFinalizeHolder> set = this.taskSet;
        synchronized (set) {
            if (this.thread == null) {
                this.refQueue = new ReferenceQueue();
                this.shutdownRequested = false;
                this.thread = new CleanupThread(this);
                this.thread.setDaemon(true);
                try {
                    this.thread.setPriority(this.priority);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.thread.start();
            }
            new PhantomFinalizeHolder(this, checkedForDeallocation, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeTasksCount() {
        Set<PhantomFinalizeHolder> set = this.taskSet;
        synchronized (set) {
            return this.taskSet.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        Set<PhantomFinalizeHolder> set = this.taskSet;
        synchronized (set) {
            if (this.thread != null) {
                this.shutdownRequested = true;
                this.thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int priority) {
        Set<PhantomFinalizeHolder> set = this.taskSet;
        synchronized (set) {
            if (priority > 10 || priority < 1) {
                throw new IllegalArgumentException();
            }
            this.priority = priority;
            if (this.thread != null) {
                try {
                    this.thread.setPriority(priority);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    private static class CleanupThread
    extends Thread {
        final Finalizer fin;

        CleanupThread(Finalizer fin) {
            this.fin = fin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Set<PhantomFinalizeHolder> set;
                PhantomFinalizeHolder phantomHolder = null;
                Reference<Object> holder = null;
                try {
                    holder = this.fin.refQueue.remove();
                    phantomHolder = (PhantomFinalizeHolder)holder;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (phantomHolder != null) {
                    phantomHolder.task.run();
                }
                if (holder != null) {
                    set = this.fin.taskSet;
                    synchronized (set) {
                        this.fin.taskSet.remove(holder);
                    }
                }
                set = this.fin.taskSet;
                synchronized (set) {
                    if (this.fin.shutdownRequested) {
                        this.fin.taskSet.clear();
                        this.fin.thread = null;
                        return;
                    }
                }
            }
        }
    }

    private static class PhantomFinalizeHolder
    extends PhantomReference<Object> {
        final Runnable task;

        PhantomFinalizeHolder(Finalizer fin, Object checkedForDeallocation, Runnable task) {
            super(checkedForDeallocation, fin.refQueue);
            this.task = task;
            fin.taskSet.add(this);
        }
    }
}

