/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import net.algart.arrays.Array;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataObjectBuffer;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableObjectArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableObjectArray;

public interface ObjectArray<E>
extends Array {
    public Class<E> elementType();

    public Class<? extends ObjectArray<E>> type();

    public Class<? extends UpdatableObjectArray<E>> updatableType();

    public Class<? extends MutableObjectArray<E>> mutableType();

    public E get(long var1);

    default public E[] newJavaArray(int length) {
        return (Object[])InternalUtils.cast(java.lang.reflect.Array.newInstance(this.elementType(), length));
    }

    public long indexOf(long var1, long var3, E var5);

    public long lastIndexOf(long var1, long var3, E var5);

    public <D> ObjectArray<D> cast(Class<D> var1);

    @Override
    public DataObjectBuffer<E> buffer(DataBuffer.AccessMode var1, long var2);

    @Override
    public DataObjectBuffer<E> buffer(DataBuffer.AccessMode var1);

    @Override
    public DataObjectBuffer<E> buffer(long var1);

    @Override
    public DataObjectBuffer<E> buffer();

    @Override
    public ObjectArray<E> asImmutable();

    @Override
    public ObjectArray<E> asTrustedImmutable();

    @Override
    public MutableObjectArray<E> mutableClone(MemoryModel var1);

    @Override
    public UpdatableObjectArray<E> updatableClone(MemoryModel var1);

    default public E[] toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Object[] Java array, because it is too large: " + String.valueOf(this));
        }
        E[] result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public E[] ja();

    default public Matrix<? extends ObjectArray<E>> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }
}

