/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutablePArray;
import net.algart.arrays.UpdatablePNumberArray;

public interface MutablePNumberArray
extends UpdatablePNumberArray,
MutablePArray {
    public static MutablePNumberArray newArray(MemoryModel memoryModel, Class<?> elementType) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        Objects.requireNonNull(elementType, "Null element type");
        if (!Arrays.isNumberElementType(elementType)) {
            throw new IllegalArgumentException("Not a numeric primitive type: " + String.valueOf(elementType));
        }
        return (MutablePNumberArray)memoryModel.newEmptyArray(elementType);
    }

    public static MutablePNumberArray newArray(Class<?> elementType) {
        return MutablePNumberArray.newArray(Arrays.SMM, elementType);
    }
}

