/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import net.algart.arrays.JArrays;

public class JBuffers {
    private static final int FILL_NON_BLOCKED_LEN = 256;
    private static final int FILL_BLOCK_LEN = 4096;
    private static final int ZERO_FILL_BLOCK_LEN = 4096;
    private static final boolean OPTIMIZE_BYTE_MIN_MAX_BY_TABLES = false;

    private JBuffers() {
    }

    public static void copyByteBuffer(ByteBuffer dest, int destPos, ByteBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (src == dest && srcPos == destPos) {
            return;
        }
        JBuffers.copyByteBuffer(dest, destPos, src, srcPos, count, src == dest && srcPos <= destPos && srcPos + count > destPos);
    }

    public static void copyByteBuffer(ByteBuffer dest, int destPos, ByteBuffer src, int srcPos, int count, boolean reverseOrder) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(src.limit(), srcPos, dest.limit(), destPos, count);
        if (reverseOrder) {
            int srcPos2 = srcPos + count - 1;
            int destPos2 = destPos + count - 1;
            while (srcPos2 >= srcPos) {
                dest.put(destPos2, src.get(srcPos2));
                --srcPos2;
                --destPos2;
            }
        } else {
            src = src.duplicate();
            dest = dest.duplicate();
            src.position(srcPos);
            dest.position(destPos);
            src.limit(srcPos + count);
            dest.put(src);
        }
    }

    public static void swapByteBuffer(ByteBuffer first, int firstPos, ByteBuffer second, int secondPos, int count) {
        Objects.requireNonNull(first, "Null first argument");
        Objects.requireNonNull(second, "Null second argument");
        JArrays.rangeCheck(first.limit(), firstPos, second.limit(), secondPos, count);
        int firstPosMax = firstPos + count;
        while (firstPos < firstPosMax) {
            byte v1 = first.get(firstPos);
            byte v2 = second.get(secondPos);
            first.put(firstPos, v2);
            second.put(secondPos, v1);
            ++firstPos;
            ++secondPos;
        }
    }

    public static void copyCharBuffer(CharBuffer dest, int destPos, CharBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (src == dest && srcPos == destPos) {
            return;
        }
        JBuffers.copyCharBuffer(dest, destPos, src, srcPos, count, src == dest && srcPos <= destPos && srcPos + count > destPos);
    }

    public static void copyCharBuffer(CharBuffer dest, int destPos, CharBuffer src, int srcPos, int count, boolean reverseOrder) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(src.limit(), srcPos, dest.limit(), destPos, count);
        if (reverseOrder) {
            int srcPos2 = srcPos + count - 1;
            int destPos2 = destPos + count - 1;
            while (srcPos2 >= srcPos) {
                dest.put(destPos2, src.get(srcPos2));
                --srcPos2;
                --destPos2;
            }
        } else {
            src = src.duplicate();
            dest = dest.duplicate();
            src.position(srcPos);
            dest.position(destPos);
            src.limit(srcPos + count);
            dest.put(src);
        }
    }

    public static void swapCharBuffer(CharBuffer first, int firstPos, CharBuffer second, int secondPos, int count) {
        Objects.requireNonNull(first, "Null first argument");
        Objects.requireNonNull(second, "Null second argument");
        JArrays.rangeCheck(first.limit(), firstPos, second.limit(), secondPos, count);
        int firstPosMax = firstPos + count;
        while (firstPos < firstPosMax) {
            char v1 = first.get(firstPos);
            char v2 = second.get(secondPos);
            first.put(firstPos, v2);
            second.put(secondPos, v1);
            ++firstPos;
            ++secondPos;
        }
    }

    public static void copyShortBuffer(ShortBuffer dest, int destPos, ShortBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (src == dest && srcPos == destPos) {
            return;
        }
        JBuffers.copyShortBuffer(dest, destPos, src, srcPos, count, src == dest && srcPos <= destPos && srcPos + count > destPos);
    }

    public static void copyShortBuffer(ShortBuffer dest, int destPos, ShortBuffer src, int srcPos, int count, boolean reverseOrder) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(src.limit(), srcPos, dest.limit(), destPos, count);
        if (reverseOrder) {
            int srcPos2 = srcPos + count - 1;
            int destPos2 = destPos + count - 1;
            while (srcPos2 >= srcPos) {
                dest.put(destPos2, src.get(srcPos2));
                --srcPos2;
                --destPos2;
            }
        } else {
            src = src.duplicate();
            dest = dest.duplicate();
            src.position(srcPos);
            dest.position(destPos);
            src.limit(srcPos + count);
            dest.put(src);
        }
    }

    public static void swapShortBuffer(ShortBuffer first, int firstPos, ShortBuffer second, int secondPos, int count) {
        Objects.requireNonNull(first, "Null first argument");
        Objects.requireNonNull(second, "Null second argument");
        JArrays.rangeCheck(first.limit(), firstPos, second.limit(), secondPos, count);
        int firstPosMax = firstPos + count;
        while (firstPos < firstPosMax) {
            short v1 = first.get(firstPos);
            short v2 = second.get(secondPos);
            first.put(firstPos, v2);
            second.put(secondPos, v1);
            ++firstPos;
            ++secondPos;
        }
    }

    public static void copyIntBuffer(IntBuffer dest, int destPos, IntBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (src == dest && srcPos == destPos) {
            return;
        }
        JBuffers.copyIntBuffer(dest, destPos, src, srcPos, count, src == dest && srcPos <= destPos && srcPos + count > destPos);
    }

    public static void copyIntBuffer(IntBuffer dest, int destPos, IntBuffer src, int srcPos, int count, boolean reverseOrder) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(src.limit(), srcPos, dest.limit(), destPos, count);
        if (reverseOrder) {
            int srcPos2 = srcPos + count - 1;
            int destPos2 = destPos + count - 1;
            while (srcPos2 >= srcPos) {
                dest.put(destPos2, src.get(srcPos2));
                --srcPos2;
                --destPos2;
            }
        } else {
            src = src.duplicate();
            dest = dest.duplicate();
            src.position(srcPos);
            dest.position(destPos);
            src.limit(srcPos + count);
            dest.put(src);
        }
    }

    public static void swapIntBuffer(IntBuffer first, int firstPos, IntBuffer second, int secondPos, int count) {
        Objects.requireNonNull(first, "Null first argument");
        Objects.requireNonNull(second, "Null second argument");
        JArrays.rangeCheck(first.limit(), firstPos, second.limit(), secondPos, count);
        int firstPosMax = firstPos + count;
        while (firstPos < firstPosMax) {
            int v1 = first.get(firstPos);
            int v2 = second.get(secondPos);
            first.put(firstPos, v2);
            second.put(secondPos, v1);
            ++firstPos;
            ++secondPos;
        }
    }

    public static void copyLongBuffer(LongBuffer dest, int destPos, LongBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (src == dest && srcPos == destPos) {
            return;
        }
        JBuffers.copyLongBuffer(dest, destPos, src, srcPos, count, src == dest && srcPos <= destPos && srcPos + count > destPos);
    }

    public static void copyLongBuffer(LongBuffer dest, int destPos, LongBuffer src, int srcPos, int count, boolean reverseOrder) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(src.limit(), srcPos, dest.limit(), destPos, count);
        if (reverseOrder) {
            int srcPos2 = srcPos + count - 1;
            int destPos2 = destPos + count - 1;
            while (srcPos2 >= srcPos) {
                dest.put(destPos2, src.get(srcPos2));
                --srcPos2;
                --destPos2;
            }
        } else {
            src = src.duplicate();
            dest = dest.duplicate();
            src.position(srcPos);
            dest.position(destPos);
            src.limit(srcPos + count);
            dest.put(src);
        }
    }

    public static void swapLongBuffer(LongBuffer first, int firstPos, LongBuffer second, int secondPos, int count) {
        Objects.requireNonNull(first, "Null first argument");
        Objects.requireNonNull(second, "Null second argument");
        JArrays.rangeCheck(first.limit(), firstPos, second.limit(), secondPos, count);
        int firstPosMax = firstPos + count;
        while (firstPos < firstPosMax) {
            long v1 = first.get(firstPos);
            long v2 = second.get(secondPos);
            first.put(firstPos, v2);
            second.put(secondPos, v1);
            ++firstPos;
            ++secondPos;
        }
    }

    public static void copyFloatBuffer(FloatBuffer dest, int destPos, FloatBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (src == dest && srcPos == destPos) {
            return;
        }
        JBuffers.copyFloatBuffer(dest, destPos, src, srcPos, count, src == dest && srcPos <= destPos && srcPos + count > destPos);
    }

    public static void copyFloatBuffer(FloatBuffer dest, int destPos, FloatBuffer src, int srcPos, int count, boolean reverseOrder) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(src.limit(), srcPos, dest.limit(), destPos, count);
        if (reverseOrder) {
            int srcPos2 = srcPos + count - 1;
            int destPos2 = destPos + count - 1;
            while (srcPos2 >= srcPos) {
                dest.put(destPos2, src.get(srcPos2));
                --srcPos2;
                --destPos2;
            }
        } else {
            src = src.duplicate();
            dest = dest.duplicate();
            src.position(srcPos);
            dest.position(destPos);
            src.limit(srcPos + count);
            dest.put(src);
        }
    }

    public static void swapFloatBuffer(FloatBuffer first, int firstPos, FloatBuffer second, int secondPos, int count) {
        Objects.requireNonNull(first, "Null first argument");
        Objects.requireNonNull(second, "Null second argument");
        JArrays.rangeCheck(first.limit(), firstPos, second.limit(), secondPos, count);
        int firstPosMax = firstPos + count;
        while (firstPos < firstPosMax) {
            float v1 = first.get(firstPos);
            float v2 = second.get(secondPos);
            first.put(firstPos, v2);
            second.put(secondPos, v1);
            ++firstPos;
            ++secondPos;
        }
    }

    public static void copyDoubleBuffer(DoubleBuffer dest, int destPos, DoubleBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (src == dest && srcPos == destPos) {
            return;
        }
        JBuffers.copyDoubleBuffer(dest, destPos, src, srcPos, count, src == dest && srcPos <= destPos && srcPos + count > destPos);
    }

    public static void copyDoubleBuffer(DoubleBuffer dest, int destPos, DoubleBuffer src, int srcPos, int count, boolean reverseOrder) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(src.limit(), srcPos, dest.limit(), destPos, count);
        if (reverseOrder) {
            int srcPos2 = srcPos + count - 1;
            int destPos2 = destPos + count - 1;
            while (srcPos2 >= srcPos) {
                dest.put(destPos2, src.get(srcPos2));
                --srcPos2;
                --destPos2;
            }
        } else {
            src = src.duplicate();
            dest = dest.duplicate();
            src.position(srcPos);
            dest.position(destPos);
            src.limit(srcPos + count);
            dest.put(src);
        }
    }

    public static void swapDoubleBuffer(DoubleBuffer first, int firstPos, DoubleBuffer second, int secondPos, int count) {
        Objects.requireNonNull(first, "Null first argument");
        Objects.requireNonNull(second, "Null second argument");
        JArrays.rangeCheck(first.limit(), firstPos, second.limit(), secondPos, count);
        int firstPosMax = firstPos + count;
        while (firstPos < firstPosMax) {
            double v1 = first.get(firstPos);
            double v2 = second.get(secondPos);
            first.put(firstPos, v2);
            second.put(secondPos, v1);
            ++firstPos;
            ++secondPos;
        }
    }

    public static void fillByteBuffer(ByteBuffer dest, int destPos, int count, byte value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.limit(), destPos, count);
        if (count >= 256) {
            byte[] arr;
            if (value != 0) {
                arr = new byte[4096];
                JArrays.fill(arr, value);
            } else {
                arr = new byte[4096];
            }
            ByteBuffer destDup = dest.duplicate();
            destDup.position(destPos);
            while (count >= arr.length) {
                destDup.put(arr);
                count -= arr.length;
            }
            destDup.put(arr, 0, count);
        } else {
            for (int k = 0; k < count; ++k) {
                dest.put(destPos + k, value);
            }
        }
    }

    public static void fillCharBuffer(CharBuffer dest, int destPos, int count, char value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.limit(), destPos, count);
        if (count >= 256) {
            char[] arr;
            if (value != '\u0000') {
                arr = new char[4096];
                JArrays.fill(arr, value);
            } else {
                arr = new char[4096];
            }
            CharBuffer destDup = dest.duplicate();
            destDup.position(destPos);
            while (count >= arr.length) {
                destDup.put(arr);
                count -= arr.length;
            }
            destDup.put(arr, 0, count);
        } else {
            for (int k = 0; k < count; ++k) {
                dest.put(destPos + k, value);
            }
        }
    }

    public static void fillShortBuffer(ShortBuffer dest, int destPos, int count, short value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.limit(), destPos, count);
        if (count >= 256) {
            short[] arr;
            if (value != 0) {
                arr = new short[4096];
                JArrays.fill(arr, value);
            } else {
                arr = new short[4096];
            }
            ShortBuffer destDup = dest.duplicate();
            destDup.position(destPos);
            while (count >= arr.length) {
                destDup.put(arr);
                count -= arr.length;
            }
            destDup.put(arr, 0, count);
        } else {
            for (int k = 0; k < count; ++k) {
                dest.put(destPos + k, value);
            }
        }
    }

    public static void fillIntBuffer(IntBuffer dest, int destPos, int count, int value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.limit(), destPos, count);
        if (count >= 256) {
            int[] arr;
            if (value != 0) {
                arr = new int[4096];
                JArrays.fill(arr, value);
            } else {
                arr = new int[4096];
            }
            IntBuffer destDup = dest.duplicate();
            destDup.position(destPos);
            while (count >= arr.length) {
                destDup.put(arr);
                count -= arr.length;
            }
            destDup.put(arr, 0, count);
        } else {
            for (int k = 0; k < count; ++k) {
                dest.put(destPos + k, value);
            }
        }
    }

    public static void fillLongBuffer(LongBuffer dest, int destPos, int count, long value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.limit(), destPos, count);
        if (count >= 256) {
            long[] arr;
            if (value != 0L) {
                arr = new long[4096];
                JArrays.fill(arr, value);
            } else {
                arr = new long[4096];
            }
            LongBuffer destDup = dest.duplicate();
            destDup.position(destPos);
            while (count >= arr.length) {
                destDup.put(arr);
                count -= arr.length;
            }
            destDup.put(arr, 0, count);
        } else {
            for (int k = 0; k < count; ++k) {
                dest.put(destPos + k, value);
            }
        }
    }

    public static void fillFloatBuffer(FloatBuffer dest, int destPos, int count, float value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.limit(), destPos, count);
        if (count >= 256) {
            float[] arr;
            if (value != 0.0f) {
                arr = new float[4096];
                JArrays.fill(arr, value);
            } else {
                arr = new float[4096];
            }
            FloatBuffer destDup = dest.duplicate();
            destDup.position(destPos);
            while (count >= arr.length) {
                destDup.put(arr);
                count -= arr.length;
            }
            destDup.put(arr, 0, count);
        } else {
            for (int k = 0; k < count; ++k) {
                dest.put(destPos + k, value);
            }
        }
    }

    public static void fillDoubleBuffer(DoubleBuffer dest, int destPos, int count, double value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.limit(), destPos, count);
        if (count >= 256) {
            double[] arr;
            if (value != 0.0) {
                arr = new double[4096];
                JArrays.fill(arr, value);
            } else {
                arr = new double[4096];
            }
            DoubleBuffer destDup = dest.duplicate();
            destDup.position(destPos);
            while (count >= arr.length) {
                destDup.put(arr);
                count -= arr.length;
            }
            destDup.put(arr, 0, count);
        } else {
            for (int k = 0; k < count; ++k) {
                dest.put(destPos + k, value);
            }
        }
    }

    public static int indexOfByte(ByteBuffer buffer, int lowIndex, int highIndex, byte value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(buffer.limit(), highIndex);
        while (lowIndex < maxPlus1) {
            if (buffer.get(lowIndex) == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfByte(ByteBuffer buffer, int lowIndex, int highIndex, byte value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (highIndex > buffer.limit()) {
            highIndex = buffer.limit();
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (buffer.get(--highIndex) != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfChar(CharBuffer buffer, int lowIndex, int highIndex, char value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(buffer.limit(), highIndex);
        while (lowIndex < maxPlus1) {
            if (buffer.get(lowIndex) == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfChar(CharBuffer buffer, int lowIndex, int highIndex, char value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (highIndex > buffer.limit()) {
            highIndex = buffer.limit();
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (buffer.get(--highIndex) != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfShort(ShortBuffer buffer, int lowIndex, int highIndex, short value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(buffer.limit(), highIndex);
        while (lowIndex < maxPlus1) {
            if (buffer.get(lowIndex) == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfShort(ShortBuffer buffer, int lowIndex, int highIndex, short value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (highIndex > buffer.limit()) {
            highIndex = buffer.limit();
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (buffer.get(--highIndex) != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfInt(IntBuffer buffer, int lowIndex, int highIndex, int value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(buffer.limit(), highIndex);
        while (lowIndex < maxPlus1) {
            if (buffer.get(lowIndex) == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfInt(IntBuffer buffer, int lowIndex, int highIndex, int value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (highIndex > buffer.limit()) {
            highIndex = buffer.limit();
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (buffer.get(--highIndex) != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfLong(LongBuffer buffer, int lowIndex, int highIndex, long value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(buffer.limit(), highIndex);
        while (lowIndex < maxPlus1) {
            if (buffer.get(lowIndex) == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfLong(LongBuffer buffer, int lowIndex, int highIndex, long value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (highIndex > buffer.limit()) {
            highIndex = buffer.limit();
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (buffer.get(--highIndex) != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfFloat(FloatBuffer buffer, int lowIndex, int highIndex, float value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(buffer.limit(), highIndex);
        while (lowIndex < maxPlus1) {
            if (buffer.get(lowIndex) == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfFloat(FloatBuffer buffer, int lowIndex, int highIndex, float value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (highIndex > buffer.limit()) {
            highIndex = buffer.limit();
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (buffer.get(--highIndex) != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfDouble(DoubleBuffer buffer, int lowIndex, int highIndex, double value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(buffer.limit(), highIndex);
        while (lowIndex < maxPlus1) {
            if (buffer.get(lowIndex) == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfDouble(DoubleBuffer buffer, int lowIndex, int highIndex, double value) {
        Objects.requireNonNull(buffer, "Null buffer argument");
        if (highIndex > buffer.limit()) {
            highIndex = buffer.limit();
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (buffer.get(--highIndex) != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static void minByteArrayAndBuffer(byte[] dest, int destPos, ByteBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            byte v = src.get(srcPos);
            if ((v & 0xFF) < (dest[destPos] & 0xFF)) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxByteArrayAndBuffer(byte[] dest, int destPos, ByteBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            byte v = src.get(srcPos);
            if ((v & 0xFF) > (dest[destPos] & 0xFF)) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void minShortArrayAndBuffer(short[] dest, int destPos, ShortBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            short v = src.get(srcPos);
            if ((v & 0xFFFF) < (dest[destPos] & 0xFFFF)) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxShortArrayAndBuffer(short[] dest, int destPos, ShortBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            short v = src.get(srcPos);
            if ((v & 0xFFFF) > (dest[destPos] & 0xFFFF)) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void minCharArrayAndBuffer(char[] dest, int destPos, CharBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            char v = src.get(srcPos);
            if (v < dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxCharArrayAndBuffer(char[] dest, int destPos, CharBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            char v = src.get(srcPos);
            if (v > dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void minIntArrayAndBuffer(int[] dest, int destPos, IntBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int v = src.get(srcPos);
            if (v < dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxIntArrayAndBuffer(int[] dest, int destPos, IntBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int v = src.get(srcPos);
            if (v > dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void minLongArrayAndBuffer(long[] dest, int destPos, LongBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            long v = src.get(srcPos);
            if (v < dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxLongArrayAndBuffer(long[] dest, int destPos, LongBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            long v = src.get(srcPos);
            if (v > dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void minFloatArrayAndBuffer(float[] dest, int destPos, FloatBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            float v = src.get(srcPos);
            if (v < dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxFloatArrayAndBuffer(float[] dest, int destPos, FloatBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            float v = src.get(srcPos);
            if (v > dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void minDoubleArrayAndBuffer(double[] dest, int destPos, DoubleBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            double v = src.get(srcPos);
            if (v < dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxDoubleArrayAndBuffer(double[] dest, int destPos, DoubleBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            double v = src.get(srcPos);
            if (v > dest[destPos]) {
                dest[destPos] = v;
            }
            ++srcPos;
            ++destPos;
        }
    }

    public static void addByteBufferToArray(int[] dest, int destPos, ByteBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (src.get(srcPos) & 0xFF);
            ++srcPos;
        }
    }

    public static void addByteBufferToArray(double[] dest, int destPos, ByteBuffer src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)(src.get(srcPos) & 0xFF);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)(src.get(srcPos) & 0xFF);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)(src.get(srcPos) & 0xFF) * mult;
                ++srcPos;
            }
        }
    }

    public static void addCharBufferToArray(int[] dest, int destPos, CharBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + src.get(srcPos);
            ++srcPos;
        }
    }

    public static void addCharBufferToArray(double[] dest, int destPos, CharBuffer src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src.get(srcPos);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)src.get(srcPos);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src.get(srcPos) * mult;
                ++srcPos;
            }
        }
    }

    public static void addShortBufferToArray(int[] dest, int destPos, ShortBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (src.get(srcPos) & 0xFFFF);
            ++srcPos;
        }
    }

    public static void addShortBufferToArray(double[] dest, int destPos, ShortBuffer src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)(src.get(srcPos) & 0xFFFF);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)(src.get(srcPos) & 0xFFFF);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)(src.get(srcPos) & 0xFFFF) * mult;
                ++srcPos;
            }
        }
    }

    public static void addIntBufferToArray(int[] dest, int destPos, IntBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + src.get(srcPos);
            ++srcPos;
        }
    }

    public static void addIntBufferToArray(double[] dest, int destPos, IntBuffer src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src.get(srcPos);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)src.get(srcPos);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src.get(srcPos) * mult;
                ++srcPos;
            }
        }
    }

    public static void addLongBufferToArray(int[] dest, int destPos, LongBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (int)src.get(srcPos);
            ++srcPos;
        }
    }

    public static void addLongBufferToArray(double[] dest, int destPos, LongBuffer src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src.get(srcPos);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)src.get(srcPos);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src.get(srcPos) * mult;
                ++srcPos;
            }
        }
    }

    public static void addFloatBufferToArray(int[] dest, int destPos, FloatBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (int)src.get(srcPos);
            ++srcPos;
        }
    }

    public static void addFloatBufferToArray(double[] dest, int destPos, FloatBuffer src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src.get(srcPos);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)src.get(srcPos);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src.get(srcPos) * mult;
                ++srcPos;
            }
        }
    }

    public static void addDoubleBufferToArray(int[] dest, int destPos, DoubleBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (int)src.get(srcPos);
            ++srcPos;
        }
    }

    public static void addDoubleBufferToArray(double[] dest, int destPos, DoubleBuffer src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + src.get(srcPos);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - src.get(srcPos);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + src.get(srcPos) * mult;
                ++srcPos;
            }
        }
    }

    public static void subtractByteBufferFromArray(byte[] dest, int destPos, ByteBuffer src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int v = (dest[destPos] & 0xFF) - (src.get(srcPos) & 0xFF);
                dest[destPos] = v < 0 ? (byte)0 : (byte)v;
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = (byte)(dest[n] - src.get(srcPos));
                ++srcPos;
            }
        }
    }

    public static void subtractCharBufferFromArray(char[] dest, int destPos, CharBuffer src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int v = dest[destPos] - src.get(srcPos);
                dest[destPos] = v < 0 ? (char)'\u0000' : (char)v;
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = (char)(dest[n] - src.get(srcPos));
                ++srcPos;
            }
        }
    }

    public static void subtractShortBufferFromArray(short[] dest, int destPos, ShortBuffer src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int v = (dest[destPos] & 0xFFFF) - (src.get(srcPos) & 0xFFFF);
                dest[destPos] = v < 0 ? (short)0 : (short)v;
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = (short)(dest[n] - src.get(srcPos));
                ++srcPos;
            }
        }
    }

    public static void subtractIntBufferFromArray(int[] dest, int destPos, IntBuffer src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                long v = (long)dest[destPos] - (long)src.get(srcPos);
                dest[destPos] = v < Integer.MIN_VALUE ? Integer.MIN_VALUE : (v > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v);
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - src.get(srcPos);
                ++srcPos;
            }
        }
    }

    public static void subtractLongBufferFromArray(long[] dest, int destPos, LongBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] - src.get(srcPos);
            ++srcPos;
        }
    }

    public static void subtractFloatBufferFromArray(float[] dest, int destPos, FloatBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] - src.get(srcPos);
            ++srcPos;
        }
    }

    public static void subtractDoubleBufferFromArray(double[] dest, int destPos, DoubleBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] - src.get(srcPos);
            ++srcPos;
        }
    }

    public static void absDiffOfByteArrayAndBuffer(byte[] dest, int destPos, ByteBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            byte v = src.get(srcPos);
            dest[destPos] = (dest[destPos] & 0xFF) >= (v & 0xFF) ? (byte)(dest[destPos] - v) : (byte)(v - dest[destPos]);
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfCharArrayAndBuffer(char[] dest, int destPos, CharBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            char v = src.get(srcPos);
            dest[destPos] = dest[destPos] >= v ? (char)(dest[destPos] - v) : (char)(v - dest[destPos]);
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfShortArrayAndBuffer(short[] dest, int destPos, ShortBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            short v = src.get(srcPos);
            dest[destPos] = (dest[destPos] & 0xFFFF) >= (v & 0xFFFF) ? (short)(dest[destPos] - v) : (short)(v - dest[destPos]);
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfLongArrayAndBuffer(long[] dest, int destPos, LongBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            long v = src.get(srcPos);
            dest[destPos] = dest[destPos] >= v ? dest[destPos] - v : v - dest[destPos];
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfFloatArrayAndBuffer(float[] dest, int destPos, FloatBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            float v = src.get(srcPos);
            dest[destPos] = dest[destPos] >= v ? dest[destPos] - v : v - dest[destPos];
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfDoubleArrayAndBuffer(double[] dest, int destPos, DoubleBuffer src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            double v = src.get(srcPos);
            dest[destPos] = dest[destPos] >= v ? dest[destPos] - v : v - dest[destPos];
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfIntArrayAndBuffer(int[] dest, int destPos, IntBuffer src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.limit(), srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                long v = (long)dest[destPos] - (long)src.get(srcPos);
                if (v < 0L) {
                    v = -v;
                }
                dest[destPos] = v > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v;
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int v = src.get(srcPos);
                dest[destPos] = dest[destPos] >= v ? dest[destPos] - v : v - dest[destPos];
                ++srcPos;
                ++destPos;
            }
        }
    }
}

