/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.lang.ref.SoftReference;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.TooLargeArrayException;

public final class FloatJArrayHolder {
    private SoftReference<float[]> reference = new SoftReference<float[]>(new float[0]);
    private final Object lock = new Object();

    public float[] quickNew(Matrix<?> matrix) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        return this.quickNew(matrix.size());
    }

    public float[] quickNew(long newArrayLength) {
        if (newArrayLength < 0L) {
            throw new IllegalArgumentException("Zero or negative array new array length");
        }
        if (newArrayLength != (long)((int)newArrayLength)) {
            throw new TooLargeArrayException("Too large requested array: " + newArrayLength + " elements");
        }
        return this.quickNew((int)newArrayLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] quickNew(int newArrayLength) {
        if (newArrayLength < 0) {
            throw new IllegalArgumentException("Zero or negative array new array length");
        }
        Object object = this.lock;
        synchronized (object) {
            float[] oldArray = this.reference.get();
            if (oldArray != null && oldArray.length == newArrayLength) {
                return oldArray;
            }
            float[] result = new float[newArrayLength];
            this.reference = new SoftReference<float[]>(result);
            return result;
        }
    }

    public float[] quickClone(float[] array) {
        float[] result = this.quickNew(array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }
}

