/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableBitArray;

public interface BitArray
extends PFixedArray {
    public Class<? extends BitArray> type();

    public Class<? extends UpdatableBitArray> updatableType();

    public Class<? extends MutableBitArray> mutableType();

    public boolean getBit(long var1);

    default public boolean[] newJavaArray(int length) {
        return new boolean[length];
    }

    public long indexOf(long var1, long var3, boolean var5);

    public long lastIndexOf(long var1, long var3, boolean var5);

    @Override
    public DataBitBuffer buffer(DataBuffer.AccessMode var1, long var2);

    @Override
    public DataBitBuffer buffer(DataBuffer.AccessMode var1);

    @Override
    public DataBitBuffer buffer(long var1);

    @Override
    public DataBitBuffer buffer();

    @Override
    public BitArray asImmutable();

    @Override
    public BitArray asTrustedImmutable();

    @Override
    public MutableBitArray mutableClone(MemoryModel var1);

    @Override
    public UpdatableBitArray updatableClone(MemoryModel var1);

    default public boolean[] toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to boolean[] Java array, because it is too large: " + String.valueOf(this));
        }
        boolean[] result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public boolean[] ja();

    default public Matrix<? extends BitArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    @Override
    default public boolean[] toBoolean() {
        return this.toJavaArray();
    }

    public static UpdatableBitArray newArray(MemoryModel memoryModel, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableBitArray(length);
    }

    public static UpdatableBitArray newArray(long length) {
        return Arrays.SMM.newUnresizableBitArray(length);
    }

    @Override
    public int getInt(long var1);

    default public long getBits64(long arrayPos, int count) {
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("Negative arrayPos argument: " + arrayPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
        }
        long result = 0L;
        for (int k = 0; k < count; ++k) {
            long bit = this.getBit(arrayPos + (long)k) ? 1L : 0L;
            result |= bit << k;
        }
        return result;
    }

    public void getBits(long var1, long[] var3, long var4, long var6);

    public long nextQuickPosition(long var1);

    default public long[] toBit() {
        long length = this.length();
        long packedLength = PackedBitArrays.packedLength(length);
        if (packedLength != (long)((int)packedLength)) {
            throw new TooLargeArrayException("Cannot convert AlgART bit array to packed long[] array, because it is too large: " + String.valueOf(this));
        }
        long[] result = new long[(int)packedLength];
        this.getBits(0L, result, 0L, length);
        return result;
    }

    default public long[] jaBit() {
        return this.toBit();
    }

    default public boolean isPackedBitArrayWrapper() {
        return false;
    }

    public static UpdatableBitArray as(long[] packedBitArray, long length) {
        return SimpleMemoryModel.asUpdatableBitArray(packedBitArray, length);
    }
}

