/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysSubMatrixImpl;
import net.algart.arrays.ArraysTileMatrixImpl;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableArray;
import net.algart.math.IRange;

abstract class ArraysSubMatrixCopier {
    private static final boolean ENABLE_THIS_OPTIMIZATION = Arrays.SystemSettings.getBooleanProperty("net.algart.arrays.enableSubMatrixCopierOptimization", true);
    private static final boolean ENABLE_CONTINUOUS_OPTIMIZATION_FOR_DEST = Arrays.SystemSettings.getBooleanProperty("net.algart.arrays.enableSubMatrixCopierContinuousDestOptimization", true);
    private static final boolean ENABLE_CONTINUOUS_OPTIMIZATION_FOR_SRC = Arrays.SystemSettings.getBooleanProperty("net.algart.arrays.enableSubMatrixCopierContinuousSrcOptimization", true);
    private static final boolean DEBUG_MODE = false;
    private static final boolean DEBUG_ALSO_ONE_DIMENSIONAL = false;
    private static final long MIN_ARRAY_LENGTH_FOR_COPY_SUB_MATRIX = 1024L;
    final Matrix<? extends UpdatableArray> dest;
    final Matrix<? extends Array> src;
    final Matrix.ContinuationMode destContinuationMode;
    final Matrix.ContinuationMode srcContinuationMode;
    final int n;
    final long[] destPosition;
    final long[] srcPosition;
    final long[] dimensions;
    final boolean isCopierToTiled;
    final Matrix<? extends Array> tileParent;
    final ArraysTileMatrixImpl.Indexer tilingIndexer;
    final long[] tileDimensions;
    final long[] tileStartIndexes;
    final long[] tileCounts;
    final Matrix<?> tileEnumerator;
    final boolean processingDeclined;
    boolean nothingToDo = false;

    ArraysSubMatrixCopier(Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, Matrix.ContinuationMode destContinuationMode, Matrix.ContinuationMode srcContinuationMode, long[] destPosition, long[] srcPosition, long[] dimensions, boolean isCopierToTiled) {
        assert (src.dimCount() == dimensions.length);
        assert (destPosition.length == dimensions.length);
        assert (srcPosition.length == dimensions.length);
        assert (dest.dimCount() == dimensions.length);
        assert (destContinuationMode != null);
        assert (srcContinuationMode != null);
        assert (!isCopierToTiled ? src.isTiled() : dest.isTiled());
        this.dest = dest;
        this.src = src;
        this.destContinuationMode = destContinuationMode;
        this.srcContinuationMode = srcContinuationMode;
        this.destPosition = destPosition;
        this.srcPosition = srcPosition;
        this.dimensions = dimensions;
        this.n = dimensions.length;
        this.isCopierToTiled = isCopierToTiled;
        this.tileParent = (isCopierToTiled ? dest : src).tileParent();
        boolean fullyInsideDest = true;
        for (int k = 0; k < this.n; ++k) {
            assert (this.dimensions[k] >= 0L);
            if (this.destPosition[k] < 0L) {
                int n = k;
                this.srcPosition[n] = this.srcPosition[n] - this.destPosition[k];
                int n2 = k;
                this.dimensions[n2] = this.dimensions[n2] + this.destPosition[k];
                this.destPosition[k] = 0L;
                fullyInsideDest = false;
            }
            if (this.destPosition[k] > dest.dim(k) - this.dimensions[k]) {
                this.dimensions[k] = dest.dim(k) - this.destPosition[k];
                fullyInsideDest = false;
            }
            if (this.dimensions[k] > 0L) continue;
            this.dimensions[k] = 0L;
            this.nothingToDo = true;
        }
        assert (fullyInsideDest || destContinuationMode != Matrix.ContinuationMode.NONE);
        boolean bl = this.processingDeclined = !fullyInsideDest && !destContinuationMode.isConstant();
        if (this.nothingToDo || this.processingDeclined) {
            this.tilingIndexer = null;
            this.tileDimensions = null;
            this.tileStartIndexes = null;
            this.tileCounts = null;
            this.tileEnumerator = null;
        } else {
            Array a = (isCopierToTiled ? dest : src).array();
            this.tilingIndexer = a instanceof ArraysTileMatrixImpl.TileMatrixArray ? ((ArraysTileMatrixImpl.TileMatrixArray)((Object)a)).indexer() : null;
            this.tileDimensions = (isCopierToTiled ? dest : src).tileDimensions();
            this.tileStartIndexes = new long[this.n];
            this.tileCounts = new long[this.n];
            long[] positionInTiled = isCopierToTiled ? destPosition : srcPosition;
            for (int k = 0; k < this.n; ++k) {
                long maxIndex;
                assert (this.tileDimensions[k] > 0L) : "Illegal tiling (negative tile dimension)";
                assert (dimensions[k] > 0L);
                assert (dimensions[k] <= dest.dim(k));
                long min = positionInTiled[k];
                long minIndex = min >= 0L ? min / this.tileDimensions[k] : (min + 1L) / this.tileDimensions[k] - 1L;
                long max = min + this.dimensions[k] - 1L;
                long l = maxIndex = max >= 0L ? max / this.tileDimensions[k] : (max + 1L) / this.tileDimensions[k] - 1L;
                assert (maxIndex <= maxIndex);
                this.tileStartIndexes[k] = minIndex;
                this.tileCounts[k] = maxIndex - minIndex + 1L;
                assert (this.tileCounts[k] <= dimensions[k]);
            }
            this.tileEnumerator = Matrices.matrix(Arrays.nIntCopies(Arrays.longMul(this.tileCounts), 157), this.tileCounts);
        }
    }

    public static boolean copySubMatrixArray(ArrayContext context, UpdatableArray dest, Array src) {
        if (!ENABLE_THIS_OPTIMIZATION) {
            return false;
        }
        if (dest instanceof ArraysSubMatrixImpl.SubMatrixArray) {
            ArraysSubMatrixImpl.SubMatrixArray sma = (ArraysSubMatrixImpl.SubMatrixArray)((Object)dest);
            if (dest.length() < 1024L || src.length() < dest.length()) {
                return false;
            }
            Matrix<UpdatableArray> baseMatrix = sma.baseMatrix().cast(UpdatableArray.class);
            if (!baseMatrix.isTiled()) {
                return false;
            }
            if (baseMatrix.dimCount() == 1) {
                return false;
            }
            long[] dimensions = sma.dimensions();
            long[] destPosition = sma.from();
            long[] srcPosition = new long[dimensions.length];
            return new ToTiled(baseMatrix, Matrices.matrixAtSubArray(src, 0L, dimensions), sma.continuationMode(), Matrix.ContinuationMode.NONE, destPosition, srcPosition, dimensions).copySubMatrix(context);
        }
        if (src instanceof ArraysSubMatrixImpl.SubMatrixArray) {
            ArraysSubMatrixImpl.SubMatrixArray sma = (ArraysSubMatrixImpl.SubMatrixArray)((Object)src);
            if (src.length() < 1024L || dest.length() < src.length()) {
                return false;
            }
            Matrix<? extends Array> baseMatrix = sma.baseMatrix();
            if (!baseMatrix.isTiled()) {
                return false;
            }
            if (baseMatrix.dimCount() == 1) {
                return false;
            }
            long[] dimensions = sma.dimensions();
            long[] srcPosition = sma.from();
            long[] destPosition = new long[dimensions.length];
            return new FromTiled(Matrices.matrixAtSubArray(dest, 0L, dimensions), baseMatrix, Matrix.ContinuationMode.NONE, sma.continuationMode(), destPosition, srcPosition, dimensions).copySubMatrix(context);
        }
        return false;
    }

    public static boolean copySubMatrixRegion(ArrayContext context, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, Matrix.ContinuationMode continuationMode, Matrices.Region destRegion, long ... shifts) {
        if (!ENABLE_THIS_OPTIMIZATION) {
            return false;
        }
        if (!(destRegion instanceof Matrices.Hyperparallelepiped)) {
            return false;
        }
        int n = destRegion.n();
        if (dest.dimCount() != n || src.dimCount() != n) {
            return false;
        }
        if (!src.isTiled() && !dest.isTiled()) {
            return false;
        }
        if (n == 1) {
            return false;
        }
        long[] dimensions = new long[n];
        long[] destPosition = new long[n];
        long[] srcPosition = new long[n];
        for (int k = 0; k < n; ++k) {
            IRange range = destRegion.coordRange(k);
            dimensions[k] = range.size();
            destPosition[k] = range.min();
            srcPosition[k] = shifts.length > k ? destPosition[k] - shifts[k] : destPosition[k];
        }
        if (dest.isTiled()) {
            return new ToTiled(dest, src, continuationMode, continuationMode, destPosition, srcPosition, dimensions).copySubMatrix(context);
        }
        if (src.isTiled()) {
            return new FromTiled(dest, src, continuationMode, continuationMode, destPosition, srcPosition, dimensions).copySubMatrix(context);
        }
        throw new AssertionError((Object)"Mutable isTiled!");
    }

    boolean copySubMatrix(ArrayContext context) {
        if (this.processingDeclined) {
            return false;
        }
        if (this.nothingToDo) {
            return true;
        }
        long tileCount = this.tileEnumerator.size();
        if (tileCount <= 1L) {
            return false;
        }
        long[] positionInTiled = this.isCopierToTiled ? this.destPosition : this.srcPosition;
        long[] tileIndexes = new long[this.n];
        long[] tilePartPos = new long[this.n];
        long[] tilePartDim = new long[this.n];
        long[] work = new long[this.n];
        long readyCount = 0L;
        long totalCount = Arrays.longMul(this.dimensions);
        for (long tileIndex = 0L; tileIndex < tileCount; ++tileIndex) {
            this.tileEnumerator.coordinates(tileIndex, tileIndexes);
            boolean continuousSubArray = true;
            long tileSize = 1L;
            long dimMul = 1L;
            long tilePosIndex = 0L;
            for (int k = 0; k < this.n; ++k) {
                long i = tileIndexes[k];
                long tileFrom = (i + this.tileStartIndexes[k]) * this.tileDimensions[k];
                long tileTo = tileFrom + this.tileDimensions[k];
                long partFrom = tileFrom;
                long partTo = tileTo;
                long dim = this.tileParent.dim(k);
                if (i == 0L) {
                    partFrom = positionInTiled[k];
                    if (k < this.n - 1 && partFrom != tileFrom) {
                        continuousSubArray = false;
                    }
                }
                if (i == this.tileCounts[k] - 1L) {
                    partTo = positionInTiled[k] + this.dimensions[k];
                    tileTo = Math.min(tileTo, dim);
                    if (k < this.n - 1 && partTo != tileTo) {
                        continuousSubArray = false;
                    }
                }
                if (partFrom > partTo) {
                    throw new AssertionError((Object)("k=" + k + ", partFrom..partTo=" + partFrom + ".." + partTo + ", i=" + i + ", tileStartIndexes[k]=" + this.tileStartIndexes[k] + ", positionInTiled[k]=" + positionInTiled[k] + ", dimensions[k]=" + this.dimensions[k] + ", tilePartDim[k]=" + this.tileDimensions[k] + ", tilePartDim={" + JArrays.toString(this.tileDimensions, ",", 200) + "}"));
                }
                if (partFrom < 0L || partTo > dim) {
                    continuousSubArray = false;
                }
                tilePartPos[k] = partFrom;
                tilePartDim[k] = partTo - partFrom;
                tilePosIndex += partFrom * dimMul;
                dimMul *= dim;
                tileSize *= tilePartDim[k];
            }
            long translatedTilePosIndex = continuousSubArray ? this.tilingIndexer.translate(tilePosIndex) : -1L;
            this.copyTileOrPartOfTile(tilePartPos, tilePartDim, work, translatedTilePosIndex, tileSize);
            if (context != null) {
                context.checkInterruptionAndUpdateProgress(this.dest.elementType(), readyCount, totalCount);
            }
            assert ((readyCount += tileSize) <= totalCount);
        }
        return true;
    }

    abstract void copyTileOrPartOfTile(long[] var1, long[] var2, long[] var3, long var4, long var6);

    private static class ToTiled
    extends ArraysSubMatrixCopier {
        private ToTiled(Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, Matrix.ContinuationMode destContinuationMode, Matrix.ContinuationMode srcContinuationMode, long[] destPosition, long[] srcPosition, long[] dimensions) {
            super(dest, src, destContinuationMode, srcContinuationMode, destPosition, srcPosition, dimensions, true);
        }

        @Override
        void copyTileOrPartOfTile(long[] partPos, long[] partDim, long[] workMemoryForSrcPos, long partIndexInTheBaseIfItIsContinuousSubArrayOfTheBase, long partSize) {
            for (int k = 0; k < partDim.length; ++k) {
                workMemoryForSrcPos[k] = this.srcPosition[k] + partPos[k] - this.destPosition[k];
            }
            UpdatableArray destArray = ENABLE_CONTINUOUS_OPTIMIZATION_FOR_DEST && partIndexInTheBaseIfItIsContinuousSubArrayOfTheBase != -1L ? (UpdatableArray)this.tileParent.array().subArr(partIndexInTheBaseIfItIsContinuousSubArrayOfTheBase, partSize) : (UpdatableArray)this.dest.subMatr(partPos, partDim).array();
            Object srcArray = this.src.subMatr(workMemoryForSrcPos, partDim, this.srcContinuationMode).array();
            AbstractArray.defaultCopyWithoutOptimizations(destArray, srcArray);
        }
    }

    private static class FromTiled
    extends ArraysSubMatrixCopier {
        private FromTiled(Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, Matrix.ContinuationMode destContinuationMode, Matrix.ContinuationMode srcContinuationMode, long[] destPosition, long[] srcPosition, long[] dimensions) {
            super(dest, src, destContinuationMode, srcContinuationMode, destPosition, srcPosition, dimensions, false);
        }

        @Override
        void copyTileOrPartOfTile(long[] partPos, long[] partDim, long[] workMemoryForDestPos, long partIndexInTheBaseIfItIsContinuousSubArrayOfTheBase, long partSize) {
            for (int k = 0; k < partDim.length; ++k) {
                workMemoryForDestPos[k] = this.destPosition[k] + partPos[k] - this.srcPosition[k];
            }
            UpdatableArray destArray = (UpdatableArray)this.dest.subMatr(workMemoryForDestPos, partDim).array();
            Object srcArray = ENABLE_CONTINUOUS_OPTIMIZATION_FOR_SRC && partIndexInTheBaseIfItIsContinuousSubArrayOfTheBase != -1L ? this.tileParent.array().subArr(partIndexInTheBaseIfItIsContinuousSubArrayOfTheBase, partSize) : this.src.subMatr(partPos, partDim, this.srcContinuationMode).array();
            AbstractArray.defaultCopyWithoutOptimizations(destArray, srcArray);
        }
    }
}

