/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Locale;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.math.IRange;

abstract class ArraysMatrixRegionCopier {
    private static final boolean OPTIMIZE_POLYGON_2D = true;
    private static final boolean DEBUG_OPTIMIZE_POLYGON_2D = InternalUtils.getBooleanProperty("net.algart.arrays.ArraysMatrixRegionCopier.debugOptimizePolygon2D", false);
    private static final int MINIMAL_VERTICES_COUNT_TO_OPTIMIZE_POLYGON_2D = 3;
    private static final int MAXIMAL_MEMORY_TO_OPTIMIZE_POLYGON_2D = 0x8000000;
    private static final long OUTSIDE_SRC_INDEX = -1L;
    private final ArrayContext context;
    private final Matrix<? extends UpdatableArray> dest;
    private final Matrix<? extends Array> src;
    private final UpdatableArray destArray;
    private final Array srcArray;
    final Object destJArray;
    private final Object srcJArray;
    final int destJArrayOffset;
    private final int srcJArrayOffset;
    private final long destDimX;
    private final long srcDimX;
    final long destDimY;
    private final long[] shifts;
    private final long[] srcCoordinates;
    private final long[] destCoordinates;
    private final boolean mustBeInside;
    private long copiedElementsCount;
    private long lastCopiedElementsCount;
    private long currentProgress;
    private long totalProgress;
    private long lastProgressTime = Long.MIN_VALUE;

    private ArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, boolean mustBeInside) {
        this.context = context;
        this.dest = dest;
        this.src = src;
        this.destArray = dest.array();
        this.srcArray = src.array();
        this.destJArray = Arrays.javaArrayInternal(this.destArray);
        this.srcJArray = Arrays.javaArrayInternal(this.srcArray);
        this.destJArrayOffset = this.destJArray == null ? -1 : Arrays.javaArrayOffsetInternal(this.destArray);
        this.srcJArrayOffset = this.srcJArray == null ? -1 : Arrays.javaArrayOffsetInternal(this.srcArray);
        this.destDimX = dest.dimX();
        this.srcDimX = src.dimX();
        this.destDimY = dest.dimY();
        this.shifts = shifts;
        this.srcCoordinates = new long[maxNumberOfDimensions];
        this.destCoordinates = new long[maxNumberOfDimensions];
        this.mustBeInside = mustBeInside;
    }

    public static ArraysMatrixRegionCopier getInstance(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, Object outsideValue, boolean mustBeInside) {
        assert (dest != null);
        assert (src != null);
        assert (maxNumberOfDimensions > 0);
        outsideValue = Matrices.castOutsideValue(outsideValue, dest.array());
        Class<?> elementType = dest.elementType();
        if (elementType == Boolean.TYPE) {
            return new BitArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, (Boolean)outsideValue, mustBeInside);
        }
        if (elementType == Character.TYPE) {
            return new CharArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, ((Character)outsideValue).charValue(), mustBeInside);
        }
        if (elementType == Byte.TYPE) {
            return new ByteArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, (Byte)outsideValue, mustBeInside);
        }
        if (elementType == Short.TYPE) {
            return new ShortArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, (Short)outsideValue, mustBeInside);
        }
        if (elementType == Integer.TYPE) {
            return new IntArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, (Integer)outsideValue, mustBeInside);
        }
        if (elementType == Long.TYPE) {
            return new LongArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, (Long)outsideValue, mustBeInside);
        }
        if (elementType == Float.TYPE) {
            return new FloatArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, ((Float)outsideValue).floatValue(), mustBeInside);
        }
        if (elementType == Double.TYPE) {
            return new DoubleArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, (Double)outsideValue, mustBeInside);
        }
        return new ObjectArraysMatrixRegionCopier(context, maxNumberOfDimensions, dest, src, shifts, outsideValue, mustBeInside);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(Matrices.Region destRegion) {
        this.initializeProgress(destRegion);
        boolean destFullyInside = true;
        boolean srcFullyInside = true;
        boolean srcFullyOutside = false;
        int n = destRegion.n();
        for (int k = 0; k < n; ++k) {
            long srcMax;
            IRange destRange = destRegion.coordRange(k);
            long destMin = destRange.min();
            long destMax = destRange.max();
            if (destMin < 0L || destMax >= this.dest.dim(k)) {
                destFullyInside = false;
            }
            long srcMin = this.shifts.length > k ? destMin - this.shifts[k] : destMin;
            long l = srcMax = this.shifts.length > k ? destMax - this.shifts[k] : destMax;
            if (srcMin < 0L || srcMax >= this.src.dim(k)) {
                srcFullyInside = false;
            }
            if (srcMin < this.src.dim(k) && srcMax >= 0L) continue;
            srcFullyOutside = true;
        }
        JArrayPool bufferPool = this.destJArray != null || this.srcJArray != null ? null : (this.destArray instanceof CharArray ? ArraysFuncImpl.CHAR_BUFFERS : (this.destArray instanceof ByteArray ? ArraysFuncImpl.BYTE_BUFFERS : (this.destArray instanceof ShortArray ? ArraysFuncImpl.SHORT_BUFFERS : (this.destArray instanceof IntArray ? ArraysFuncImpl.INT_BUFFERS : (this.destArray instanceof LongArray ? ArraysFuncImpl.LONG_BUFFERS : (this.destArray instanceof FloatArray ? ArraysFuncImpl.FLOAT_BUFFERS : (this.destArray instanceof DoubleArray ? ArraysFuncImpl.DOUBLE_BUFFERS : null)))))));
        Object buf = bufferPool == null ? null : bufferPool.requestArray();
        try {
            SegmentCopier segmentCopier;
            SegmentCopier segmentCopier2 = destFullyInside && srcFullyInside ? new UncheckedSegmentCopier(buf) : (this.mustBeInside ? new CheckedSegmentCopier(buf) : (this.destCoordinates.length == 2 && srcFullyOutside ? (destFullyInside ? this.getUncheckedSegmentFiller2D() : this.getContinuedSegmentFiller2D()) : (segmentCopier = new ContinuedSegmentCopier(buf))));
            if (destRegion instanceof Matrices.Polygon2D && this.processPolygon2D((Matrices.Polygon2D)destRegion, segmentCopier)) {
                return;
            }
            this.processRecursively(destRegion, segmentCopier);
        }
        finally {
            if (bufferPool != null) {
                bufferPool.releaseArray(buf);
            }
        }
    }

    abstract void copyElement(long var1, long var3);

    abstract void fill(long var1, long var3);

    UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
        return new UncheckedSegmentFiller2D();
    }

    ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
        return new ContinuedSegmentFiller2D();
    }

    private void processRecursively(Matrices.Region destRegion, SegmentCopier segmentCopier) {
        int n = destRegion.n();
        if (n == 1) {
            segmentCopier.copySegment(destRegion);
        } else {
            IRange destRange = destRegion.coordRange(n - 1);
            long destMin = destRange.min();
            long destMax = destRange.max();
            if (!this.mustBeInside && (destMin = Math.max(destMin, 0L)) > (destMax = Math.min(destMax, this.dest.dim(n - 1) - 1L))) {
                return;
            }
            Matrices.Region.MutableIRange mutableCoordRange = new Matrices.Region.MutableIRange();
            for (long k = destMin; k <= destMax; ++k) {
                this.destCoordinates[n - 1] = k;
                long l = this.srcCoordinates[n - 1] = this.shifts.length >= n ? k - this.shifts[n - 1] : k;
                if (destRegion.sectionIsUninterruptedSegment(k)) {
                    if (n != 2) {
                        throw new AssertionError((Object)("Invalid implementation of " + String.valueOf(destRegion.getClass()) + ": sectionIsUninterruptedSegment must return true only for n=2 dimensions, but n=" + n));
                    }
                    if (!destRegion.segmentSectionAtLastCoordinate(mutableCoordRange, k)) continue;
                    segmentCopier.copyUninterruptedSegment(mutableCoordRange.min, mutableCoordRange.max);
                    continue;
                }
                for (Matrices.Region section : destRegion.sectionAtLastCoordinate(k)) {
                    if (section.n != n - 1) {
                        throw new AssertionError((Object)("Invalid implementation of " + String.valueOf(destRegion.getClass()) + ": number of dimensions of its section is " + section.n + " instead of " + n + "-1"));
                    }
                    this.processRecursively(section, segmentCopier);
                }
            }
        }
    }

    private boolean processPolygon2D(Matrices.Polygon2D destPolygon, SegmentCopier segmentCopier) {
        long t5;
        double vy2;
        double vy1;
        int k;
        assert (destPolygon.n() == 2);
        IRange yRange = destPolygon.coordRange(1);
        long yMin = yRange.min();
        long yMax = yRange.max();
        if (!this.mustBeInside && (yMin = Math.max(yMin, 0L)) > (yMax = Math.min(yMax, this.destDimY - 1L))) {
            return true;
        }
        if (yMax - yMin + 1L > Integer.MAX_VALUE) {
            if (DEBUG_OPTIMIZE_POLYGON_2D) {
                System.out.println("amrc Too large polygon in y-dimension (>Integer.MAX_VALUE); switching to more simple algorithm to avoid OutOfMemory error");
            }
            return false;
        }
        int m = destPolygon.verticesCount();
        if (m < 3) {
            if (DEBUG_OPTIMIZE_POLYGON_2D) {
                System.out.println("amrc Very simple polygon (" + m + " < 3 vertices); switching to more simple algorithm");
            }
            return false;
        }
        long t1 = DEBUG_OPTIMIZE_POLYGON_2D ? System.nanoTime() : 0L;
        int[] intersectionsCounts = new int[(int)(yMax - yMin + 1L)];
        boolean increasingY = false;
        for (k = m - 1; k >= 0; --k) {
            vy1 = destPolygon.vertexY(k);
            if (vy1 < (vy2 = destPolygon.vertexY(k < m - 1 ? k + 1 : 0))) {
                increasingY = true;
                break;
            }
            if (!(vy1 > vy2)) continue;
            increasingY = false;
            break;
        }
        for (k = 0; k < m; ++k) {
            int yIndex;
            long sectionY;
            boolean vy1Integer;
            vy1 = destPolygon.vertexY(k);
            vy2 = destPolygon.vertexY(k < m - 1 ? k + 1 : 0);
            boolean bl = vy1Integer = vy1 == StrictMath.floor(vy1);
            if (vy1 < vy2) {
                long vyMin = (long)StrictMath.ceil(vy1);
                long vyMax = (long)StrictMath.floor(vy2);
                if (vy1Integer && increasingY) {
                    ++vyMin;
                }
                increasingY = true;
                vyMin = Math.max(vyMin, yMin);
                vyMax = Math.min(vyMax, yMax);
                for (sectionY = vyMin; sectionY <= vyMax; ++sectionY) {
                    int n = yIndex = (int)(sectionY - yMin);
                    intersectionsCounts[n] = intersectionsCounts[n] + 1;
                }
                continue;
            }
            if (!(vy1 > vy2)) continue;
            long vyMax = (long)StrictMath.floor(vy1);
            long vyMin = (long)StrictMath.ceil(vy2);
            if (vy1Integer && !increasingY) {
                --vyMax;
            }
            increasingY = false;
            vyMin = Math.max(vyMin, yMin);
            for (sectionY = vyMax = Math.min(vyMax, yMax); sectionY >= vyMin; --sectionY) {
                int n = yIndex = (int)(sectionY - yMin);
                intersectionsCounts[n] = intersectionsCounts[n] + 1;
            }
        }
        for (int i = 0; i < intersectionsCounts.length; ++i) {
            if (intersectionsCounts[i] % 2 != 0) {
                throw new AssertionError((Object)("Odd number of intersection at horizontal #" + (yMin + (long)i) + ", line " + i + ": it must not occur"));
            }
        }
        long t2 = DEBUG_OPTIMIZE_POLYGON_2D ? System.nanoTime() : 0L;
        int[] intersectionsIndexes = intersectionsCounts;
        for (int i = 1; i < intersectionsIndexes.length; ++i) {
            int n = i;
            intersectionsIndexes[n] = intersectionsIndexes[n] + intersectionsIndexes[i - 1];
            if (intersectionsIndexes[i] >= 0 && intersectionsIndexes[i] <= 0x1000000) continue;
            if (DEBUG_OPTIMIZE_POLYGON_2D) {
                System.out.println("amrc Very complex polygon (" + m + " vertices): it consists of too large number of solid lines; switching to more simple algorithm to avoid OutOfMemory error");
            }
            return false;
        }
        double[] intersections = new double[intersectionsIndexes[intersectionsIndexes.length - 1]];
        if (intersections.length % 2 != 0) {
            throw new AssertionError((Object)"Odd number of intersections of the polygon and horizontals: it's impossible");
        }
        boolean hasHorizontalEdges = false;
        for (int k2 = 0; k2 < m; ++k2) {
            double x;
            int yIndex;
            long sectionY;
            double rel;
            boolean vy1Integer;
            double vx1 = destPolygon.vertexX(k2);
            double vy12 = destPolygon.vertexY(k2);
            double vx2 = destPolygon.vertexX(k2 < m - 1 ? k2 + 1 : 0);
            double vy22 = destPolygon.vertexY(k2 < m - 1 ? k2 + 1 : 0);
            boolean bl = vy1Integer = vy12 == StrictMath.floor(vy12);
            if (vy12 < vy22) {
                long vyMin = (long)StrictMath.ceil(vy12);
                long vyMax = (long)StrictMath.floor(vy22);
                if (vy1Integer && increasingY) {
                    ++vyMin;
                }
                increasingY = true;
                vyMin = Math.max(vyMin, yMin);
                vyMax = Math.min(vyMax, yMax);
                rel = (vx2 - vx1) / (vy22 - vy12);
                for (sectionY = vyMin; sectionY <= vyMax; ++sectionY) {
                    yIndex = (int)(sectionY - yMin);
                    x = vx1 + ((double)sectionY - vy12) * rel;
                    int n = yIndex;
                    int n2 = intersectionsIndexes[n] - 1;
                    intersectionsIndexes[n] = n2;
                    intersections[n2] = x;
                }
                continue;
            }
            if (vy12 > vy22) {
                long vyMax = (long)StrictMath.floor(vy12);
                long vyMin = (long)StrictMath.ceil(vy22);
                if (vy1Integer && !increasingY) {
                    --vyMax;
                }
                increasingY = false;
                vyMin = Math.max(vyMin, yMin);
                vyMax = Math.min(vyMax, yMax);
                rel = (vx2 - vx1) / (vy22 - vy12);
                for (sectionY = vyMax; sectionY >= vyMin; --sectionY) {
                    yIndex = (int)(sectionY - yMin);
                    x = vx1 + ((double)sectionY - vy12) * rel;
                    int n = yIndex;
                    int n3 = intersectionsIndexes[n] - 1;
                    intersectionsIndexes[n] = n3;
                    intersections[n3] = x;
                }
                continue;
            }
            hasHorizontalEdges = true;
        }
        if (intersectionsIndexes[0] != 0) {
            throw new AssertionError((Object)"Now the indexes must point to the begin of each block in intersections array");
        }
        long t3 = DEBUG_OPTIMIZE_POLYGON_2D ? System.nanoTime() : 0L;
        long segmentCount = 0L;
        if (hasHorizontalEdges) {
            for (int k3 = 0; k3 < m; ++k3) {
                long maxX;
                long minX;
                long i;
                double vy23;
                double vy13 = destPolygon.vertexY(k3);
                if (vy13 != (vy23 = destPolygon.vertexY(k3 < m - 1 ? k3 + 1 : 0)) || vy13 != StrictMath.floor(vy13) || (i = (long)vy13) < yMin || i > yMax) continue;
                double vx1 = destPolygon.vertexX(k3);
                double vx2 = destPolygon.vertexX(k3 < m - 1 ? k3 + 1 : 0);
                this.destCoordinates[1] = i;
                long l = this.srcCoordinates[1] = this.shifts.length >= 2 ? i - this.shifts[1] : i;
                if (vx1 < vx2) {
                    minX = (long)StrictMath.ceil(vx1);
                    maxX = (long)StrictMath.floor(vx2);
                } else {
                    minX = (long)StrictMath.ceil(vx2);
                    maxX = (long)StrictMath.floor(vx1);
                }
                if (minX > maxX) continue;
                segmentCopier.copyUninterruptedSegment(minX, maxX);
                ++segmentCount;
            }
        }
        long t4 = DEBUG_OPTIMIZE_POLYGON_2D ? System.nanoTime() : 0L;
        for (long i = yMin; i <= yMax; ++i) {
            int toIndex;
            int yIndex = (int)(i - yMin);
            int fromIndex = intersectionsIndexes[yIndex];
            int n = toIndex = i == yMax ? intersections.length : intersectionsIndexes[yIndex + 1];
            if (fromIndex % 2 != 0 || toIndex % 2 != 0) {
                throw new AssertionError((Object)("Odd indexes at horizontal #" + yIndex + ", line " + i + ": it's impossible"));
            }
            java.util.Arrays.sort(intersections, fromIndex, toIndex);
            this.destCoordinates[1] = i;
            this.srcCoordinates[1] = this.shifts.length >= 2 ? i - this.shifts[1] : i;
            for (int j = fromIndex; j < toIndex; j += 2) {
                long maxX;
                long minX = (long)StrictMath.ceil(intersections[j]);
                if (minX > (maxX = (long)StrictMath.floor(intersections[j + 1]))) continue;
                segmentCopier.copyUninterruptedSegment(minX, maxX);
                ++segmentCount;
            }
        }
        long l = t5 = DEBUG_OPTIMIZE_POLYGON_2D ? System.nanoTime() : 0L;
        if (DEBUG_OPTIMIZE_POLYGON_2D) {
            System.out.printf(Locale.US, "amrc Filling polygon with %d vertices, %d horizontals, %d intersections in %.3f ms: %.3f ms 1st pass, %.3f ms 2nd pass, %.3f ms filling horizontal edges%s + %.3f ms main filling loop (%d segments, %.4f mcs/segment)%n", m, intersectionsCounts.length, intersections.length, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, hasHorizontalEdges ? "" : " (skipped)", (double)(t5 - t4) * 1.0E-6, segmentCount, (double)(t5 - t3) * 0.001 / (double)segmentCount);
        }
        return true;
    }

    private void initializeProgress(Matrices.Region destRegion) {
        this.copiedElementsCount = 0L;
        this.lastCopiedElementsCount = 0L;
        this.currentProgress = 0L;
        this.totalProgress = 1L;
        int n = destRegion.n();
        for (int k = 0; k < n; ++k) {
            long size = destRegion.coordRange(k).size();
            long product = Arrays.longMul(this.totalProgress, size);
            if (product == Long.MIN_VALUE) {
                this.totalProgress = Long.MAX_VALUE;
                break;
            }
            this.totalProgress = product;
        }
    }

    private void updateProgressForSegment(IRange destRange) {
        long size = destRange.size();
        this.currentProgress = this.currentProgress + size < 0L ? Long.MAX_VALUE : (this.currentProgress += size);
        if (this.context != null && this.copiedElementsCount - this.lastCopiedElementsCount > 4096L) {
            this.lastCopiedElementsCount = this.copiedElementsCount;
            long t = System.currentTimeMillis();
            if (this.lastProgressTime == Long.MIN_VALUE || t - this.lastProgressTime > 250L) {
                this.lastProgressTime = t;
                this.context.checkInterruptionAndUpdateProgress(this.srcArray.elementType(), this.currentProgress, this.totalProgress);
            }
        }
    }

    private static class BitArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableBitArray destBitArray;
        private final BitArray srcBitArray;
        private final boolean outsideValue;

        private BitArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, boolean outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destBitArray = (UpdatableBitArray)dest.array();
            this.srcBitArray = (BitArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destBitArray.setBit(destIndex, srcIndex == -1L ? this.outsideValue : this.srcBitArray.getBit(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destBitArray.fill(position, count, this.outsideValue);
        }

        @Override
        UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectBitArraysUncheckedSegmentFiller2D(this, (long[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getUncheckedSegmentFiller2D();
        }

        @Override
        ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectBitArraysContinuedSegmentFiller2D(this, (long[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getContinuedSegmentFiller2D();
        }
    }

    private static class CharArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableCharArray destCharArray;
        private final CharArray srcCharArray;
        private final char outsideValue;

        private CharArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, char outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destCharArray = (UpdatableCharArray)dest.array();
            this.srcCharArray = (CharArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destCharArray.setChar(destIndex, srcIndex == -1L ? this.outsideValue : this.srcCharArray.getChar(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destCharArray.fill(position, count, this.outsideValue);
        }

        @Override
        UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectCharArraysUncheckedSegmentFiller2D((char[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getUncheckedSegmentFiller2D();
        }

        @Override
        ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectCharArraysContinuedSegmentFiller2D((char[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getContinuedSegmentFiller2D();
        }
    }

    private static class ByteArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableByteArray destByteArray;
        private final ByteArray srcByteArray;
        private final byte outsideValue;

        private ByteArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, byte outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destByteArray = (UpdatableByteArray)dest.array();
            this.srcByteArray = (ByteArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destByteArray.setByte(destIndex, srcIndex == -1L ? this.outsideValue : (byte)this.srcByteArray.getByte(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destByteArray.fill(position, count, this.outsideValue);
        }

        @Override
        UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectByteArraysUncheckedSegmentFiller2D((byte[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getUncheckedSegmentFiller2D();
        }

        @Override
        ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectByteArraysContinuedSegmentFiller2D((byte[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getContinuedSegmentFiller2D();
        }
    }

    private static class ShortArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableShortArray destShortArray;
        private final ShortArray srcShortArray;
        private final short outsideValue;

        private ShortArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, short outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destShortArray = (UpdatableShortArray)dest.array();
            this.srcShortArray = (ShortArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destShortArray.setShort(destIndex, srcIndex == -1L ? this.outsideValue : (short)this.srcShortArray.getShort(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destShortArray.fill(position, count, this.outsideValue);
        }

        @Override
        UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectShortArraysUncheckedSegmentFiller2D((short[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getUncheckedSegmentFiller2D();
        }

        @Override
        ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectShortArraysContinuedSegmentFiller2D((short[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getContinuedSegmentFiller2D();
        }
    }

    private static class IntArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableIntArray destIntArray;
        private final IntArray srcIntArray;
        private final int outsideValue;

        private IntArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, int outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destIntArray = (UpdatableIntArray)dest.array();
            this.srcIntArray = (IntArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destIntArray.setInt(destIndex, srcIndex == -1L ? this.outsideValue : this.srcIntArray.getInt(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destIntArray.fill(position, count, this.outsideValue);
        }

        @Override
        UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectIntArraysUncheckedSegmentFiller2D((int[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getUncheckedSegmentFiller2D();
        }

        @Override
        ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectIntArraysContinuedSegmentFiller2D((int[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getContinuedSegmentFiller2D();
        }
    }

    private static class LongArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableLongArray destLongArray;
        private final LongArray srcLongArray;
        private final long outsideValue;

        private LongArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, long outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destLongArray = (UpdatableLongArray)dest.array();
            this.srcLongArray = (LongArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destLongArray.setLong(destIndex, srcIndex == -1L ? this.outsideValue : this.srcLongArray.getLong(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destLongArray.fill(position, count, this.outsideValue);
        }

        @Override
        UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectLongArraysUncheckedSegmentFiller2D((long[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getUncheckedSegmentFiller2D();
        }

        @Override
        ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectLongArraysContinuedSegmentFiller2D((long[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getContinuedSegmentFiller2D();
        }
    }

    private static class FloatArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableFloatArray destFloatArray;
        private final FloatArray srcFloatArray;
        private final float outsideValue;

        private FloatArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, float outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destFloatArray = (UpdatableFloatArray)dest.array();
            this.srcFloatArray = (FloatArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destFloatArray.setFloat(destIndex, srcIndex == -1L ? this.outsideValue : this.srcFloatArray.getFloat(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destFloatArray.fill(position, count, this.outsideValue);
        }

        @Override
        UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectFloatArraysUncheckedSegmentFiller2D((float[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getUncheckedSegmentFiller2D();
        }

        @Override
        ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectFloatArraysContinuedSegmentFiller2D((float[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getContinuedSegmentFiller2D();
        }
    }

    private static class DoubleArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableDoubleArray destDoubleArray;
        private final DoubleArray srcDoubleArray;
        private final double outsideValue;

        private DoubleArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, double outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destDoubleArray = (UpdatableDoubleArray)dest.array();
            this.srcDoubleArray = (DoubleArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destDoubleArray.setDouble(destIndex, srcIndex == -1L ? this.outsideValue : this.srcDoubleArray.getDouble(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destDoubleArray.fill(position, count, this.outsideValue);
        }

        @Override
        UncheckedSegmentFiller2D getUncheckedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectDoubleArraysUncheckedSegmentFiller2D((double[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getUncheckedSegmentFiller2D();
        }

        @Override
        ContinuedSegmentFiller2D getContinuedSegmentFiller2D() {
            if (this.destJArray != null) {
                return new DirectDoubleArraysContinuedSegmentFiller2D((double[])this.destJArray, this.destJArrayOffset, this.outsideValue);
            }
            return super.getContinuedSegmentFiller2D();
        }
    }

    private static class ObjectArraysMatrixRegionCopier
    extends ArraysMatrixRegionCopier {
        private final UpdatableObjectArray<Object> destObjectArray;
        private final ObjectArray<?> srcObjectArray;
        private final Object outsideValue;

        private ObjectArraysMatrixRegionCopier(ArrayContext context, int maxNumberOfDimensions, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, long[] shifts, Object outsideValue, boolean mustBeInside) {
            super(context, maxNumberOfDimensions, dest, src, shifts, mustBeInside);
            this.destObjectArray = ((UpdatableObjectArray)dest.array()).cast(Object.class);
            this.srcObjectArray = (ObjectArray)src.array();
            this.outsideValue = outsideValue;
        }

        @Override
        void copyElement(long destIndex, long srcIndex) {
            this.destObjectArray.setElement(destIndex, srcIndex == -1L ? this.outsideValue : this.srcObjectArray.getElement(srcIndex));
        }

        @Override
        void fill(long position, long count) {
            this.destObjectArray.fill(position, count, this.outsideValue);
        }
    }

    private class UncheckedSegmentCopier
    extends SegmentCopier {
        UncheckedSegmentCopier(Object workJArray) {
            super(workJArray);
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            ArraysMatrixRegionCopier.this.destCoordinates[0] = destMin;
            long srcMin = ArraysMatrixRegionCopier.this.shifts.length >= 1 ? destMin - ArraysMatrixRegionCopier.this.shifts[0] : destMin;
            long destIndex = ArraysMatrixRegionCopier.this.dest.uncheckedIndex(ArraysMatrixRegionCopier.this.destCoordinates);
            assert (destMax >= 0L && destMax < ArraysMatrixRegionCopier.this.destDimX);
            long len = destMax - destMin + 1L;
            ArraysMatrixRegionCopier.this.copiedElementsCount += len;
            ArraysMatrixRegionCopier.this.srcCoordinates[0] = srcMin;
            long srcIndex = ArraysMatrixRegionCopier.this.src.uncheckedIndex(ArraysMatrixRegionCopier.this.srcCoordinates);
            this.copyRange(destIndex, srcIndex, len);
        }

        @Override
        void copyInterruptedSegment(Matrices.Region destRegion, long destMin, long destMax) {
            long srcX;
            ArraysMatrixRegionCopier.this.destCoordinates[0] = destMin;
            long destIndex = ArraysMatrixRegionCopier.this.dest.uncheckedIndex(ArraysMatrixRegionCopier.this.destCoordinates);
            long destX = destMin;
            ArraysMatrixRegionCopier.this.srcCoordinates[0] = srcX = ArraysMatrixRegionCopier.this.shifts.length >= 1 ? destX - ArraysMatrixRegionCopier.this.shifts[0] : destX;
            long srcIndex = ArraysMatrixRegionCopier.this.src.uncheckedIndex(ArraysMatrixRegionCopier.this.srcCoordinates);
            while (destX <= destMax) {
                ArraysMatrixRegionCopier.this.destCoordinates[0] = destX;
                if (destRegion.contains(ArraysMatrixRegionCopier.this.destCoordinates)) {
                    ArraysMatrixRegionCopier.this.copyElement(destIndex, srcIndex);
                    ++ArraysMatrixRegionCopier.this.copiedElementsCount;
                }
                ++destX;
                ++srcX;
                ++destIndex;
                ++srcIndex;
            }
        }
    }

    private class CheckedSegmentCopier
    extends SegmentCopier {
        CheckedSegmentCopier(Object workJArray) {
            super(workJArray);
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            long destIndex;
            ArraysMatrixRegionCopier.this.destCoordinates[0] = destMin;
            long srcMin = ArraysMatrixRegionCopier.this.shifts.length >= 1 ? destMin - ArraysMatrixRegionCopier.this.shifts[0] : destMin;
            try {
                destIndex = ArraysMatrixRegionCopier.this.dest.index(ArraysMatrixRegionCopier.this.destCoordinates);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("Destination region, " + e.getMessage());
            }
            assert (destMax >= 0L) : "destMin is correct " + destMin + ", but destMax is negative " + destMax;
            if (destMax >= ArraysMatrixRegionCopier.this.destDimX) {
                throw new IndexOutOfBoundsException("Destination region, index (" + destMax + ") >= dim(0) (" + ArraysMatrixRegionCopier.this.destDimX + ")");
            }
            long len = destMax - destMin + 1L;
            long srcMax = srcMin + destMax - destMin;
            ArraysMatrixRegionCopier.this.copiedElementsCount += len;
            ArraysMatrixRegionCopier.this.srcCoordinates[0] = srcMin;
            long srcIndex = ArraysMatrixRegionCopier.this.src.index(ArraysMatrixRegionCopier.this.srcCoordinates);
            if (srcMax >= ArraysMatrixRegionCopier.this.srcDimX) {
                throw new IndexOutOfBoundsException("Source region, index (" + srcMax + ") >= dim(0) (" + ArraysMatrixRegionCopier.this.srcDimX + ")");
            }
            this.copyRange(destIndex, srcIndex, len);
        }

        @Override
        void copyInterruptedSegment(Matrices.Region destRegion, long destMin, long destMax) {
            long srcX;
            long destIndex;
            long destX = destMin;
            while (destX <= destMax) {
                ArraysMatrixRegionCopier.this.destCoordinates[0] = destX++;
                if (destRegion.contains(ArraysMatrixRegionCopier.this.destCoordinates)) break;
            }
            if (destX > destMax) {
                return;
            }
            ArraysMatrixRegionCopier.this.destCoordinates[0] = destX;
            try {
                destIndex = ArraysMatrixRegionCopier.this.dest.index(ArraysMatrixRegionCopier.this.destCoordinates);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("Destination region, " + e.getMessage());
            }
            ArraysMatrixRegionCopier.this.srcCoordinates[0] = srcX = ArraysMatrixRegionCopier.this.shifts.length >= 1 ? destX - ArraysMatrixRegionCopier.this.shifts[0] : destX;
            long srcIndex = ArraysMatrixRegionCopier.this.src.index(ArraysMatrixRegionCopier.this.srcCoordinates);
            while (destX <= destMax) {
                ArraysMatrixRegionCopier.this.destCoordinates[0] = destX;
                if (destRegion.contains(ArraysMatrixRegionCopier.this.destCoordinates)) {
                    if (destX >= ArraysMatrixRegionCopier.this.destDimX) {
                        throw new IndexOutOfBoundsException("Destination region, index (" + destX + (String)(destX < 0L ? ") < 0" : ") >= dim(0) (" + ArraysMatrixRegionCopier.this.destDimX + ")"));
                    }
                    if (srcX >= ArraysMatrixRegionCopier.this.srcDimX) {
                        throw new IndexOutOfBoundsException("Source region, index (" + srcX + (String)(srcX < 0L ? ") < 0" : ") >= dim(0) (" + ArraysMatrixRegionCopier.this.srcDimX + ")"));
                    }
                    ArraysMatrixRegionCopier.this.copyElement(destIndex, srcIndex);
                    ++ArraysMatrixRegionCopier.this.copiedElementsCount;
                }
                ++destX;
                ++srcX;
                ++destIndex;
                ++srcIndex;
            }
        }
    }

    private class UncheckedSegmentFiller2D
    extends ContinuedSegmentCopier {
        UncheckedSegmentFiller2D() {
            super(null);
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            long len = destMax - destMin + 1L;
            ArraysMatrixRegionCopier.this.fill(ArraysMatrixRegionCopier.this.destCoordinates[1] * ArraysMatrixRegionCopier.this.destDimX + destMin, len);
            ArraysMatrixRegionCopier.this.copiedElementsCount += len;
        }
    }

    private class ContinuedSegmentFiller2D
    extends ContinuedSegmentCopier {
        ContinuedSegmentFiller2D() {
            super(null);
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            if (ArraysMatrixRegionCopier.this.destCoordinates[1] < 0L || ArraysMatrixRegionCopier.this.destCoordinates[1] >= ArraysMatrixRegionCopier.this.destDimY) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            long len = destMax - destMin + 1L;
            ArraysMatrixRegionCopier.this.fill(ArraysMatrixRegionCopier.this.destCoordinates[1] * ArraysMatrixRegionCopier.this.destDimX + destMin, len);
        }
    }

    private class ContinuedSegmentCopier
    extends SegmentCopier {
        ContinuedSegmentCopier(Object workJArray) {
            super(workJArray);
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            ArraysMatrixRegionCopier.this.destCoordinates[0] = 0L;
            if (!ArraysMatrixRegionCopier.this.dest.inside(ArraysMatrixRegionCopier.this.destCoordinates)) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            ArraysMatrixRegionCopier.this.destCoordinates[0] = destMin;
            long srcMin = ArraysMatrixRegionCopier.this.shifts.length >= 1 ? destMin - ArraysMatrixRegionCopier.this.shifts[0] : destMin;
            long destIndex = ArraysMatrixRegionCopier.this.dest.index(ArraysMatrixRegionCopier.this.destCoordinates);
            assert (destMax >= 0L && destMax < ArraysMatrixRegionCopier.this.destDimX) : "destMin is " + destMin + ", but destMax is " + destMax;
            long len = destMax - destMin + 1L;
            long srcMax = srcMin + destMax - destMin;
            ArraysMatrixRegionCopier.this.copiedElementsCount += len;
            ArraysMatrixRegionCopier.this.srcCoordinates[0] = 0L;
            if (srcMax < 0L || srcMin >= ArraysMatrixRegionCopier.this.srcDimX || !ArraysMatrixRegionCopier.this.src.inside(ArraysMatrixRegionCopier.this.srcCoordinates)) {
                ArraysMatrixRegionCopier.this.fill(destIndex, len);
                return;
            }
            if (srcMin < 0L) {
                ArraysMatrixRegionCopier.this.fill(destIndex, -srcMin);
                destIndex -= srcMin;
                len += srcMin;
                srcMin = 0L;
            }
            assert (srcMin < ArraysMatrixRegionCopier.this.srcDimX);
            ArraysMatrixRegionCopier.this.srcCoordinates[0] = srcMin;
            long srcIndex = ArraysMatrixRegionCopier.this.src.index(ArraysMatrixRegionCopier.this.srcCoordinates);
            long rear = 0L;
            if (srcMax >= ArraysMatrixRegionCopier.this.srcDimX) {
                rear = srcMax - ArraysMatrixRegionCopier.this.srcDimX + 1L;
                len -= rear;
            }
            this.copyRange(destIndex, srcIndex, len);
            if (rear > 0L) {
                ArraysMatrixRegionCopier.this.fill(destIndex + len, rear);
            }
        }

        @Override
        void copyInterruptedSegment(Matrices.Region destRegion, long destMin, long destMax) {
            ArraysMatrixRegionCopier.this.destCoordinates[0] = 0L;
            if (!ArraysMatrixRegionCopier.this.dest.inside(ArraysMatrixRegionCopier.this.destCoordinates)) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            ArraysMatrixRegionCopier.this.destCoordinates[0] = destMin;
            long destIndex = ArraysMatrixRegionCopier.this.dest.index(ArraysMatrixRegionCopier.this.destCoordinates);
            assert (destMax >= 0L && destMax < ArraysMatrixRegionCopier.this.destDimX) : "destMin is " + destMin + ", but destMax is " + destMax;
            long destX = destMin;
            long srcX = ArraysMatrixRegionCopier.this.shifts.length >= 1 ? destX - ArraysMatrixRegionCopier.this.shifts[0] : destX;
            ArraysMatrixRegionCopier.this.srcCoordinates[0] = 0L;
            if (srcX >= ArraysMatrixRegionCopier.this.srcDimX || !ArraysMatrixRegionCopier.this.src.inside(ArraysMatrixRegionCopier.this.srcCoordinates)) {
                while (destX <= destMax) {
                    ArraysMatrixRegionCopier.this.destCoordinates[0] = destX;
                    if (destRegion.contains(ArraysMatrixRegionCopier.this.destCoordinates)) {
                        ArraysMatrixRegionCopier.this.copyElement(destIndex, -1L);
                        ++ArraysMatrixRegionCopier.this.copiedElementsCount;
                    }
                    ++destX;
                    ++srcX;
                    ++destIndex;
                }
                return;
            }
            while (srcX < 0L && destX <= destMax) {
                ArraysMatrixRegionCopier.this.destCoordinates[0] = destX;
                if (destRegion.contains(ArraysMatrixRegionCopier.this.destCoordinates)) {
                    ArraysMatrixRegionCopier.this.copyElement(destIndex, -1L);
                    ++ArraysMatrixRegionCopier.this.copiedElementsCount;
                }
                ++destX;
                ++srcX;
                ++destIndex;
            }
            if (destX > destMax) {
                return;
            }
            assert (srcX >= 0L && srcX < ArraysMatrixRegionCopier.this.srcDimX);
            ArraysMatrixRegionCopier.this.srcCoordinates[0] = srcX;
            long srcIndex = ArraysMatrixRegionCopier.this.src.index(ArraysMatrixRegionCopier.this.srcCoordinates);
            while (destX <= destMax) {
                ArraysMatrixRegionCopier.this.destCoordinates[0] = destX;
                if (destRegion.contains(ArraysMatrixRegionCopier.this.destCoordinates)) {
                    ArraysMatrixRegionCopier.this.copyElement(destIndex, srcX >= ArraysMatrixRegionCopier.this.srcDimX ? -1L : srcIndex);
                    ++ArraysMatrixRegionCopier.this.copiedElementsCount;
                }
                ++destX;
                ++srcX;
                ++destIndex;
                ++srcIndex;
            }
        }
    }

    abstract class SegmentCopier {
        final Object workJArray;
        final int workJArrayLength;

        SegmentCopier(Object workJArray) {
            this.workJArray = workJArray;
            this.workJArrayLength = workJArray == null ? 0 : java.lang.reflect.Array.getLength(workJArray);
        }

        abstract void copyUninterruptedSegment(long var1, long var3);

        abstract void copyInterruptedSegment(Matrices.Region var1, long var2, long var4);

        final void copySegment(Matrices.Region destRegion) {
            IRange destRange = destRegion.coordRange(0);
            if (destRegion.isRectangular()) {
                this.copyUninterruptedSegment(destRange.min(), destRange.max());
            } else {
                this.copyInterruptedSegment(destRegion, destRange.min(), destRange.max());
            }
            ArraysMatrixRegionCopier.this.updateProgressForSegment(destRange);
        }

        final void copyRange(long destIndex, long srcIndex, long len) {
            if (ArraysMatrixRegionCopier.this.destJArray != null) {
                ArraysMatrixRegionCopier.this.srcArray.getData(srcIndex, ArraysMatrixRegionCopier.this.destJArray, ArraysMatrixRegionCopier.this.destJArrayOffset + (int)destIndex, (int)len);
            } else if (ArraysMatrixRegionCopier.this.srcJArray != null) {
                ArraysMatrixRegionCopier.this.destArray.setData(destIndex, ArraysMatrixRegionCopier.this.srcJArray, ArraysMatrixRegionCopier.this.srcJArrayOffset + (int)srcIndex, (int)len);
            } else if (len < (long)this.workJArrayLength) {
                ArraysMatrixRegionCopier.this.srcArray.getData(srcIndex, this.workJArray, 0, (int)len);
                ArraysMatrixRegionCopier.this.destArray.setData(destIndex, this.workJArray, 0, (int)len);
            } else {
                ArraysMatrixRegionCopier.this.destArray.subArr(destIndex, len).copy(ArraysMatrixRegionCopier.this.srcArray.subArr(srcIndex, len));
            }
        }
    }

    class DirectDoubleArraysContinuedSegmentFiller2D
    extends ContinuedSegmentFiller2D {
        private final double[] destArray;
        private final int offset;
        private final double filler;

        DirectDoubleArraysContinuedSegmentFiller2D(double[] destArray, int offset, double filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            if (ArraysMatrixRegionCopier.this.destCoordinates[1] < 0L || ArraysMatrixRegionCopier.this.destCoordinates[1] >= ArraysMatrixRegionCopier.this.destDimY) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectDoubleArraysUncheckedSegmentFiller2D
    extends UncheckedSegmentFiller2D {
        private final double[] destArray;
        private final int offset;
        private final double filler;

        DirectDoubleArraysUncheckedSegmentFiller2D(double[] destArray, int offset, double filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectFloatArraysContinuedSegmentFiller2D
    extends ContinuedSegmentFiller2D {
        private final float[] destArray;
        private final int offset;
        private final float filler;

        DirectFloatArraysContinuedSegmentFiller2D(float[] destArray, int offset, float filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            if (ArraysMatrixRegionCopier.this.destCoordinates[1] < 0L || ArraysMatrixRegionCopier.this.destCoordinates[1] >= ArraysMatrixRegionCopier.this.destDimY) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectFloatArraysUncheckedSegmentFiller2D
    extends UncheckedSegmentFiller2D {
        private final float[] destArray;
        private final int offset;
        private final float filler;

        DirectFloatArraysUncheckedSegmentFiller2D(float[] destArray, int offset, float filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectLongArraysContinuedSegmentFiller2D
    extends ContinuedSegmentFiller2D {
        private final long[] destArray;
        private final int offset;
        private final long filler;

        DirectLongArraysContinuedSegmentFiller2D(long[] destArray, int offset, long filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            if (ArraysMatrixRegionCopier.this.destCoordinates[1] < 0L || ArraysMatrixRegionCopier.this.destCoordinates[1] >= ArraysMatrixRegionCopier.this.destDimY) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectLongArraysUncheckedSegmentFiller2D
    extends UncheckedSegmentFiller2D {
        private final long[] destArray;
        private final int offset;
        private final long filler;

        DirectLongArraysUncheckedSegmentFiller2D(long[] destArray, int offset, long filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectIntArraysContinuedSegmentFiller2D
    extends ContinuedSegmentFiller2D {
        private final int[] destArray;
        private final int offset;
        private final int filler;

        DirectIntArraysContinuedSegmentFiller2D(int[] destArray, int offset, int filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            if (ArraysMatrixRegionCopier.this.destCoordinates[1] < 0L || ArraysMatrixRegionCopier.this.destCoordinates[1] >= ArraysMatrixRegionCopier.this.destDimY) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectIntArraysUncheckedSegmentFiller2D
    extends UncheckedSegmentFiller2D {
        private final int[] destArray;
        private final int offset;
        private final int filler;

        DirectIntArraysUncheckedSegmentFiller2D(int[] destArray, int offset, int filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectShortArraysContinuedSegmentFiller2D
    extends ContinuedSegmentFiller2D {
        private final short[] destArray;
        private final int offset;
        private final short filler;

        DirectShortArraysContinuedSegmentFiller2D(short[] destArray, int offset, short filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            if (ArraysMatrixRegionCopier.this.destCoordinates[1] < 0L || ArraysMatrixRegionCopier.this.destCoordinates[1] >= ArraysMatrixRegionCopier.this.destDimY) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectShortArraysUncheckedSegmentFiller2D
    extends UncheckedSegmentFiller2D {
        private final short[] destArray;
        private final int offset;
        private final short filler;

        DirectShortArraysUncheckedSegmentFiller2D(short[] destArray, int offset, short filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectByteArraysContinuedSegmentFiller2D
    extends ContinuedSegmentFiller2D {
        private final byte[] destArray;
        private final int offset;
        private final byte filler;

        DirectByteArraysContinuedSegmentFiller2D(byte[] destArray, int offset, byte filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            if (ArraysMatrixRegionCopier.this.destCoordinates[1] < 0L || ArraysMatrixRegionCopier.this.destCoordinates[1] >= ArraysMatrixRegionCopier.this.destDimY) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectByteArraysUncheckedSegmentFiller2D
    extends UncheckedSegmentFiller2D {
        private final byte[] destArray;
        private final int offset;
        private final byte filler;

        DirectByteArraysUncheckedSegmentFiller2D(byte[] destArray, int offset, byte filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectCharArraysContinuedSegmentFiller2D
    extends ContinuedSegmentFiller2D {
        private final char[] destArray;
        private final int offset;
        private final char filler;

        DirectCharArraysContinuedSegmentFiller2D(char[] destArray, int offset, char filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            if (ArraysMatrixRegionCopier.this.destCoordinates[1] < 0L || ArraysMatrixRegionCopier.this.destCoordinates[1] >= ArraysMatrixRegionCopier.this.destDimY) {
                return;
            }
            if (destMin < 0L) {
                destMin = 0L;
            }
            if (destMax > ArraysMatrixRegionCopier.this.destDimX - 1L) {
                destMax = ArraysMatrixRegionCopier.this.destDimX - 1L;
            }
            if (destMin > destMax) {
                return;
            }
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectCharArraysUncheckedSegmentFiller2D
    extends UncheckedSegmentFiller2D {
        private final char[] destArray;
        private final int offset;
        private final char filler;

        DirectCharArraysUncheckedSegmentFiller2D(char[] destArray, int offset, char filler) {
            this.destArray = destArray;
            this.offset = offset;
            this.filler = filler;
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            int k;
            int len = (int)destMax - (int)destMin + 1;
            int position = (int)ArraysMatrixRegionCopier.this.destCoordinates[1] * (int)ArraysMatrixRegionCopier.this.destDimX + (int)destMin;
            int kMax = k + len;
            for (k = this.offset + position; k < kMax; ++k) {
                this.destArray[k] = this.filler;
            }
        }
    }

    class DirectBitArraysContinuedSegmentFiller2D
    extends ContinuedSegmentFiller2D {
        DirectBitArraysContinuedSegmentFiller2D(ArraysMatrixRegionCopier this$0, long[] destArray, int offset, boolean filler) {
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            super.copyUninterruptedSegment(destMin, destMax);
        }
    }

    class DirectBitArraysUncheckedSegmentFiller2D
    extends UncheckedSegmentFiller2D {
        DirectBitArraysUncheckedSegmentFiller2D(ArraysMatrixRegionCopier this$0, long[] destArray, int offset, boolean filler) {
        }

        @Override
        void copyUninterruptedSegment(long destMin, long destMax) {
            super.copyUninterruptedSegment(destMin, destMax);
        }
    }
}

