/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractObjectArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableObjectArray;

public abstract class AbstractUpdatableObjectArray<E>
extends AbstractObjectArray<E>
implements UpdatableObjectArray<E> {
    protected AbstractUpdatableObjectArray(Class<E> elementType, long initialCapacity, long initialLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        super(elementType, initialCapacity, initialLength, underlyingArraysAreParallel, underlyingArrays);
    }

    protected AbstractUpdatableObjectArray(Class<E> elementType, long initialCapacityAndLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        this(elementType, initialCapacityAndLength, initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
    }

    @Override
    public UpdatableObjectArray<E> subArray(long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        final AbstractUpdatableObjectArray parent = this;
        final long offset = fromIndex;
        return new AbstractUpdatableObjectArray<E>(this, this.elementType, toIndex - fromIndex, this.underlyingArraysAreParallel, this.underlyingArrays){

            @Override
            public E get(long index) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                return parent.get(offset + index);
            }

            @Override
            public void set(long index, E value) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                parent.set(offset + index, value);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, E value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.indexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, E value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.lastIndexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.getData(offset + arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.setData(offset + arrayPos, srcArray, srcArrayOffset, count);
                return this;
            }

            @Override
            public UpdatableObjectArray<E> fill(long position, long count, E value) {
                this.checkSubArrArguments(position, count);
                parent.fill(offset + position, count, value);
                return this;
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, offset + fromIndex, offset + toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public UpdatableObjectArray<E> subArr(long position, long count) {
        return this.subArray(position, position + count);
    }

    @Override
    public abstract void set(long var1, E var3);

    @Override
    public final UpdatableObjectArray<E> fill(E value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableObjectArray<E> fill(long position, long count, E value) {
        Array a = position == 0L && count == this.length() ? this : this.subArr(position, count);
        a.copy(Arrays.nObjectCopies(count, value));
        return this;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public ObjectArray<E> asImmutable() {
        final AbstractUpdatableObjectArray parent = this;
        return new AbstractObjectArray<E>(this, this.elementType, this.length, false, this.underlyingArrays){

            @Override
            public E get(long index) {
                return parent.get(index);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, E value) {
                return parent.indexOf(lowIndex, highIndex, value);
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, E value) {
                return parent.lastIndexOf(lowIndex, highIndex, value);
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                parent.getData(arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public void getData(long arrayPos, Object destArray) {
                parent.getData(arrayPos, destArray);
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, fromIndex, toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, fromIndex, toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, fromIndex, toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public UpdatableArray shallowClone() {
        return (UpdatableArray)super.shallowClone();
    }

    @Override
    public void setElement(long index, Object value) {
        this.set(index, InternalUtils.cast(value));
    }

    @Override
    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        Object[] a = (Object[])InternalUtils.cast(srcArray);
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw this.rangeException(arrayPos);
        }
        if (arrayPos > this.length - (long)count) {
            throw this.rangeException(arrayPos + (long)count - 1L);
        }
        long arrayPosMax = arrayPos + (long)count;
        while (arrayPos < arrayPosMax) {
            this.set(arrayPos, a[srcArrayOffset]);
            ++arrayPos;
            ++srcArrayOffset;
        }
        return this;
    }

    @Override
    public UpdatableArray setData(long arrayPos, Object srcArray) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        if (arrayPos < 0L || arrayPos > this.length) {
            throw this.rangeException(arrayPos);
        }
        int count = ((Object[])srcArray).length;
        if ((long)count > this.length - arrayPos) {
            count = (int)(this.length - arrayPos);
        }
        this.setData(arrayPos, srcArray, 0, count);
        return this;
    }

    @Override
    public void copy(long destIndex, long srcIndex) {
        this.set(destIndex, this.get(srcIndex));
    }

    @Override
    public void copy(long destIndex, long srcIndex, long count) {
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        if (srcIndex <= destIndex && srcIndex + count > destIndex) {
            srcIndex += count;
            destIndex += count;
            for (long k = 0L; k < count; ++k) {
                this.copy(--destIndex, --srcIndex);
            }
        } else {
            for (long k = 0L; k < count; ++k) {
                this.copy(destIndex++, srcIndex++);
            }
        }
    }

    @Override
    public void swap(long firstIndex, long secondIndex) {
        Object temp = this.get(firstIndex);
        this.set(firstIndex, this.get(secondIndex));
        this.set(secondIndex, temp);
    }

    @Override
    public void swap(long firstIndex, long secondIndex, long count) {
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        for (long k = 0L; k < count; ++k) {
            this.swap(firstIndex++, secondIndex++);
        }
    }

    @Override
    public UpdatableArray copy(Array src) {
        AbstractUpdatableObjectArray.defaultCopy(this, src);
        return this;
    }

    @Override
    public UpdatableArray swap(UpdatableArray another) {
        AbstractUpdatableObjectArray.defaultSwap(this, another);
        return this;
    }

    @Override
    public void setNonNew() {
        this.setNewStatus(false);
    }

    @Override
    public UpdatableArray asCopyOnNextWrite() {
        return this.updatableClone(Arrays.SMM);
    }

    @Override
    public UpdatableObjectArray<E> asUnresizable() {
        return this;
    }

    @Override
    public <D> UpdatableObjectArray<D> cast(Class<D> elementType) {
        return (UpdatableObjectArray)InternalUtils.cast(super.cast(elementType));
    }

    @Override
    public String toString() {
        return "unresizable AlgART array Object[" + this.length + "]" + (String)(this.underlyingArrays.length == 0 ? "" : " based on " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : ""));
    }
}

