/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.io.IOError;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ThreadPoolFactory;

public abstract class AbstractThreadPoolFactory
implements ThreadPoolFactory {
    @Override
    public void performTasks(Runnable[] tasks) {
        this.performTasksImpl(null, null, tasks, 0, Integer.MAX_VALUE);
    }

    @Override
    public void performTasks(ThreadFactory threadFactory, Runnable[] tasks) {
        this.performTasksImpl(null, threadFactory, tasks, 0, Integer.MAX_VALUE);
    }

    @Override
    public void performTasks(Array sourceArray, ThreadFactory threadFactory, Runnable[] tasks) {
        Objects.requireNonNull(sourceArray, "Null sourceArray argument");
        this.performTasksImpl(sourceArray, threadFactory, tasks, 0, Integer.MAX_VALUE);
    }

    @Override
    public void performTasks(Runnable[] tasks, int from, int to) {
        this.performTasksImpl(null, null, tasks, from, to);
    }

    @Override
    public void performTasks(ThreadFactory threadFactory, Runnable[] tasks, int from, int to) {
        this.performTasksImpl(null, threadFactory, tasks, from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTasksImpl(Array sourceArray, ThreadFactory threadFactory, Runnable[] tasks, int from, int to) {
        Objects.requireNonNull(tasks, "Null tasks argument");
        if (from > to) {
            throw new IllegalArgumentException("Illegal task indexes: initial index = " + from + " > end index = " + to);
        }
        if (from < 0 || from > tasks.length) {
            throw new ArrayIndexOutOfBoundsException(from);
        }
        if (to > tasks.length) {
            to = tasks.length;
        }
        if (from == to) {
            return;
        }
        if (to - from == 1) {
            tasks[from].run();
            return;
        }
        ExecutorService pool = sourceArray == null ? this.getThreadPool(threadFactory) : this.getThreadPool(sourceArray, threadFactory);
        try {
            Future[] results = new Future[to - from];
            for (int taskIndex = from; taskIndex < to; ++taskIndex) {
                results[taskIndex - from] = pool.submit(tasks[taskIndex]);
            }
            try {
                for (Future future : results) {
                    future.get();
                }
            }
            catch (ExecutionException e) {
                Arrays.throwUncheckedException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new IOError(e);
            }
        }
        finally {
            this.releaseThreadPool(pool);
        }
    }
}

