/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayProcessorWithContextSwitching;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SimpleMemoryModel;

public abstract class AbstractArrayProcessorWithContextSwitching
implements ArrayProcessorWithContextSwitching,
Cloneable {
    private ArrayContext context;
    private MemoryModel memoryModel;

    protected AbstractArrayProcessorWithContextSwitching(ArrayContext context) {
        this.setContext(context);
    }

    @Override
    public ArrayProcessorWithContextSwitching context(ArrayContext newContext) {
        AbstractArrayProcessorWithContextSwitching result;
        try {
            result = (AbstractArrayProcessorWithContextSwitching)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
        result.setContext(newContext);
        return result;
    }

    @Override
    public final ArrayContext context() {
        return this.context;
    }

    public final MemoryModel memoryModel() {
        return this.memoryModel;
    }

    public final ArrayContext contextPart(double fromPart, double toPart) {
        ArrayContext c = this.context();
        return c == null ? null : c.part(fromPart, toPart);
    }

    private void setContext(ArrayContext context) {
        this.context = context;
        this.memoryModel = context == null ? SimpleMemoryModel.getInstance() : context.getMemoryModel();
    }
}

