/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.cast.IsNumberNode;
import com.oracle.truffle.js.nodes.cast.JSNumberToDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.external.XSum;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;

public abstract class SumPreciseNode
extends MathOperation {
    public SumPreciseNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected double sumPrecise(Object items, @Cached RequireObjectCoercibleNode requireObjectCoercible, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached IteratorStepNode iteratorStepNode, @Cached IteratorValueNode iteratorValueNode, @Cached(value="create(getContext())") IteratorCloseNode iteratorCloseNode, @Cached IsNumberNode isNumberNode, @Cached JSNumberToDoubleNode toDoubleNode, @Cached InlinedBranchProfile errorBranch) {
        requireObjectCoercible.executeVoid(items);
        IteratorRecord iter = getIteratorNode.execute(this, items);
        boolean negativeZero = true;
        XSum.SmallAccumulator acc = new XSum.SmallAccumulator();
        try {
            Object next;
            while ((next = iteratorStepNode.execute(iter)) != Boolean.FALSE) {
                Object nextValue = iteratorValueNode.execute(next);
                if (isNumberNode.execute(this, nextValue)) {
                    double doubleValue = toDoubleNode.execute(this, nextValue);
                    if (JSRuntime.isNegativeZero(doubleValue)) continue;
                    negativeZero = false;
                    acc.add(doubleValue);
                    continue;
                }
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorNotANumber(nextValue);
            }
            return negativeZero ? -0.0 : acc.round();
        }
        catch (AbstractTruffleException ex) {
            errorBranch.enter((Node)this);
            iteratorCloseNode.executeAbrupt(iter.getIterator());
            throw ex;
        }
    }
}

