/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parsington.eval;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Function;
import org.scijava.parsington.Group;
import org.scijava.parsington.Operator;
import org.scijava.parsington.SyntaxTree;
import org.scijava.parsington.Tokens;
import org.scijava.parsington.eval.Evaluator;

public interface StackEvaluator
extends Evaluator {
    public Object execute(Operator var1, Deque<Object> var2);

    @Override
    default public Object evaluate(String expression) {
        return this.evaluate(this.getParser().parsePostfix(expression));
    }

    @Override
    default public Object evaluate(SyntaxTree syntaxTree) {
        return this.evaluate(syntaxTree.postfix());
    }

    @Override
    default public Object evaluate(LinkedList<Object> queue) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        while (!queue.isEmpty()) {
            Object token = queue.removeFirst();
            Object result = Tokens.isOperator(token) ? this.execute((Operator)token, stack) : token;
            if (result == null) {
                StringBuilder message = new StringBuilder("Unsupported");
                if (token instanceof Operator) {
                    int arity = ((Operator)token).getArity();
                    String[] aryNames = new String[]{"nullary", "unary", "binary", "ternary", "quaternary", "quinary", "senary", "septenary", "octary", "nonary"};
                    String aryName = arity < aryNames.length ? aryNames[arity] : arity + "-ary";
                    message.append(" " + aryName);
                }
                String type = token instanceof Function ? "function" : (token instanceof Group ? "group" : (token instanceof Operator ? "operator" : "token"));
                message.append(" " + type + ": " + token);
                throw new IllegalArgumentException(message.toString());
            }
            stack.push(result);
        }
        if (stack.isEmpty()) {
            return null;
        }
        if (stack.size() == 1) {
            return stack.pop();
        }
        LinkedList resultList = new LinkedList();
        while (!stack.isEmpty()) {
            resultList.addFirst(stack.pop());
        }
        return resultList;
    }
}

