/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.video;

import net.algart.executors.modules.opencv.matrices.video.AbstractBackgroundSubtractor;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_video;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_video.BackgroundSubtractor;

public final class BackgroundSubtractorKNN
extends AbstractBackgroundSubtractor {
    private double dist2Threshold = 400.0;

    public double getDist2Threshold() {
        return this.dist2Threshold;
    }

    public void setDist2Threshold(double dist2Threshold) {
        this.dist2Threshold = dist2Threshold;
    }

    @Override
    BackgroundSubtractor createBackgroundSubtractor() {
        BackgroundSubtractorKNN.logDebug(() -> "Creating BackgroundSubtractorKNN: dist2Threshold " + this.dist2Threshold);
        return opencv_video.createBackgroundSubtractorKNN((int)500, (double)this.dist2Threshold, (boolean)this.isDetectShadows());
    }

    public static void main(String[] args) {
        String sourceFile = args[0];
        String targetFile = args[1];
        String backgroundFile = args[2];
        Mat source = opencv_imgcodecs.imread((String)sourceFile);
        BackgroundSubtractorKNN subtractor = new BackgroundSubtractorKNN();
        subtractor.requestOutput(new String[]{"background"});
        Mat target = subtractor.process(source);
        opencv_imgcodecs.imwrite((String)targetFile, (Mat)target);
        opencv_imgcodecs.imwrite((String)backgroundFile, (Mat)subtractor.getBackground());
    }
}

