/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.recognition;

import net.algart.executors.modules.opencv.common.VoidResultTwoUMatFilter;
import net.algart.executors.modules.opencv.util.enums.OTemplateMatchMode;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.UMat;

public final class MatchTemplate
extends VoidResultTwoUMatFilter {
    public static final String INPUT_TEMPLATE = "template";
    public static final String OUTPUT_X = "x";
    public static final String OUTPUT_Y = "y";
    private OTemplateMatchMode templateMatchMode = OTemplateMatchMode.TM_SQDIFF;

    public MatchTemplate() {
        super(null, INPUT_TEMPLATE);
        this.addOutputScalar(OUTPUT_X);
        this.addOutputScalar(OUTPUT_Y);
    }

    public OTemplateMatchMode getTemplateMatchMode() {
        return this.templateMatchMode;
    }

    public void setTemplateMatchMode(OTemplateMatchMode templateMatchMode) {
        this.templateMatchMode = (OTemplateMatchMode)((Object)MatchTemplate.nonNull((Object)((Object)templateMatchMode)));
    }

    @Override
    public void process(Mat result, Mat source, Mat secondMat) {
        opencv_imgproc.matchTemplate((Mat)source, (Mat)secondMat, (Mat)result, (int)this.templateMatchMode.code());
        double[] minVal = new double[1];
        double[] maxVal = new double[1];
        try (Point minLocation = new Point();
             Point maxLocation = new Point();){
            double y;
            double x;
            opencv_core.minMaxLoc((Mat)result, (double[])minVal, (double[])maxVal, (Point)minLocation, (Point)maxLocation, null);
            if (this.templateMatchMode == OTemplateMatchMode.TM_SQDIFF || this.templateMatchMode == OTemplateMatchMode.TM_SQDIFF_NORMED) {
                x = minLocation.x();
                y = minLocation.y();
            } else {
                x = maxLocation.x();
                y = maxLocation.y();
            }
            this.getScalar(OUTPUT_X).setTo(x);
            this.getScalar(OUTPUT_Y).setTo(y);
        }
    }

    @Override
    public void process(UMat result, UMat source, UMat secondMat) {
        opencv_imgproc.matchTemplate((UMat)source, (UMat)secondMat, (UMat)result, (int)this.templateMatchMode.code());
        double[] minVal = new double[1];
        double[] maxVal = new double[1];
        try (Point minLocation = new Point();
             Point maxLocation = new Point();){
            double y;
            double x;
            opencv_core.minMaxLoc((UMat)result, (double[])minVal, (double[])maxVal, (Point)minLocation, (Point)maxLocation, null);
            if (this.templateMatchMode == OTemplateMatchMode.TM_SQDIFF || this.templateMatchMode == OTemplateMatchMode.TM_SQDIFF_NORMED) {
                x = minLocation.x();
                y = minLocation.y();
            } else {
                x = maxLocation.x();
                y = maxLocation.y();
            }
            this.getScalar(OUTPUT_X).setTo(x);
            this.getScalar(OUTPUT_Y).setTo(y);
        }
    }

    @Override
    protected boolean dimensionsEqualityRequired() {
        return false;
    }
}

