/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.recognition;

import java.awt.Rectangle;
import java.nio.file.Path;
import java.util.List;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.executors.modules.opencv.common.UMatToNumbers;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class CascadeClassifier
extends UMatToNumbers {
    public static final String VISUAL_RESULTS = "visual_results";
    private String classifierFile = "";
    private boolean relativizePath = false;
    private double scaleFactor = 1.1;
    private int minNeighbors = 3;
    private int minSizeX = 0;
    private int minSizeY = 0;
    private int maxSizeX = 0;
    private int maxSizeY = 0;
    private boolean finsOnlyCenters = false;
    private boolean drawOnInput = false;
    private ResultMarkerType resultMarkerType = ResultMarkerType.RECTANGLE;
    private int drawingLineThickness = 0;

    public CascadeClassifier() {
        this.addOutputMat(VISUAL_RESULTS);
    }

    public String getClassifierFile() {
        return this.classifierFile;
    }

    public void setClassifierFile(String classifierFile) {
        this.classifierFile = (String)CascadeClassifier.nonNull((Object)classifierFile);
    }

    public boolean isRelativizePath() {
        return this.relativizePath;
    }

    public CascadeClassifier setRelativizePath(boolean relativizePath) {
        this.relativizePath = relativizePath;
        return this;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = CascadeClassifier.positive((double)scaleFactor);
    }

    public int getMinNeighbors() {
        return this.minNeighbors;
    }

    public void setMinNeighbors(int minNeighbors) {
        this.minNeighbors = CascadeClassifier.positive((int)minNeighbors);
    }

    public int getMinSizeX() {
        return this.minSizeX;
    }

    public void setMinSizeX(int minSizeX) {
        this.minSizeX = CascadeClassifier.nonNegative((int)minSizeX);
    }

    public int getMinSizeY() {
        return this.minSizeY;
    }

    public void setMinSizeY(int minSizeY) {
        this.minSizeY = CascadeClassifier.nonNegative((int)minSizeY);
    }

    public int getMaxSizeX() {
        return this.maxSizeX;
    }

    public void setMaxSizeX(int maxSizeX) {
        this.maxSizeX = CascadeClassifier.nonNegative((int)maxSizeX);
    }

    public int getMaxSizeY() {
        return this.maxSizeY;
    }

    public void setMaxSizeY(int maxSizeY) {
        this.maxSizeY = CascadeClassifier.nonNegative((int)maxSizeY);
    }

    public boolean isFinsOnlyCenters() {
        return this.finsOnlyCenters;
    }

    public void setFinsOnlyCenters(boolean finsOnlyCenters) {
        this.finsOnlyCenters = finsOnlyCenters;
    }

    public boolean isDrawOnInput() {
        return this.drawOnInput;
    }

    public void setDrawOnInput(boolean drawOnInput) {
        this.drawOnInput = drawOnInput;
    }

    public ResultMarkerType getResultMarkerType() {
        return this.resultMarkerType;
    }

    public void setResultMarkerType(ResultMarkerType resultMarkerType) {
        this.resultMarkerType = resultMarkerType;
    }

    public int getDrawingLineThickness() {
        return this.drawingLineThickness;
    }

    public void setDrawingLineThickness(int drawingLineThickness) {
        this.drawingLineThickness = CascadeClassifier.nonNegative((int)drawingLineThickness);
    }

    @Override
    public SNumbers analyse(Mat source) {
        List<Rectangle> rectangles;
        String file = CascadeClassifier.nonEmpty((String)this.classifierFile, (String)"classifier file name");
        Path path = PathPropertyReplacement.translatePropertiesAndCurrentDirectory((String)file, (Executor)this);
        path = FileOperation.simplifyOSPath((Path)path, (boolean)this.relativizePath);
        try (org.bytedeco.opencv.opencv_objdetect.CascadeClassifier classifier = new org.bytedeco.opencv.opencv_objdetect.CascadeClassifier(path.toString());){
            rectangles = this.classify(classifier, source);
            CascadeClassifier.logDebug(() -> "Cascade classifier found " + rectangles.size() + " objects (source: " + String.valueOf(source) + ")");
        }
        if (this.isOutputNecessary(VISUAL_RESULTS)) {
            Mat mask = this.drawOnInput ? source.clone() : OTools.constantMonoMat8U(source.rows(), source.cols(), 0);
            try (Scalar color = new Scalar(255.0, 255.0, 255.0, 255.0);){
                this.drawRectangles(mask, rectangles, color);
            }
            O2SMat.setTo(this.getMat(VISUAL_RESULTS), mask);
        }
        return this.makeResult(rectangles);
    }

    @Override
    public SNumbers analyse(UMat source) {
        List<Rectangle> rectangles;
        String file = CascadeClassifier.nonEmpty((String)this.classifierFile, (String)"classifier file name");
        Path path = PathPropertyReplacement.translatePropertiesAndCurrentDirectory((String)file, (Executor)this);
        path = FileOperation.simplifyOSPath((Path)path, (boolean)this.relativizePath);
        try (org.bytedeco.opencv.opencv_objdetect.CascadeClassifier classifier = new org.bytedeco.opencv.opencv_objdetect.CascadeClassifier(path.toString());){
            rectangles = this.classify(classifier, source);
            CascadeClassifier.logDebug(() -> "Cascade classifier (GPU) found " + rectangles.size() + " objects (source: " + String.valueOf(source) + ")");
        }
        if (this.isOutputNecessary(VISUAL_RESULTS)) {
            Mat mask = this.drawOnInput ? OTools.toMat(source) : OTools.constantMonoMat8U(source.rows(), source.cols(), 0);
            try (Scalar color = new Scalar(255.0, 255.0, 255.0, 255.0);){
                this.drawRectangles(mask, rectangles, color);
            }
            O2SMat.setTo(this.getMat(VISUAL_RESULTS), mask);
        }
        return this.makeResult(rectangles);
    }

    public String visibleOutputPortName() {
        return VISUAL_RESULTS;
    }

    /*
     * Exception decompiling
     */
    private List<Rectangle> classify(org.bytedeco.opencv.opencv_objdetect.CascadeClassifier classifier, Mat mat) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<Rectangle> classify(org.bytedeco.opencv.opencv_objdetect.CascadeClassifier classifier, UMat mat) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SNumbers makeResult(List<Rectangle> rectangles) {
        int resultBlockLength = this.finsOnlyCenters ? 2 : 4;
        int[] result = new int[resultBlockLength * rectangles.size()];
        int n = rectangles.size();
        int disp = 0;
        for (int k = 0; k < n; ++k) {
            Rectangle r = rectangles.get(k);
            result[disp++] = r.x + r.width / 2;
            result[disp++] = r.y + r.height / 2;
            if (this.finsOnlyCenters) continue;
            result[disp++] = r.width;
            result[disp++] = r.height;
        }
        return SNumbers.ofArray((Object)result, (int)resultBlockLength);
    }

    /*
     * Unable to fully structure code
     */
    private void drawRectangles(Mat mat, List<Rectangle> rectangles, Scalar color) {
lbl1:
        // 8 sources

        block20: for (Rectangle r : rectangles) {
            rect = new Rect(r.x, r.y, r.width, r.height);
            try {
                center = new Point(r.x + r.width / 2, r.y + r.height / 2);
                try {
                    sizes = new Size(r.width / 2, r.height / 2);
                    try {
                        switch (this.resultMarkerType.ordinal()) {
                            case 0: {
                                opencv_imgproc.rectangle((Mat)mat, (Rect)rect, (Scalar)color, (int)(this.drawingLineThickness == 0 ? -1 : this.drawingLineThickness), (int)8, (int)0);
                                ** break;
                            }
                            case 2: {
                                opencv_imgproc.circle((Mat)mat, (Point)center, (int)Math.min(r.width / 2, r.height / 2), (Scalar)color, (int)(this.drawingLineThickness == 0 ? -1 : this.drawingLineThickness), (int)16, (int)0);
                                ** break;
                            }
                            case 1: {
                                opencv_imgproc.ellipse((Mat)mat, (Point)center, (Size)sizes, (double)0.0, (double)0.0, (double)360.0, (Scalar)color, (int)(this.drawingLineThickness == 0 ? -1 : this.drawingLineThickness), (int)16, (int)0);
                                continue block20;
                            }
                            ** default:
lbl19:
                            // 1 sources

                            continue block20;
                        }
                    }
                    finally {
                        sizes.close();
                    }
                }
                finally {
                    center.close();
                }
            }
            finally {
                rect.close();
            }
        }
    }

    public static enum ResultMarkerType {
        RECTANGLE,
        ELLIPSE,
        CIRCLE;

    }
}

