/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.features.detection;

import java.nio.file.Path;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class StructuredEdgeDetection
extends VoidResultUMatFilter {
    private String modelFile = "";
    private boolean relativizePath = false;

    public String getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(String modelFile) {
        this.modelFile = (String)StructuredEdgeDetection.nonNull((Object)modelFile);
    }

    public boolean isRelativizePath() {
        return this.relativizePath;
    }

    public StructuredEdgeDetection setRelativizePath(boolean relativizePath) {
        this.relativizePath = relativizePath;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Mat result, Mat source) {
        String file = StructuredEdgeDetection.nonEmpty((String)this.modelFile, (String)"model file name");
        Path path = PathPropertyReplacement.translatePropertiesAndCurrentDirectory((String)file, (Executor)this);
        path = FileOperation.simplifyOSPath((Path)path, (boolean)this.relativizePath);
        Mat mat = source;
        try {
            mat = OTools.to32FIfNot(source);
            try (org.bytedeco.opencv.opencv_ximgproc.StructuredEdgeDetection detection = opencv_ximgproc.createStructuredEdgeDetection((String)path.toString());){
                detection.detectEdges(mat, result);
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(UMat result, UMat source) {
        String file = StructuredEdgeDetection.nonEmpty((String)this.modelFile, (String)"model file name");
        Path path = PathPropertyReplacement.translatePropertiesAndCurrentDirectory((String)file, (Executor)this);
        path = FileOperation.simplifyOSPath((Path)path, (boolean)this.relativizePath);
        UMat mat = source;
        try {
            mat = OTools.to32FIfNot(source);
            try (org.bytedeco.opencv.opencv_ximgproc.StructuredEdgeDetection detection = opencv_ximgproc.createStructuredEdgeDetection((String)path.toString());){
                detection.detectEdges(mat, result);
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }
}

