/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.common;

import java.lang.ref.Cleaner;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.opencv.global.opencv_core;

public abstract class OpenCVExecutor
extends Executor {
    private static final Cleaner CLEANER;
    private final FinalizationKeeper finalizationKeeper = new FinalizationKeeper(this.toString());
    private boolean useGPU = true;

    protected OpenCVExecutor() {
        CLEANER.register((Object)this, this.finalizationKeeper);
    }

    public boolean useGPU() {
        return OTools.isGPUOptimizationEnabled() && this.useGPU;
    }

    public boolean isUseGPU() {
        return this.useGPU;
    }

    public void setUseGPU(boolean useGPU) {
        this.useGPU = useGPU;
    }

    public final void setMat(String name, MultiMatrix mat) {
        this.getInputMatContainer(name).setTo(mat);
    }

    public final void putMat(String name, MultiMatrix mat) {
        this.addInputMat(name);
        this.setMat(name, mat);
    }

    public void postprocess() {
        super.postprocess();
    }

    public void close() {
        super.close();
        this.finalizationKeeper.normallyClosed = true;
    }

    static {
        if (SHOW_INFO_ON_STARTUP) {
            System.out.println();
            System.out.printf("OpenCV version %s%n", OTools.openCVVersion());
            System.out.printf("OpenCV GPU optimization: %s%n%n", OTools.isGPUOptimizationEnabled() ? "enabled" : (opencv_core.haveOpenCL() ? "disabled" : "unavailable"));
        }
        CLEANER = Cleaner.create();
    }

    private static class FinalizationKeeper
    implements Runnable {
        private final String name;
        private boolean normallyClosed;

        private FinalizationKeeper(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            if (!this.normallyClosed) {
                Executor.LOG.log(System.Logger.Level.ERROR, "CLEANING WARNING! OpenCV-based executor was not closed: " + this.name);
            }
        }
    }
}

